/*
CardDavMATE - CardDav Web Client
Copyright (C) 2011-2013 Jan Mate <jan.mate@inf-it.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// NOTE: sort the languages alphabetically by the _name_ property!

// NOTE: console.log(...) messages are not translated
var localization = new Object();

localization['cs_CZ']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_name_: 'Čeština',
	_default_datepicker_format_: 'dd.mm.yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Odhlásit',
	buttonLogin: 'Přihlásit',
	pholderUsername: 'Přihlašovací jméno',
	pholderPassword: 'Heslo',
	txtResources: 'Prostředky',
	txtSearch: 'Hledat',
	txtNote: 'Poznámky',

	buttonEdit: 'Editovat',
	buttonSave: 'Uložit',
	buttonDelete: 'Vymazat',

	unsupportedBrowser: 'Upozornění: Váš prohlížeč je nepodporovaný!',

	errUnableSync: 'Chyba: \'nepodařilo se synchronizovat prostředek\': zkuste to později!',
	errHttpCommon: 'chybový kód %%',
	errHttp401: 'neautorizovaný',
	errHttp403: 'přístup zamítnut',
	errHttp405: 'nepovolená metoda',
	errHttp408: 'vypršení doby požadavku',
	errHttp412: 'někdo jiný ho právě změnil na serveru',
	errHttp500: 'vnitřní chyba serveru',
	errHttp501: 'neimplementováno',

	loadingResources: 'Načítaní prostředků (%act% z %total%) ...',
	updateNotification: '%name% %new_ver% dostupný (používáte %curr_ver%) - %url%'
}

localization['da_DK']=	/* thanks Niels Bo Andersen */
{
	_name_: 'Dansk',
	_default_datepicker_format_: 'dd-mm-yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Log ud',
	buttonLogin: 'Log ind',
	pholderUsername: 'Brugernavn',
	pholderPassword: 'Kodeord',
	txtResources: 'Ressourcer',
	txtSearch: 'Søg',
	txtNote: 'Note',

	buttonEdit: 'Rediger',
	buttonSave: 'Gem',
	buttonDelete: 'Slet',

	unsupportedBrowser: 'Bemærk: Din browser er ikke understøttet!',

	errUnableSync: 'Fejl: \'kunne ikke synkronisere ressource\': prøv igen senere!',
	errHttpCommon: 'fejlkode %%',
	errHttp401: 'uautoriseret',
	errHttp403: 'forbudt',
	errHttp405: 'metode ikke tilladt',
	errHttp408: 'forespørgsels-timeout',
	errHttp412: 'emnet er ændret af en anden på serveren',
	errHttp500: 'intern serverfejl',
	errHttp501: 'ikke implementeret',

	loadingResources: 'Henter ressourcer (%act% af %total%) ...',
	updateNotification: '%name% %new_ver% er frigivet (du har %curr_ver%) - %url%'
}

localization['de_DE']=	/* thanks Marten Gajda and Thomas Scheel */
{
	_name_: 'Deutsch',
	_default_datepicker_format_: 'dd.mm.yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Abmelden',
	buttonLogin: 'Anmelden',
	pholderUsername: 'Benutzername',
	pholderPassword: 'Passwort',
	txtResources: 'Ressourcen',
	txtSearch: 'Suchen',
	txtNote: 'Notiz',

	buttonEdit: 'Bearbeiten',
	buttonSave: 'Speichern',
	buttonDelete: 'Löschen',

	unsupportedBrowser: 'Hinweis: Der verwendete Browser wird nicht unterstützt!',

	errUnableSync: 'Fehler: \'Ressource konnte nicht syncronisiert werden\': Versuchen Sie es später noch einmal!',
	errHttpCommon: 'Fehler Code %%',
	errHttp401: 'nicht berechtigt',
	errHttp403: 'verboten',
	errHttp405: 'Befehl nicht erlaubt',
	errHttp408: 'Anfrage-Timeout',
	errHttp412: 'Kontakt wurde zwischenzeitlich auf der Server geändert',
	errHttp500: 'Interner Server Fehler',
	errHttp501: 'Nicht unterstützt',

	loadingResources: 'Lade Ressourcen (%act% von %total%) ...',
	updateNotification: '%name% %new_ver% verfügbar (Sie haben %curr_ver%) - %url%'
}

localization['en_US']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_name_: 'English',
	_default_datepicker_format_: 'yy-mm-dd',
	_default_AMPM_format_: true,

	altLogo: 'Logo',
	altLogout: 'Logout',
	buttonLogin: 'Login',
	pholderUsername: 'Username',
	pholderPassword: 'Password',
	txtResources: 'Resources',
	txtSearch: 'Search',
	txtNote: 'Note',

	buttonEdit: 'Edit',
	buttonSave: 'Save',
	buttonDelete: 'Delete',

	unsupportedBrowser: 'Note: your browser is unsupported!',

	errUnableSync: 'Error: \'unable to sync resource\': try again later!',
	errHttpCommon: 'error code %%',
	errHttp401: 'unauthorized',
	errHttp403: 'forbidden',
	errHttp405: 'method not allowed',
	errHttp408: 'request timeout',
	errHttp412: 'somebody else has already changed it on the server',
	errHttp500: 'internal server error',
	errHttp501: 'not implemented',

	loadingResources: 'Loading resources (%act% of %total%) ...',
	updateNotification: '%name% %new_ver% available (you have %curr_ver%) - %url%'
}

localization['fr_FR']=	/* thanks John Fischer */
{
	_name_: 'Français',
	_default_datepicker_format_: 'dd-mm-yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Déconnexion',
	buttonLogin: 'Connexion',
	pholderUsername: 'Identifiant',
	pholderPassword: 'Mot de Passe',
	txtResources: 'Resources',
	txtSearch: 'Rechercher',
	txtNote: 'Note',

	buttonEdit: 'Editer',
	buttonSave: 'Sauvegarder',
	buttonDelete: 'Supprimer',

	unsupportedBrowser: 'Note: votre navigateur n`est pas supporté!',

	errUnableSync: 'Erreur: \'impossible de synchroniser la ressource\': essayer à nouveau plutard!',
	errHttpCommon: 'code d\'erreur %%',
	errHttp401: 'non autorisé',
	errHttp403: 'interdit',
	errHttp405: 'methode non autorisé',
	errHttp408: 'request timeout',
	errHttp412: 'quelqu\'un d\'autre a la déjà modifié sur le serveur',
	errHttp500: 'erreur interne du serveur',
	errHttp501: 'non implémenté',

	loadingResources: 'Chargement des ressources (%act% sur %total%)...',
	updateNotification: '%name% %new_ver% est disponible (vous ètes actuellement en version %curr_ver%) - %url%'
}

localization['hu_HU']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_name_: 'Magyar',
	_default_datepicker_format_: 'yy.mm.dd',
	_default_AMPM_format_: false,

	altLogo: 'Logó',
	altLogout: 'Kijelentkezés',
	buttonLogin: 'Bejelentkezés',
	pholderUsername: 'Felhasználónév',
	pholderPassword: 'Jelszó',
	txtResources: 'Források',
	txtSearch: 'Keresés',
	txtNote: 'Jegyzetek',

	buttonEdit: 'Szerkesztés',
	buttonSave: 'Mentés',
	buttonDelete: 'Törlés',

	unsupportedBrowser: 'Figyelmeztetés: A böngészője nem támogatott!',

	errUnableSync: 'Hiba: \'nem sikerült a forrás szinkronizálása\': próbálkozzon később!',
	errHttpCommon: 'hiba kód %%',
	errHttp401: 'nincs hitelesítve',
	errHttp403: 'tiltva',
	errHttp405: 'nem engedélyezett módszer',
	errHttp408: 'kérelem időtúllépése',
	errHttp412: 'valaki más már megváltoztatta a szerveren',
	errHttp500: 'belső szerverhiba',
	errHttp501: 'nincs megvalósítva',

	loadingResources: 'Források betöltése (%act%/%total%) ...',
	updateNotification: '%name% %new_ver% elérhető (jelenlegi verzió: %curr_ver%) - %url%'
}

localization['it_IT']=	/* thanks Luca Ferrario */
{
	_name_: 'Italiano',
	_default_datepicker_format_: 'dd/mm/yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Logout',
	buttonLogin: 'Login',
	pholderUsername: 'Nome Utente',
	pholderPassword: 'Password',
	txtResources: 'Risorse',
	txtSearch: 'Cerca',
	txtNote: 'Note',

	buttonEdit: 'Modifica',
	buttonSave: 'Salva',
	buttonDelete: 'Elimina',

	unsupportedBrowser: 'Attenzione: browser non supportato!',

	errUnableSync: 'Errore: \'impossibile sincronizzare la risorsa\': riprovare!',
	errHttpCommon: 'codice errore %%',
	errHttp401: 'non autorizzato',
	errHttp403: 'proibito',
	errHttp405: 'metodo non consentito',
	errHttp408: 'timeout della richiesta',
	errHttp412: 'qualcun altro l\'ha già modificato sul server',
	errHttp500: 'errore interno del server',
	errHttp501: 'non implementato',

	loadingResources: 'Caricamento risorse (%act% di %total%) ...',
	updateNotification: '%name% %new_ver% disponibile (versione attuale: %curr_ver%) - %url%'
}

localization['nl_NL']=	/* thanks Johan Vromans */
{
	_name_: 'Nederlands',
	_default_datepicker_format_: 'dd-mm-yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Uitloggen',
	buttonLogin: 'Inloggen',
	pholderUsername: 'Gebruikersnaam',
	pholderPassword: 'Wachtwoord',
	txtResources: 'Bronnen',
	txtSearch: 'Zoeken',
	txtNote: 'Opmerking',

	buttonEdit: 'Wijzigen',
	buttonSave: 'Opslaan',
	buttonDelete: 'Verwijderen',

	unsupportedBrowser: 'Attentie: uw browser wordt niet ondersteund!',

	errUnableSync: 'Fout: Synchronisatie mislukt, probeer later nog eens!',
	errHttpCommon: 'Foutcode %%',
	errHttp401: 'geen toegang',
	errHttp403: 'verboden',
	errHttp405: 'bewerking niet toegestaan',
	errHttp408: 'verwerking afgebroken wegens timeout',
	errHttp412: 'iemand anders heeft dit reeds gewijzigd op de server',
	errHttp500: 'interne serverfout',
	errHttp501: 'niet geïmplementeerd',

	loadingResources: 'Laden (%act% van %total%) ...',
	updateNotification: 'Er is een nieuwe versie van %name% beschikbaar: %new_ver% (u heeft nu %curr_ver%) - %url%'
}

localization['sk_SK']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_name_: 'Slovenčina',
	_default_datepicker_format_: 'dd.mm.yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Odhlásiť',
	buttonLogin: 'Prihlásiť',
	pholderUsername: 'Prihlasovacie meno',
	pholderPassword: 'Heslo',
	txtResources: 'Prostriedky',
	txtSearch: 'Vyhľadať',
	txtNote: 'Poznámky',

	buttonEdit: 'Editovať',
	buttonSave: 'Uložiť',
	buttonDelete: 'Vymazať',

	unsupportedBrowser: 'Upozornenie: Váš prehliadač je nepodporovaný!',

	errUnableSync: 'Chyba: \'nepodarilo sa synchronizovať prostriedok\': skúste to neskôr!',
	errHttpCommon: 'chybový kód %%',
	errHttp401: 'neautorizovaný',
	errHttp403: 'prístup zamietnutý',
	errHttp405: 'nepovolená metóda',
	errHttp408: 'časový limit vypršal',
	errHttp412: 'niekto iný ho práve zmenil na serveri',
	errHttp500: 'vnútorná chyba servera',
	errHttp501: 'neimplementované',

	loadingResources: 'Načítavanie prostriedkov (%act% z %total%) ...',
	updateNotification: '%name% %new_ver% dostupný (používate %curr_ver%) - %url%'
}

localization['tr_TR']=	/* thanks Selcuk Pultar */
{
	_name_: 'Türkçe',
	_default_datepicker_format_: 'dd-mm-yy',
	_default_AMPM_format_: true,

	altLogo: 'Logo',
	altLogout: 'Çıkış',
	buttonLogin: 'Giriş',
	pholderUsername: 'Kullanıcı Adı',
	pholderPassword: 'Parola',
	txtResources: 'Kaynaklar',
	txtSearch: 'Ara',
	txtNote: 'Not',

	buttonEdit: 'Düzenle',
	buttonSave: 'Kaydet',
	buttonDelete: 'Sil',

	unsupportedBrowser: 'Not: tarayıcınız desteklenmemektedir!',

	errUnableSync: 'Hata: \'kaynak eşlenememiştir\': sonra yeniden deneyin!',
	errHttpCommon: 'hata kodu %%',
	errHttp401: 'yetkisiz',
	errHttp403: 'yasak',
	errHttp405: 'metoda izin verilmemiştir',
	errHttp408: 'istek zaman aşımı',
	errHttp412: 'başkası sunucuda zaten değiştirmiş',
	errHttp500: 'dahili sunucu hatası',
	errHttp501: 'henüz uygulamaya geçirilmemiştir',

	loadingResources: 'Kaynaklar yükleniyor (%total% taneden %act%) ...',
	updateNotification: '%name% %new_ver% hazır (sizde %curr_ver% var) - %url%'
}

var localizationCardDAV = new Object();
localizationCardDAV['cs_CZ']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	/* index.html */
	altAddContact: 'Přidat kontakt',
	altPhoto: 'Fotka',
	txtAddressbook: 'Adresář',
	txtCompanies: 'Firmy',
	txtContact: 'Kontakt',
	pholderGiven: 'Jméno',
	pholderFamily: 'Příjmení',
	pholderMiddle: 'Druhé jméno',
	pholderNickname: 'Přezdívka',
	pholderPhGiven: 'Jméno foneticky',
	pholderPhFamily: 'Příjmení foneticky',
	pholderPrefix: 'Před jménem',
	pholderSuffix: 'Za jménem',
	pholderBday: 'Narozeniny',
	pholderAnniversary: 'Výročí',
	pholderTitle: 'Zařazení',
	pholderOrg: 'Firma',
	pholderDepartment: 'Oddělení',
	txtCompanyContact: 'Kontakt na společnost',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» vlastní',
	pholderCustomVal: 'vlastní',

	txtPhone: 'Telefon',
	txtPhoneWork: 'práce',
	txtPhoneHome: 'domov',
	txtPhoneCell: 'mobil',
	txtPhoneCellWork: 'mobil (práce)',
	txtPhoneCellHome: 'mobil (domov)',
	txtPhoneMain: 'centrála',
	txtPhonePager: 'pager',
	txtPhoneFax: 'fax',
	txtPhoneFaxWork: 'fax (práce)',
	txtPhoneFaxHome: 'fax (domov)',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'jiné',
	pholderPhoneVal: 'Telefon',

	txtEmail: 'E-mail',
	txtEmailWork: 'práce',
	txtEmailHome: 'domov',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'jiné',
	pholderEmailVal: 'E-mail',

	txtUrl: 'Web',
	txtUrlWork: 'práce',
	txtUrlHome: 'domov',
	txtUrlHomepage: 'web',
	txtUrlOther: 'jiné',
	pholderUrlVal: 'URL',

	txtRelated: 'Příbuzné osoby',
	txtRelatedFather: 'otec',
	txtRelatedMother: 'matka',
	txtRelatedParent: 'rodič',
	txtRelatedBrother: 'bratr',
	txtRelatedSister: 'sestra',
	txtRelatedChild: 'dítě',
	txtRelatedFriend: 'přítel',
	txtRelatedSpouse: 'manžel(ka)',
	txtRelatedPartner: 'partner',
	txtRelatedAssistant: 'asistent',
	txtRelatedManager: 'manažer',
	txtRelatedOther: 'jiné',
	pholderRelatedVal: 'Jméno',

	txtIm: 'Adresa IM',
	txtImWork: 'práce',
	txtImHome: 'domov',
	txtImMobileme: 'mobileMe',
	txtImOther: 'jiné',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'Uživatel',

	txtProfile: 'Profil',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'Uživatel',

	txtAddress: 'Adresa',
	txtAddressWork: 'práce',
	txtAddressHome: 'domov',
	txtAddressOther: 'jiné',
	// address fields are handled specially

	txtCategories: 'Kategorie',
	// categories' values are handled specially

	pholderNoteVal: 'Text',

	buttonCancel: 'Storno',
	buttonDeleteFromGroup: 'Vymazat ze skupiny',

	/* common.js - address field names */
	pholderAddressCity: 'Město',
	pholderAddressCityRegion: 'Město/Region',
	pholderAddressCounty: 'Okres',
	pholderAddressCountyCity: 'Okres/Město',
	pholderAddressDepartment: 'Oddělení',
	pholderAddressDistrict: 'Okrsek',
	pholderAddressDistrictSubdivision: 'Okrsek/Pododdíl',
	pholderAddressFurtherDivisions: 'Další rozdělení',
	pholderAddressGovernorate: 'Gubernie',
	pholderAddressIslandName: 'Název ostrova',
	pholderAddressPinCode: 'Kód PIN',
	pholderAddressPostCode: 'PSČ',
	pholderAddressPostal: 'PSČ',
	pholderAddressPostalCode: 'PSČ',
	pholderAddressPostalDistrict: 'Poštovní okrsek',
	pholderAddressPrefecture: 'Prefektura',
	pholderAddressProvince: 'Kraj',
	pholderAddressRegion: 'Region',
	pholderAddressState: 'Stát',
	pholderAddressStreet: 'Ulice',
	pholderAddressSuburb: 'Čtvrť',
	pholderAddressTownshipDistrict: 'Městký okrsek/Čtvrť',
	pholderAddressZip: 'PSČ',

	txtAddressCountryAF: 'Afghánistán',
	txtAddressCountryAL: 'Albánie',
	txtAddressCountryDZ: 'Alžírsko',
	txtAddressCountryAD: 'Andorra',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua a Barbuda',
	txtAddressCountryAR: 'Argentina',
	txtAddressCountryAM: 'Arménie',
	txtAddressCountryAU: 'Austrálie',
	txtAddressCountryAT: 'Rakousko',
	txtAddressCountryAZ: 'Ázerbajdžán',
	txtAddressCountryBS: 'Bahamy',
	txtAddressCountryBH: 'Bahrajn',
	txtAddressCountryBD: 'Bangladéš',
	txtAddressCountryBB: 'Barbados',
	txtAddressCountryBY: 'Bělorusko',
	txtAddressCountryBE: 'Belgie',
	txtAddressCountryBZ: 'Belize',
	txtAddressCountryBJ: 'Benin',
	txtAddressCountryBM: 'Bermudy',
	txtAddressCountryBT: 'Bhútán',
	txtAddressCountryBO: 'Bolívie',
	txtAddressCountryBA: 'Bosna a Hercegovina',
	txtAddressCountryBW: 'Botswana',
	txtAddressCountryBR: 'Brazílie',
	txtAddressCountryBN: 'Brunej',
	txtAddressCountryBG: 'Bulharsko',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Kambodža',
	txtAddressCountryCM: 'Kamerun',
	txtAddressCountryCA: 'Kanada',
	txtAddressCountryCV: 'Kapverdy',
	txtAddressCountryKY: 'Kajmanské ostrovy',
	txtAddressCountryCF: 'Středoafrická republika',
	txtAddressCountryTD: 'Čad',
	txtAddressCountryCL: 'Chile',
	txtAddressCountryCN: 'Čína',
	txtAddressCountryCO: 'Kolumbie',
	txtAddressCountryKM: 'Komory',
	txtAddressCountryCD: 'Demokratická republika Kongo',
	txtAddressCountryCG: 'Kongo - Brazzaville',
	txtAddressCountryCR: 'Kostarika',
	txtAddressCountryCI: 'Pobřeží slonoviny',
	txtAddressCountryHR: 'Chorvatsko',
	txtAddressCountryCU: 'Kuba',
	txtAddressCountryCY: 'Kypr',
	txtAddressCountryCZ: 'Česká republika',
	txtAddressCountryDK: 'Dánsko',
	txtAddressCountryDJ: 'Džibutsko',
	txtAddressCountryDM: 'Dominika',
	txtAddressCountryDO: 'Dominikánská republika',
	txtAddressCountryEC: 'Ekvádor',
	txtAddressCountryEG: 'Egypt',
	txtAddressCountrySV: 'El Salvador',
	txtAddressCountryGQ: 'Rovníková Guinea',
	txtAddressCountryER: 'Eritrea',
	txtAddressCountryEE: 'Estonsko',
	txtAddressCountryET: 'Etiopie',
	txtAddressCountryFK: 'Falklandské ostrovy',
	txtAddressCountryFO: 'Faerské ostrovy',
	txtAddressCountryFJ: 'Fidži',
	txtAddressCountryFI: 'Finsko',
	txtAddressCountryFR: 'Francie',
	txtAddressCountryPF: 'Francouzská Polynésie',
	txtAddressCountryGA: 'Gabon',
	txtAddressCountryGM: 'Gambie',
	txtAddressCountryGE: 'Gruzie',
	txtAddressCountryDE: 'Německo',
	txtAddressCountryGH: 'Ghana',
	txtAddressCountryGR: 'Řecko',
	txtAddressCountryGL: 'Grónsko',
	txtAddressCountryGD: 'Grenada',
	txtAddressCountryGP: 'Guadeloupe',
	txtAddressCountryGT: 'Guatemala',
	txtAddressCountryGN: 'Rovníková Guinea',
	txtAddressCountryGW: 'Guinea-Bissau',
	txtAddressCountryGY: 'Guyana',
	txtAddressCountryHT: 'Haiti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hongkong',
	txtAddressCountryHU: 'Maďarsko',
	txtAddressCountryIS: 'Island',
	txtAddressCountryIN: 'Indie',
	txtAddressCountryID: 'Indonésie',
	txtAddressCountryIR: 'Írán',
	txtAddressCountryIQ: 'Irák',
	txtAddressCountryIE: 'Irsko',
	txtAddressCountryIM: 'Ostrov Man',
	txtAddressCountryIL: 'Izrael',
	txtAddressCountryIT: 'Itálie',
	txtAddressCountryJM: 'Jamajka',
	txtAddressCountryJP: 'Japonsko',
	txtAddressCountryJO: 'Jordánsko',
	txtAddressCountryKZ: 'Kazachstán',
	txtAddressCountryKE: 'Keňa',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'Severní Korea',
	txtAddressCountryKR: 'Jižní Korea',
	txtAddressCountryKW: 'Kuvajt',
	txtAddressCountryKG: 'Kyrgyzstán',
	txtAddressCountryLA: 'Laos',
	txtAddressCountryLV: 'Lotyšsko',
	txtAddressCountryLB: 'Libanon',
	txtAddressCountryLS: 'Lesotho',
	txtAddressCountryLR: 'Libérie',
	txtAddressCountryLY: 'Libye',
	txtAddressCountryLI: 'Lichtenštejnsko',
	txtAddressCountryLT: 'Litva',
	txtAddressCountryLU: 'Lucembursko',
	txtAddressCountryMO: 'Macao',
	txtAddressCountryMK: 'Makedonie',
	txtAddressCountryMG: 'Madagaskar',
	txtAddressCountryMW: 'Malawi',
	txtAddressCountryMY: 'Malajsie',
	txtAddressCountryMV: 'Maledivy',
	txtAddressCountryML: 'Mali',
	txtAddressCountryMT: 'Malta',
	txtAddressCountryMH: 'Marshallovy ostrovy',
	txtAddressCountryMQ: 'Martinik',
	txtAddressCountryMR: 'Mauretánie',
	txtAddressCountryMU: 'Mauricius',
	txtAddressCountryMX: 'Mexiko',
	txtAddressCountryFM: 'Mikronésie',
	txtAddressCountryMD: 'Moldavsko',
	txtAddressCountryMC: 'Monako',
	txtAddressCountryMN: 'Mongolsko',
	txtAddressCountryME: 'Černá hora',
	txtAddressCountryMA: 'Maroko',
	txtAddressCountryMZ: 'Mozambik',
	txtAddressCountryMM: 'Myanmar',
	txtAddressCountryNA: 'Namibie',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Nepál',
	txtAddressCountryNL: 'Nizozemsko',
	txtAddressCountryNC: 'Nová Kaledonie',
	txtAddressCountryNZ: 'Nový Zéland',
	txtAddressCountryNI: 'Nikaragua',
	txtAddressCountryNE: 'Niger',
	txtAddressCountryNG: 'Nigérie',
	txtAddressCountryNO: 'Norsko',
	txtAddressCountryOM: 'Omán',
	txtAddressCountryPK: 'Pákistán',
	txtAddressCountryPW: 'Palau',
	txtAddressCountryPS: 'Palestinská autonomie',
	txtAddressCountryPA: 'Panama',
	txtAddressCountryPG: 'Papua-Nová Guinea',
	txtAddressCountryPY: 'Paraguay',
	txtAddressCountryPE: 'Peru',
	txtAddressCountryPH: 'Filipíny',
	txtAddressCountryPL: 'Polsko',
	txtAddressCountryPT: 'Portugalsko',
	txtAddressCountryPR: 'Portoriko',
	txtAddressCountryQA: 'Katar',
	txtAddressCountryRE: 'Réunion',
	txtAddressCountryRO: 'Rumunsko',
	txtAddressCountryRU: 'Rusko',
	txtAddressCountryRW: 'Rwanda',
	txtAddressCountryBL: 'Svatý Bartoloměj',
	txtAddressCountrySH: 'Svatá Helena',
	txtAddressCountryKN: 'Svatý Kryštof and Nevis',
	txtAddressCountryLC: 'Svatá Lucie',
	txtAddressCountryMF: 'Svatý Martin',
	txtAddressCountryVC: 'Svatý Vincenc a Grenadiny',
	txtAddressCountryWS: 'Samoa',
	txtAddressCountrySM: 'San Marino',
	txtAddressCountryST: 'Svatý Tomáš a Princův ostrov',
	txtAddressCountrySA: 'Saúdská Arábie',
	txtAddressCountrySN: 'Senegal',
	txtAddressCountryRS: 'Srbsko',
	txtAddressCountrySC: 'Seychely',
	txtAddressCountrySL: 'Sierra Leone',
	txtAddressCountrySG: 'Singapur',
	txtAddressCountrySK: 'Slovensko',
	txtAddressCountrySI: 'Slovinsko',
	txtAddressCountrySB: 'Šalamounovy ostrovy',
	txtAddressCountrySO: 'Somálsko',
	txtAddressCountryZA: 'Jihoafrická republika',
	txtAddressCountryGS: 'Jižní Georgie a Jižní Sandwichovy ostrovy',
	txtAddressCountryES: 'Španělsko',
	txtAddressCountryLK: 'Šrí Lanka',
	txtAddressCountrySD: 'Súdán',
	txtAddressCountrySR: 'Surinam',
	txtAddressCountrySZ: 'Svazijsko',
	txtAddressCountrySE: 'Švédsko',
	txtAddressCountryCH: 'Švýcarsko',
	txtAddressCountrySY: 'Sýrie',
	txtAddressCountryTW: 'Tchaj-wan',
	txtAddressCountryTJ: 'Tádžikistán',
	txtAddressCountryTZ: 'Tanzanie',
	txtAddressCountryTH: 'Thajsko',
	txtAddressCountryTL: 'Východní Timor',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga',
	txtAddressCountryTT: 'Trinidad a Tobago',
	txtAddressCountryTN: 'Tunisko',
	txtAddressCountryTR: 'Turecko',
	txtAddressCountryTM: 'Turkmenistán',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'Panenské ostrovy (USA)',
	txtAddressCountryUG: 'Uganda',
	txtAddressCountryUA: 'Ukrajina',
	txtAddressCountryAE: 'Spojené arabské emiráty',
	txtAddressCountryGB: 'Velká Británie',
	txtAddressCountryUS: 'Spojené štáty',
	txtAddressCountryUY: 'Uruguay',
	txtAddressCountryUZ: 'Uzbekistán',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Vatikán',
	txtAddressCountryVE: 'Venezuela',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Jemen',
	txtAddressCountryZM: 'Zambie',
	txtAddressCountryZW: 'Zimbabwe',

	/* data_process.js */
	addCategory: 'Přidat kategorii',

	/* addressbook.js */
	contactConcurrentChange: 'Kontakt byl změněn na serveru a znovu načten!',
	contactRfcNotCompliant: 'Chyba: tento kontakt (vCard) není v souladu se standardem RFC 2426!',

	/* interface.js */
	loadingAddressbooks: 'Načítavání adresářů (%act% z %total%) ...',

	/* webdav_protocol.js */
	succContactSaved: 'Kontakt úspěšně uložen!',
	succContactDeleted: 'Kontakt úspěšně vymazán!',
	succContactDeletedFromGroup: 'Kontakt úspěšně vymazán z aktivní skupiny kontaktů!',
	errUnableLockBegin: 'Chyba: \'nepodařilo se zamknout prostředek\': %%!',
	errUnableUnlockBegin: 'Chyba: \'nepodařilo se odemknout prostředek\': %%!',
	errUnableSaveBegin: 'Chyba: \'nepodařilo se uložit kontakt\': %%!',
	errUnableSaveInvalidData: 'Chyba: \'nelze uložit\': opravte zvýrazněné neplatné hodnoty!',
	errUnableDeleteBegin: 'Chyba: \'nepodařilo se vymazat kontakt\': %%!',
	errResourceLocked: 'prostředek je právě zamčený',
	errHttp410: 'kontakt již není dostupný na serveru'
}

localizationCardDAV['da_DK']=	/* thanks Niels Bo Andersen */
{
	/* index.html */
	altAddContact: 'Tilføj kontaktperson',
	altPhoto: 'Foto',
	txtAddressbook: 'Adressebog',
	txtCompanies: 'Virksomheder',
	txtContact: 'Kontaktperson',
	pholderGiven: 'Fornavn',
	pholderFamily: 'Efternavn',
	pholderMiddle: 'Mellemnavn',
	pholderNickname: 'Kaldenavn',
	pholderPhGiven: 'Fornavn (lydskrift)',
	pholderPhFamily: 'Efternavn (lydskrift)',
	pholderPrefix: 'Præfiks',
	pholderSuffix: 'Suffiks',
	pholderBday: 'Fødselsdag',
	pholderAnniversary: 'Jubilæum',
	pholderTitle: 'Jobtitel',
	pholderOrg: 'Firma',
	pholderDepartment: 'Afdeling',
	txtCompanyContact: 'Firmakontakt',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» brugerdefineret',
	pholderCustomVal: 'brugerdefineret',

	txtPhone: 'Telefon',
	txtPhoneWork: 'arbejde',
	txtPhoneHome: 'privat',
	txtPhoneCell: 'mobil',
	txtPhoneCellWork: 'mobil, arbejde',
	txtPhoneCellHome: 'mobil, privat',
	txtPhoneMain: 'primær',
	txtPhonePager: 'personsøger',
	txtPhoneFax: 'fax',
	txtPhoneFaxWork: 'fax, arbejde',
	txtPhoneFaxHome: 'fax, privat',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'andet',
	pholderPhoneVal: 'Telefon',

	txtEmail: 'E-mail',
	txtEmailWork: 'arbejde',
	txtEmailHome: 'privat',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'andet',
	pholderEmailVal: 'E-mail',

	txtUrl: 'Web',
	txtUrlWork: 'arbejde',
	txtUrlHome: 'privat',
	txtUrlHomepage: 'hjemmeside',
	txtUrlOther: 'andet',
	pholderUrlVal: 'URL',

	txtRelated: 'Relationer',
	txtRelatedFather: 'far',
	txtRelatedMother: 'mor',
	txtRelatedParent: 'forælder',
	txtRelatedBrother: 'bror',
	txtRelatedSister: 'søster',
	txtRelatedChild: 'barn',
	txtRelatedFriend: 'ven',
	txtRelatedSpouse: 'samlever',
	txtRelatedPartner: 'partner',
	txtRelatedAssistant: 'assistent',
	txtRelatedManager: 'overordnet',
	txtRelatedOther: 'andet',
	pholderRelatedVal: 'Navn',

	txtIm: 'IM',
	txtImWork: 'arbejde',
	txtImHome: 'privat',
	txtImMobileme: 'mobileMe',
	txtImOther: 'andet',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'BrugerID',

	txtProfile: 'Profil',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'Brugernavn',

	txtAddress: 'Adresse',
	txtAddressWork: 'arbejde',
	txtAddressHome: 'privat',
	txtAddressOther: 'andet',
	// address fields are handled specially

	txtCategories: 'Kategorier',
	// categories' values are handled specially

	pholderNoteVal: 'Tekst',

	buttonCancel: 'Annuller',
	buttonDeleteFromGroup: 'Fjern fra gruppe',

	/* common.js - address field names */
	pholderAddressCity: 'By',
	pholderAddressCityRegion: 'By/Region',
	pholderAddressCounty: 'Område',
	pholderAddressCountyCity: 'Område/By',
	pholderAddressDepartment: 'Afdeling',
	pholderAddressDistrict: 'Distrikt',
	pholderAddressDistrictSubdivision: 'Distrikt/Underafdeling',
	pholderAddressFurtherDivisions: 'Flere afdelinger',
	pholderAddressGovernorate: 'Governorat',
	pholderAddressIslandName: 'Ønavn',
	pholderAddressPinCode: 'PIN-Kode',
	pholderAddressPostCode: 'Postnummer',
	pholderAddressPostal: 'Postal',
	pholderAddressPostalCode: 'Postnummer',
	pholderAddressPostalDistrict: 'Postdistrikt',
	pholderAddressPrefecture: 'Præfektur',
	pholderAddressProvince: 'Provins',
	pholderAddressRegion: 'Region',
	pholderAddressState: 'Stat',
	pholderAddressStreet: 'Gade',
	pholderAddressSuburb: 'Forstad',
	pholderAddressTownshipDistrict: 'Bydistrikt',
	pholderAddressZip: 'ZIP',
	txtAddressCountryAF: 'Afghanistan',
	txtAddressCountryAL: 'Albanien',
	txtAddressCountryDZ: 'Algeriet',
	txtAddressCountryAD: 'Andorra',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua og Barbuda',
	txtAddressCountryAR: 'Argentina',
	txtAddressCountryAM: 'Armenien',
	txtAddressCountryAU: 'Australien',
	txtAddressCountryAT: 'Østrig',
	txtAddressCountryAZ: 'Aserbajdsjan',
	txtAddressCountryBS: 'Bahamas',
	txtAddressCountryBH: 'Bahrain',
	txtAddressCountryBD: 'Bangladesh',
	txtAddressCountryBB: 'Barbados',
	txtAddressCountryBY: 'Belarus',
	txtAddressCountryBE: 'Belgien',
	txtAddressCountryBZ: 'Belize',
	txtAddressCountryBJ: 'Benin',
	txtAddressCountryBM: 'Bermuda',
	txtAddressCountryBT: 'Bhutan',
	txtAddressCountryBO: 'Bolivia',
	txtAddressCountryBA: 'Bosnien og Hercegovina',
	txtAddressCountryBW: 'Botswana',
	txtAddressCountryBR: 'Brasilien',
	txtAddressCountryBN: 'Brunei',
	txtAddressCountryBG: 'Bulgarien',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Cambodja',
	txtAddressCountryCM: 'Cameroun',
	txtAddressCountryCA: 'Canada',
	txtAddressCountryCV: 'Kap Verde',
	txtAddressCountryKY: 'Cayman Islands',
	txtAddressCountryCF: 'Centralafrikanske Republik',
	txtAddressCountryTD: 'Tchad',
	txtAddressCountryCL: 'Chile',
	txtAddressCountryCN: 'Kina',
	txtAddressCountryCO: 'Colombia',
	txtAddressCountryKM: 'Comorerne',
	txtAddressCountryCD: 'Den Demokratiske Republik Congo',
	txtAddressCountryCG: 'Republik Congo',
	txtAddressCountryCR: 'Costa Rica',
	txtAddressCountryCI: 'Elfenbenskysten',
	txtAddressCountryHR: 'Kroatien',
	txtAddressCountryCU: 'Cuba',
	txtAddressCountryCY: 'Cypern',
	txtAddressCountryCZ: 'Den Tjekkiske Republik',
	txtAddressCountryDK: 'Danmark',
	txtAddressCountryDJ: 'Djibouti',
	txtAddressCountryDM: 'Dominica',
	txtAddressCountryDO: 'Den Dominikanske Republik',
	txtAddressCountryEC: 'Ecuador',
	txtAddressCountryEG: 'Egypten',
	txtAddressCountrySV: 'El Salvador',
	txtAddressCountryGQ: 'Ækvatorial Guinea',
	txtAddressCountryER: 'Eritrea',
	txtAddressCountryEE: 'Estland',
	txtAddressCountryET: 'Etiopien',
	txtAddressCountryFK: 'Falklandsøerne',
	txtAddressCountryFO: 'Færøerne',
	txtAddressCountryFJ: 'Fiji',
	txtAddressCountryFI: 'Finland',
	txtAddressCountryFR: 'Frankrig',
	txtAddressCountryPF: 'Fransk Polynesien',
	txtAddressCountryGA: 'Gabon',
	txtAddressCountryGM: 'Gambia',
	txtAddressCountryGE: 'Georgien',
	txtAddressCountryDE: 'Tyskland',
	txtAddressCountryGH: 'Ghana',
	txtAddressCountryGR: 'Grækenland',
	txtAddressCountryGL: 'Grønland',
	txtAddressCountryGD: 'Grenada',
	txtAddressCountryGP: 'Guadeloupe',
	txtAddressCountryGT: 'Guatemala',
	txtAddressCountryGN: 'Guinea',
	txtAddressCountryGW: 'Guinea-Bissau',
	txtAddressCountryGY: 'Guyana',
	txtAddressCountryHT: 'Haiti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hong Kong',
	txtAddressCountryHU: 'Ungarn',
	txtAddressCountryIS: 'Island',
	txtAddressCountryIN: 'Indien',
	txtAddressCountryID: 'Indonesien',
	txtAddressCountryIR: 'Iran',
	txtAddressCountryIQ: 'Irak',
	txtAddressCountryIE: 'Irland',
	txtAddressCountryIM: 'Isle of Man',
	txtAddressCountryIL: 'Israel',
	txtAddressCountryIT: 'Italien',
	txtAddressCountryJM: 'Jamaica',
	txtAddressCountryJP: 'Japan',
	txtAddressCountryJO: 'Jordan',
	txtAddressCountryKZ: 'Kasakhstan',
	txtAddressCountryKE: 'Kenya',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'Nordkorea',
	txtAddressCountryKR: 'Sydkorea',
	txtAddressCountryKW: 'Kuwait',
	txtAddressCountryKG: 'Kirgisistan',
	txtAddressCountryLA: 'Laos',
	txtAddressCountryLV: 'Letland',
	txtAddressCountryLB: 'Libanon',
	txtAddressCountryLS: 'Lesotho',
	txtAddressCountryLR: 'Liberia',
	txtAddressCountryLY: 'Libyen',
	txtAddressCountryLI: 'Liechtenstein',
	txtAddressCountryLT: 'Litauen',
	txtAddressCountryLU: 'Luxembourg',
	txtAddressCountryMO: 'Macao',
	txtAddressCountryMK: 'Makedonien',
	txtAddressCountryMG: 'Madagaskar',
	txtAddressCountryMW: 'Malawi',
	txtAddressCountryMY: 'Malaysia',
	txtAddressCountryMV: 'Maldiverne',
	txtAddressCountryML: 'Mali',
	txtAddressCountryMT: 'Malta',
	txtAddressCountryMH: 'Marshalløerne',
	txtAddressCountryMQ: 'Martinique',
	txtAddressCountryMR: 'Mauretanien',
	txtAddressCountryMU: 'Mauritius',
	txtAddressCountryMX: 'Mexico',
	txtAddressCountryFM: 'Mikronesien',
	txtAddressCountryMD: 'Moldova',
	txtAddressCountryMC: 'Monaco',
	txtAddressCountryMN: 'Mongoliet',
	txtAddressCountryME: 'Montenegro',
	txtAddressCountryMA: 'Marokko',
	txtAddressCountryMZ: 'Mozambique',
	txtAddressCountryMM: 'Myanmar',
	txtAddressCountryNA: 'Namibia',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Nepal',
	txtAddressCountryNL: 'Holland',
	txtAddressCountryNC: 'Ny Kaledonien',
	txtAddressCountryNZ: 'New Zealand',
	txtAddressCountryNI: 'Nicaragua',
	txtAddressCountryNE: 'Niger',
	txtAddressCountryNG: 'Nigeria',
	txtAddressCountryNO: 'Norge',
	txtAddressCountryOM: 'Oman',
	txtAddressCountryPK: 'Pakistan',
	txtAddressCountryPW: 'Palau',
	txtAddressCountryPS: 'Palæstinensiske områder',
	txtAddressCountryPA: 'Panama',
	txtAddressCountryPG: 'Papua Ny Guinea',
	txtAddressCountryPY: 'Paraguay',
	txtAddressCountryPE: 'Peru',
	txtAddressCountryPH: 'Filippinerne',
	txtAddressCountryPL: 'Polen',
	txtAddressCountryPT: 'Portugal',
	txtAddressCountryPR: 'Puerto Rico',
	txtAddressCountryQA: 'Qatar',
	txtAddressCountryRE: 'Réunion',
	txtAddressCountryRO: 'Rumænien',
	txtAddressCountryRU: 'Rusland',
	txtAddressCountryRW: 'Rwanda',
	txtAddressCountryBL: 'Saint-Barthélemy',
	txtAddressCountrySH: 'Saint Helena',
	txtAddressCountryKN: 'Saint Kitts og Nevis',
	txtAddressCountryLC: 'Saint Lucia',
	txtAddressCountryMF: 'Saint Martin',
	txtAddressCountryVC: 'Saint Vincent og Grenadinerne',
	txtAddressCountryWS: 'Samoa',
	txtAddressCountrySM: 'San Marino',
	txtAddressCountryST: 'Sao Tome og Principe',
	txtAddressCountrySA: 'Saudi-Arabien',
	txtAddressCountrySN: 'Senegal',
	txtAddressCountryRS: 'Serbien',
	txtAddressCountrySC: 'Seychellerne',
	txtAddressCountrySL: 'Sierra Leone',
	txtAddressCountrySG: 'Singapore',
	txtAddressCountrySK: 'Slovakiske Republik',
	txtAddressCountrySI: 'Slovenien',
	txtAddressCountrySB: 'Salomonøerne',
	txtAddressCountrySO: 'Somalia',
	txtAddressCountryZA: 'Sydafrika',
	txtAddressCountryGS: 'South Georgia og De Sydlige Sandwichøer',
	txtAddressCountryES: 'Spanien',
	txtAddressCountryLK: 'Sri Lanka',
	txtAddressCountrySD: 'Sudan',
	txtAddressCountrySR: 'Surinam',
	txtAddressCountrySZ: 'Swaziland',
	txtAddressCountrySE: 'Sverige',
	txtAddressCountryCH: 'Schweiz',
	txtAddressCountrySY: 'Syrien',
	txtAddressCountryTW: 'Taiwan',
	txtAddressCountryTJ: 'Tadsjikistan',
	txtAddressCountryTZ: 'Tanzania',
	txtAddressCountryTH: 'Thailand',
	txtAddressCountryTL: 'Timor-Leste',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga',
	txtAddressCountryTT: 'Trinidad og Tobago',
	txtAddressCountryTN: 'Tunesien',
	txtAddressCountryTR: 'Tyrkiet',
	txtAddressCountryTM: 'Turkmenistan',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'Jomfruøerne',
	txtAddressCountryUG: 'Uganda',
	txtAddressCountryUA: 'Ukraine',
	txtAddressCountryAE: 'De Forenede Arabiske Emirater',
	txtAddressCountryGB: 'Storbritannien',
	txtAddressCountryUS: 'USA',
	txtAddressCountryUY: 'Uruguay',
	txtAddressCountryUZ: 'Usbekistan',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Vatikanet',
	txtAddressCountryVE: 'Venezuela',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Yemen',
	txtAddressCountryZM: 'Zambia',
	txtAddressCountryZW: 'Zimbabwe',

	/* data_process.js */
	addCategory: 'Tilføj kategori',

	/* addressbook.js */
	contactConcurrentChange: 'Kontaktpersonen blev ændret på serveren, og er genindlæst!',
	contactRfcNotCompliant: 'Fejl: denne kontakt (vCard) overholder ikke RFC 2426!',

	/* interface.js */
	loadingAddressbooks: 'Indlæser adressebøger (%act% af %total%) ...',

	/* webdav_protocol.js */
	succContactSaved: 'Kontaktpersonen blev gemt!',
	succContactDeleted: 'Kontaktpersonen blev slettet!',
	succContactDeletedFromGroup: 'Kontaktpersonen blev slettet fra den aktive kontaktgruppe!',
	errUnableLockBegin: 'Fejl: \'kunne ikke låse ressource\': %%!',
	errUnableUnlockBegin: 'Fejl: \'kunne ikke frigive ressource\': %%!',
	errUnableSaveBegin: 'Fejl: \'kunne ikke gemme kontaktpersonen\': %%!',
	errUnableSaveInvalidData: 'Fejl: \'kunne ikke gemme\': korrigere de fremhævede ugyldige værdier!',
	errUnableDeleteBegin: 'Fejl: \'kunne ikke slette kontaktpersonen\': %%!',
	errResourceLocked: 'ressource allerede låst',
	errHttp410: 'kontaktpersonen er ikke længere tilgængelig på serveren'
}

localizationCardDAV['de_DE']=	/* thanks Marten Gajda and Thomas Scheel */
{
	/* index.html */
	altAddContact: 'Neuer Kontakt',
	altPhoto: 'Foto',
	txtAddressbook: 'Adressbuch',
	txtCompanies: 'Unternehmen',	// XXX
	txtContact: 'Kontakt',
	pholderGiven: 'Vorname',
	pholderFamily: 'Nachname',
	pholderMiddle: 'Weitere Vornamen',
	pholderNickname: 'Spitzname',
	pholderPhGiven: 'Vorname (Ausspracheform)',
	pholderPhFamily: 'Nachname (Ausspracheform)',
	pholderPrefix: 'Titel',
	pholderSuffix: 'Namenszusatz',
	pholderBday: 'Geburtstag',
	pholderAnniversary: 'Jahrestag',
	pholderTitle: 'Berufsbezeichnung',
	pholderOrg: 'Unternehmen',
	pholderDepartment: 'Abteilung',
	txtCompanyContact: 'Unternehmenskontakt',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» benutzerdefinierte',
	pholderCustomVal: 'benutzerdefinierte',

	txtPhone: 'Telefon',
	txtPhoneWork: 'Büro',
	txtPhoneHome: 'privat',
	txtPhoneCell: 'mobil',
	txtPhoneCellWork: 'mobil (Büro)',
	txtPhoneCellHome: 'mobil (privat)',
	txtPhoneMain: 'Hauptnummer',
	txtPhonePager: 'Pager',
	txtPhoneFax: 'Fax',
	txtPhoneFaxWork: 'Fax (Büro)',
	txtPhoneFaxHome: 'Fax (privat)',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'andere',
	pholderPhoneVal: 'Telefon',

	txtEmail: 'Email',
	txtEmailWork: 'Büro',
	txtEmailHome: 'privat',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'andere',
	pholderEmailVal: 'Email',

	txtUrl: 'URL',
	txtUrlWork: 'Büro',
	txtUrlHome: 'privat',
	txtUrlHomepage: 'Homepage',
	txtUrlOther: 'andere',
	pholderUrlVal: 'URL',

	txtRelated: 'Beziehung',
	txtRelatedFather: 'Vater',
	txtRelatedMother: 'Mutter',
	txtRelatedParent: 'Elternteil',
	txtRelatedBrother: 'Bruder',
	txtRelatedSister: 'Schwester',
	txtRelatedChild: 'Kind',
	txtRelatedFriend: 'Freund',
	txtRelatedSpouse: 'Ehepartner',
	txtRelatedPartner: 'Partner',
	txtRelatedAssistant: 'Assistent',
	txtRelatedManager: 'Vorgesetzter',
	txtRelatedOther: 'andere',
	pholderRelatedVal: 'Name',

	txtIm: 'IM',
	txtImWork: 'Büro',
	txtImHome: 'privat',
	txtImMobileme: 'mobileMe',
	txtImOther: 'andere',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'UserID',

	txtProfile: 'Profil',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'Benutzername',

	txtAddress: 'Adresse',
	txtAddressWork: 'Büro',
	txtAddressHome: 'privat',
	txtAddressOther: 'andere',
	// address fields are handled specially

	txtCategories: 'Kategorien',
	// categories' values are handled specially

	pholderNoteVal: 'Notiztext',

	buttonCancel: 'Abbrechen',
	buttonDeleteFromGroup: 'Aus Gruppe löschen',

	/* common.js - address field names */
	pholderAddressCity: 'Stadt',
	pholderAddressCityRegion: 'Stadt/Region',
	pholderAddressCounty: 'Bezirk',
	pholderAddressCountyCity: 'Stadtbezirk',
	pholderAddressDepartment: 'Distrikt',
	pholderAddressDistrict: 'Kreis',
	pholderAddressDistrictSubdivision: 'Kreis/Unterteilung',
	pholderAddressFurtherDivisions: 'Weitere Unterteilungen',
	pholderAddressGovernorate: 'Regierungsbezirk',
	pholderAddressIslandName: 'Inselname',
	pholderAddressPinCode: 'PIN Code',
	pholderAddressPostCode: 'Postleitzahl',
	pholderAddressPostal: 'Postal',
	pholderAddressPostalCode: 'Postleitzahl',
	pholderAddressPostalDistrict: 'Postbezirk',
	pholderAddressPrefecture: 'Präfektur',
	pholderAddressProvince: 'Provinz',
	pholderAddressRegion: 'Region',
	pholderAddressState: 'Land',
	pholderAddressStreet: 'Straße',
	pholderAddressSuburb: 'Vorort',
	pholderAddressTownshipDistrict: 'Verwaltungsbezirk',
	pholderAddressZip: 'PLZ',
	txtAddressCountryAF: 'Afghanistan',
	txtAddressCountryAL: 'Albanien',
	txtAddressCountryDZ: 'Algerien',
	txtAddressCountryAD: 'Andorra',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua und Barbuda',
	txtAddressCountryAR: 'Argentinien',
	txtAddressCountryAM: 'Armenien',
	txtAddressCountryAU: 'Australien',
	txtAddressCountryAT: 'Österreich',
	txtAddressCountryAZ: 'Aserbaidschan',
	txtAddressCountryBS: 'Bahamas',
	txtAddressCountryBH: 'Bahrain',
	txtAddressCountryBD: 'Bangladesch',
	txtAddressCountryBB: 'Barbados',
	txtAddressCountryBY: 'Weißussland',
	txtAddressCountryBE: 'Belgien',
	txtAddressCountryBZ: 'Belize',
	txtAddressCountryBJ: 'Benin',
	txtAddressCountryBM: 'Bermuda',
	txtAddressCountryBT: 'Bhutan',
	txtAddressCountryBO: 'Bolivien',
	txtAddressCountryBA: 'Bosnien-Herzegowina',
	txtAddressCountryBW: 'Botsuana',
	txtAddressCountryBR: 'Brasilen',
	txtAddressCountryBN: 'Brunei Darussalam',
	txtAddressCountryBG: 'Bulgarien',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Kambodscha',
	txtAddressCountryCM: 'Kamerun',
	txtAddressCountryCA: 'Kanada',
	txtAddressCountryCV: 'Kap Verde',
	txtAddressCountryKY: 'Kaimaninseln',
	txtAddressCountryCF: 'Zentralafrikanische Republik',
	txtAddressCountryTD: 'Tschad',
	txtAddressCountryCL: 'Chile',
	txtAddressCountryCN: 'China',
	txtAddressCountryCO: 'Kolumbien',
	txtAddressCountryKM: 'Komoren',
	txtAddressCountryCD: 'Demokratische Republik Kongo',
	txtAddressCountryCG: 'Kongo',
	txtAddressCountryCR: 'Costa Rica',
	txtAddressCountryCI: 'Côte d’Ivoire',
	txtAddressCountryHR: 'Kroatien',
	txtAddressCountryCU: 'Kuba',
	txtAddressCountryCY: 'Zypern',
	txtAddressCountryCZ: 'Tschechische Republik',
	txtAddressCountryDK: 'Dänemark',
	txtAddressCountryDJ: 'Dschibuti',
	txtAddressCountryDM: 'Dominica',
	txtAddressCountryDO: 'Dominikanische Republik',
	txtAddressCountryEC: 'Ecuador',
	txtAddressCountryEG: 'Ägypten',
	txtAddressCountrySV: 'El Salvador',
	txtAddressCountryGQ: 'Äquatorialguinea',
	txtAddressCountryER: 'Eritrea',
	txtAddressCountryEE: 'Estland',
	txtAddressCountryET: 'Äthiopien',
	txtAddressCountryFK: 'Falklandinseln',
	txtAddressCountryFO: 'Färöer',
	txtAddressCountryFJ: 'Fidschi',
	txtAddressCountryFI: 'Finnland',
	txtAddressCountryFR: 'Frankreich',
	txtAddressCountryPF: 'Französisch-Polynesien',
	txtAddressCountryGA: 'Gabun',
	txtAddressCountryGM: 'Gambia',
	txtAddressCountryGE: 'Georgien',
	txtAddressCountryDE: 'Deutschland',
	txtAddressCountryGH: 'Ghana',
	txtAddressCountryGR: 'Griechenland',
	txtAddressCountryGL: 'Grönland',
	txtAddressCountryGD: 'Grenada',
	txtAddressCountryGP: 'Guadeloupe',
	txtAddressCountryGT: 'Guatemala',
	txtAddressCountryGN: 'Guinea',
	txtAddressCountryGW: 'Guinea-Bissau',
	txtAddressCountryGY: 'Guyana',
	txtAddressCountryHT: 'Haiti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hong Kong',
	txtAddressCountryHU: 'Ungarn',
	txtAddressCountryIS: 'Island',
	txtAddressCountryIN: 'Indien',
	txtAddressCountryID: 'Indonesien',
	txtAddressCountryIR: 'Iran',
	txtAddressCountryIQ: 'Irak',
	txtAddressCountryIE: 'Irland',
	txtAddressCountryIM: 'Isle of Man',
	txtAddressCountryIL: 'Israel',
	txtAddressCountryIT: 'Italien',
	txtAddressCountryJM: 'Jamaika',
	txtAddressCountryJP: 'Japan',
	txtAddressCountryJO: 'Jordanien',
	txtAddressCountryKZ: 'Kasachstan',
	txtAddressCountryKE: 'Kenya',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'Nordkorea',
	txtAddressCountryKR: 'Südkorea',
	txtAddressCountryKW: 'Kuwait',
	txtAddressCountryKG: 'Kirgisistan',
	txtAddressCountryLA: 'Laos',
	txtAddressCountryLV: 'Lettland',
	txtAddressCountryLB: 'Libanon',
	txtAddressCountryLS: 'Lesotho',
	txtAddressCountryLR: 'Liberia',
	txtAddressCountryLY: 'Libyen',
	txtAddressCountryLI: 'Liechtenstein',
	txtAddressCountryLT: 'Litauen',
	txtAddressCountryLU: 'Luxemburg',
	txtAddressCountryMO: 'Macau',
	txtAddressCountryMK: 'Mazedonien',
	txtAddressCountryMG: 'Madagaskar',
	txtAddressCountryMW: 'Malawi',
	txtAddressCountryMY: 'Malaysia',
	txtAddressCountryMV: 'Malediven',
	txtAddressCountryML: 'Mali',
	txtAddressCountryMT: 'Malta',
	txtAddressCountryMH: 'Marshallinseln',
	txtAddressCountryMQ: 'Martinique',
	txtAddressCountryMR: 'Mauretanien',
	txtAddressCountryMU: 'Mauritius',
	txtAddressCountryMX: 'Mexiko',
	txtAddressCountryFM: 'Mikronesien',
	txtAddressCountryMD: 'Moldawien',
	txtAddressCountryMC: 'Monaco',
	txtAddressCountryMN: 'Mongolei',
	txtAddressCountryME: 'Montenegro',
	txtAddressCountryMA: 'Marokko',
	txtAddressCountryMZ: 'Mosambik',
	txtAddressCountryMM: 'Myanmar',
	txtAddressCountryNA: 'Namibia',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Nepal',
	txtAddressCountryNL: 'Niederlande',
	txtAddressCountryNC: 'Neukaledonien',
	txtAddressCountryNZ: 'Neuseeland',
	txtAddressCountryNI: 'Nicaragua',
	txtAddressCountryNE: 'Niger',
	txtAddressCountryNG: 'Nigeria',
	txtAddressCountryNO: 'Norwegen',
	txtAddressCountryOM: 'Oman',
	txtAddressCountryPK: 'Pakistan',
	txtAddressCountryPW: 'Palau',
	txtAddressCountryPS: 'Palestinensische Autonomiegebiete',
	txtAddressCountryPA: 'Panama',
	txtAddressCountryPG: 'Papua-Neuguinea',
	txtAddressCountryPY: 'Paraguay',
	txtAddressCountryPE: 'Peru',
	txtAddressCountryPH: 'Philippinen',
	txtAddressCountryPL: 'Polen',
	txtAddressCountryPT: 'Portugal',
	txtAddressCountryPR: 'Puerto Rico',
	txtAddressCountryQA: 'Katar',
	txtAddressCountryRE: 'Réunion',
	txtAddressCountryRO: 'Rumänien',
	txtAddressCountryRU: 'Russische Förderation',
	txtAddressCountryRW: 'Ruanda',
	txtAddressCountryBL: 'St. Barthélemy',
	txtAddressCountrySH: 'St. Helena',
	txtAddressCountryKN: 'St. Kitts and Nevis',
	txtAddressCountryLC: 'St. Lucia',
	txtAddressCountryMF: 'St. Martin',
	txtAddressCountryVC: 'St. Vincent und die Grenadinen',
	txtAddressCountryWS: 'Samoa',
	txtAddressCountrySM: 'San Marino',
	txtAddressCountryST: 'São Tomé und Príncipe',
	txtAddressCountrySA: 'Saudi-Arabien',
	txtAddressCountrySN: 'Senegal',
	txtAddressCountryRS: 'Serbien',
	txtAddressCountrySC: 'Seychellen',
	txtAddressCountrySL: 'Sierra Leone',
	txtAddressCountrySG: 'Singapur',
	txtAddressCountrySK: 'Slowakei',
	txtAddressCountrySI: 'Slovenien',
	txtAddressCountrySB: 'Salomonen',
	txtAddressCountrySO: 'Somalia',
	txtAddressCountryZA: 'Südafrica',
	txtAddressCountryGS: 'Südgeorgien und die südlichen Sandwichinseln',
	txtAddressCountryES: 'Spanien',
	txtAddressCountryLK: 'Sri Lanka',
	txtAddressCountrySD: 'Sudan',
	txtAddressCountrySR: 'Suriname',
	txtAddressCountrySZ: 'Swasiland',
	txtAddressCountrySE: 'Schweden',
	txtAddressCountryCH: 'Schweiz',
	txtAddressCountrySY: 'Syrien',
	txtAddressCountryTW: 'Taiwan',
	txtAddressCountryTJ: 'Tadschikistan',
	txtAddressCountryTZ: 'Tansania',
	txtAddressCountryTH: 'Thailand',
	txtAddressCountryTL: 'Timor-Leste',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga',
	txtAddressCountryTT: 'Trinidad and Tobago',
	txtAddressCountryTN: 'Tunesien',
	txtAddressCountryTR: 'Türkei',
	txtAddressCountryTM: 'Turkmenistan',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'Amerikanische Jungferninseln',
	txtAddressCountryUG: 'Uganda',
	txtAddressCountryUA: 'Ukraine',
	txtAddressCountryAE: 'Vereinigte Arabische Emirate',
	txtAddressCountryGB: 'Vereinigtes Königreich',
	txtAddressCountryUS: 'Vereinigte Staaten',
	txtAddressCountryUY: 'Uruguay',
	txtAddressCountryUZ: 'Usbekistan',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Vatikanstadt',
	txtAddressCountryVE: 'Venezuela',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Jemen',
	txtAddressCountryZM: 'Sambia',
	txtAddressCountryZW: 'Simbabwe',

	/* data_process.js */
	addCategory: 'neue Kategorie',

	/* addressbook.js */
	contactConcurrentChange: 'Der Kontakt wurde auf dem Server geändert und neu geladen!',
	contactRfcNotCompliant: 'Fehler: Dieser Kontakt (vCard) ist nicht RFC 2426 konform!',

	/* interface.js */
	loadingAddressbooks: 'Lade Adressbücher (%act% von %total%) ...',

	/* webdav_protocol.js */
	succContactSaved: 'Kontakt erfolgreich gespeichert!',
	succContactDeleted: 'Kontakt erfolgreich gelöscht!',
	succContactDeletedFromGroup: 'Kontakt erfolgreich aus der aktiven Gruppe gelöscht!',
	errUnableLockBegin: 'Fehler: \'Ressource konnte nicht gesperrt werden\': %%!',
	errUnableUnlockBegin: 'Fehler: \'Ressource konnte nicht freigegeben werden\': %%!',
	errUnableSaveBegin: 'Fehler: \'Kontakt konnte nicht gespeichert werden\': %%!',
	errUnableSaveInvalidData: 'Fehler: \'kann nicht gespeichert werden\': Korrigieren Sie die markierten ungültige Werte!',
	errUnableDeleteBegin: 'Fehler: \'Kontakt konnte nicht gelöscht werden\': %%!',
	errResourceLocked: 'Ressource bereits gesperrt',
	errHttp410: 'Kontakt ist auf dem Server nicht mehr verfügbar'
}

localizationCardDAV['en_US']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	/* index.html */
	altAddContact: 'Add Contact',
	altPhoto: 'Photo',
	txtAddressbook: 'Addressbook',
	txtCompanies: 'Companies',
	txtContact: 'Contact',
	pholderGiven: 'FirstName',
	pholderFamily: 'LastName',
	pholderMiddle: 'MiddleName',
	pholderNickname: 'NickName',
	pholderPhGiven: 'PhoneticFirstName',
	pholderPhFamily: 'PhoneticLastName',
	pholderPrefix: 'Prefix',
	pholderSuffix: 'Suffix',
	pholderBday: 'BirthDay',
	pholderAnniversary: 'Anniversary',
	pholderTitle: 'JobTitle',
	pholderOrg: 'Company',
	pholderDepartment: 'Department',
	txtCompanyContact: 'Company Contact',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» custom',
	pholderCustomVal: 'custom',

	txtPhone: 'Phone',
	txtPhoneWork: 'work',
	txtPhoneHome: 'home',
	txtPhoneCell: 'mobile',
	txtPhoneCellWork: 'work mobile',
	txtPhoneCellHome: 'home mobile',
	txtPhoneMain: 'main',
	txtPhonePager: 'pager',
	txtPhoneFax: 'fax',
	txtPhoneFaxWork: 'work fax',
	txtPhoneFaxHome: 'home fax',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'other',
	pholderPhoneVal: 'Phone',

	txtEmail: 'Email',
	txtEmailWork: 'work',
	txtEmailHome: 'home',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'other',
	pholderEmailVal: 'Email',

	txtUrl: 'URL',
	txtUrlWork: 'work',
	txtUrlHome: 'home',
	txtUrlHomepage: 'homePage',
	txtUrlOther: 'other',
	pholderUrlVal: 'URL',

	txtRelated: 'Related',
	txtRelatedFather: 'father',
	txtRelatedMother: 'mother',
	txtRelatedParent: 'parent',
	txtRelatedBrother: 'brother',
	txtRelatedSister: 'sister',
	txtRelatedChild: 'child',
	txtRelatedFriend: 'friend',
	txtRelatedSpouse: 'spouse',
	txtRelatedPartner: 'partner',
	txtRelatedAssistant: 'assistant',
	txtRelatedManager: 'manager',
	txtRelatedOther: 'other',
	pholderRelatedVal: 'Name',

	txtIm: 'IM',
	txtImWork: 'work',
	txtImHome: 'home',
	txtImMobileme: 'mobileMe',
	txtImOther: 'other',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'UserID',

	txtProfile: 'Profile',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'UserName',

	txtAddress: 'Address',
	txtAddressWork: 'work',
	txtAddressHome: 'home',
	txtAddressOther: 'other',
	// address fields are handled specially

	txtCategories: 'Categories',
	// categories' values are handled specially

	pholderNoteVal: 'NoteText',

	buttonCancel: 'Cancel',
	buttonDeleteFromGroup: 'Delete from Group',

	/* common.js - address field names */
	pholderAddressCity: 'City',
	pholderAddressCityRegion: 'City/Region',
	pholderAddressCounty: 'County',
	pholderAddressCountyCity: 'County/City',
	pholderAddressDepartment: 'Department',
	pholderAddressDistrict: 'District',
	pholderAddressDistrictSubdivision: 'District/Subdivision',
	pholderAddressFurtherDivisions: 'Further Divisions',
	pholderAddressGovernorate: 'Governorate',
	pholderAddressIslandName: 'Island Name',
	pholderAddressPinCode: 'PIN Code',
	pholderAddressPostCode: 'Post Code',
	pholderAddressPostal: 'Postal',
	pholderAddressPostalCode: 'Postal Code',
	pholderAddressPostalDistrict: 'Postal District',
	pholderAddressPrefecture: 'Prefecture',
	pholderAddressProvince: 'Province',
	pholderAddressRegion: 'Region',
	pholderAddressState: 'State',
	pholderAddressStreet: 'Street',
	pholderAddressSuburb: 'Suburb',
	pholderAddressTownshipDistrict: 'Township/District',
	pholderAddressZip: 'ZIP',
	txtAddressCountryAF: 'Afghanistan',
	txtAddressCountryAL: 'Albania',
	txtAddressCountryDZ: 'Algeria',
	txtAddressCountryAD: 'Andorra',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua and Barbuda',
	txtAddressCountryAR: 'Argentina',
	txtAddressCountryAM: 'Armenia',
	txtAddressCountryAU: 'Australia',
	txtAddressCountryAT: 'Austria',
	txtAddressCountryAZ: 'Azerbaijan',
	txtAddressCountryBS: 'The Bahamas',
	txtAddressCountryBH: 'Bahrain',
	txtAddressCountryBD: 'Bangladesh',
	txtAddressCountryBB: 'Barbados',
	txtAddressCountryBY: 'Belarus',
	txtAddressCountryBE: 'Belgium',
	txtAddressCountryBZ: 'Belize',
	txtAddressCountryBJ: 'Benin',
	txtAddressCountryBM: 'Bermuda',
	txtAddressCountryBT: 'Bhutan',
	txtAddressCountryBO: 'Bolivia',
	txtAddressCountryBA: 'Bosnia and Herzegovina',
	txtAddressCountryBW: 'Botswana',
	txtAddressCountryBR: 'Brazil',
	txtAddressCountryBN: 'Brunei Darussalam',
	txtAddressCountryBG: 'Bulgaria',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Cambodia',
	txtAddressCountryCM: 'Cameroon',
	txtAddressCountryCA: 'Canada',
	txtAddressCountryCV: 'Cape Verde',
	txtAddressCountryKY: 'Cayman Islands',
	txtAddressCountryCF: 'Central African Republic',
	txtAddressCountryTD: 'Chad',
	txtAddressCountryCL: 'Chile',
	txtAddressCountryCN: 'China',
	txtAddressCountryCO: 'Colombia',
	txtAddressCountryKM: 'Comoros',
	txtAddressCountryCD: 'Democratic Republic of the Congo',
	txtAddressCountryCG: 'Republic of the Congo',
	txtAddressCountryCR: 'Costa Rica',
	txtAddressCountryCI: 'Côte d’Ivoire',
	txtAddressCountryHR: 'Croatia',
	txtAddressCountryCU: 'Cuba',
	txtAddressCountryCY: 'Cyprus',
	txtAddressCountryCZ: 'Czech Republic',
	txtAddressCountryDK: 'Denmark',
	txtAddressCountryDJ: 'Djibouti',
	txtAddressCountryDM: 'Dominica',
	txtAddressCountryDO: 'Dominican Republic',
	txtAddressCountryEC: 'Ecuador',
	txtAddressCountryEG: 'Egypt',
	txtAddressCountrySV: 'El Salvador',
	txtAddressCountryGQ: 'Equatorial Guinea',
	txtAddressCountryER: 'Eritrea',
	txtAddressCountryEE: 'Estonia',
	txtAddressCountryET: 'Ethiopia',
	txtAddressCountryFK: 'Falkland Islands',
	txtAddressCountryFO: 'Faroe Islands',
	txtAddressCountryFJ: 'Fiji',
	txtAddressCountryFI: 'Finland',
	txtAddressCountryFR: 'France',
	txtAddressCountryPF: 'French Polynesia',
	txtAddressCountryGA: 'Gabon',
	txtAddressCountryGM: 'The Gambia',
	txtAddressCountryGE: 'Georgia',
	txtAddressCountryDE: 'Germany',
	txtAddressCountryGH: 'Ghana',
	txtAddressCountryGR: 'Greece',
	txtAddressCountryGL: 'Greenland',
	txtAddressCountryGD: 'Grenada',
	txtAddressCountryGP: 'Guadeloupe',
	txtAddressCountryGT: 'Guatemala',
	txtAddressCountryGN: 'Guinea',
	txtAddressCountryGW: 'Guinea-Bissau',
	txtAddressCountryGY: 'Guyana',
	txtAddressCountryHT: 'Haiti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hong Kong',
	txtAddressCountryHU: 'Hungary',
	txtAddressCountryIS: 'Iceland',
	txtAddressCountryIN: 'India',
	txtAddressCountryID: 'Indonesia',
	txtAddressCountryIR: 'Iran',
	txtAddressCountryIQ: 'Iraq',
	txtAddressCountryIE: 'Ireland',
	txtAddressCountryIM: 'Isle of Man',
	txtAddressCountryIL: 'Israel',
	txtAddressCountryIT: 'Italy',
	txtAddressCountryJM: 'Jamaica',
	txtAddressCountryJP: 'Japan',
	txtAddressCountryJO: 'Jordan',
	txtAddressCountryKZ: 'Kazakhstan',
	txtAddressCountryKE: 'Kenya',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'North Korea',
	txtAddressCountryKR: 'South Korea',
	txtAddressCountryKW: 'Kuwait',
	txtAddressCountryKG: 'Kyrgyzstan',
	txtAddressCountryLA: 'Laos',
	txtAddressCountryLV: 'Latvia',
	txtAddressCountryLB: 'Lebanon',
	txtAddressCountryLS: 'Lesotho',
	txtAddressCountryLR: 'Liberia',
	txtAddressCountryLY: 'Libya',
	txtAddressCountryLI: 'Liechtenstein',
	txtAddressCountryLT: 'Lithuania',
	txtAddressCountryLU: 'Luxembourg',
	txtAddressCountryMO: 'Macau',
	txtAddressCountryMK: 'Macedonia',
	txtAddressCountryMG: 'Madagascar',
	txtAddressCountryMW: 'Malawi',
	txtAddressCountryMY: 'Malaysia',
	txtAddressCountryMV: 'Maldives',
	txtAddressCountryML: 'Mali',
	txtAddressCountryMT: 'Malta',
	txtAddressCountryMH: 'Marshall Islands',
	txtAddressCountryMQ: 'Martinique',
	txtAddressCountryMR: 'Mauritania',
	txtAddressCountryMU: 'Mauritius',
	txtAddressCountryMX: 'Mexico',
	txtAddressCountryFM: 'Micronesia',
	txtAddressCountryMD: 'Moldova',
	txtAddressCountryMC: 'Monaco',
	txtAddressCountryMN: 'Mongolia',
	txtAddressCountryME: 'Montenegro',
	txtAddressCountryMA: 'Morocco',
	txtAddressCountryMZ: 'Mozambique',
	txtAddressCountryMM: 'Myanmar',
	txtAddressCountryNA: 'Namibia',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Nepal',
	txtAddressCountryNL: 'Netherlands',
	txtAddressCountryNC: 'New Caledonia',
	txtAddressCountryNZ: 'New Zealand',
	txtAddressCountryNI: 'Nicaragua',
	txtAddressCountryNE: 'Niger',
	txtAddressCountryNG: 'Nigeria',
	txtAddressCountryNO: 'Norway',
	txtAddressCountryOM: 'Oman',
	txtAddressCountryPK: 'Pakistan',
	txtAddressCountryPW: 'Palau',
	txtAddressCountryPS: 'Palestinian Territories',
	txtAddressCountryPA: 'Panama',
	txtAddressCountryPG: 'Papua New Guinea',
	txtAddressCountryPY: 'Paraguay',
	txtAddressCountryPE: 'Peru',
	txtAddressCountryPH: 'Philippines',
	txtAddressCountryPL: 'Poland',
	txtAddressCountryPT: 'Portugal',
	txtAddressCountryPR: 'Puerto Rico',
	txtAddressCountryQA: 'Qatar',
	txtAddressCountryRE: 'Réunion',
	txtAddressCountryRO: 'Romania',
	txtAddressCountryRU: 'Russia',
	txtAddressCountryRW: 'Rwanda',
	txtAddressCountryBL: 'Saint Barthélemy',
	txtAddressCountrySH: 'Saint Helena',
	txtAddressCountryKN: 'Saint Kitts and Nevis',
	txtAddressCountryLC: 'Saint Lucia',
	txtAddressCountryMF: 'Saint Martin',
	txtAddressCountryVC: 'Saint Vincent and the Grenadines',
	txtAddressCountryWS: 'Samoa',
	txtAddressCountrySM: 'San Marino',
	txtAddressCountryST: 'Sao Tome and Principe',
	txtAddressCountrySA: 'Saudi Arabia',
	txtAddressCountrySN: 'Senegal',
	txtAddressCountryRS: 'Serbia',
	txtAddressCountrySC: 'Seychelles',
	txtAddressCountrySL: 'Sierra Leone',
	txtAddressCountrySG: 'Singapore',
	txtAddressCountrySK: 'Slovak Republic',
	txtAddressCountrySI: 'Slovenia',
	txtAddressCountrySB: 'Solomon Islands',
	txtAddressCountrySO: 'Somalia',
	txtAddressCountryZA: 'South Africa',
	txtAddressCountryGS: 'South Georgia and South Sandwich Islands',
	txtAddressCountryES: 'Spain',
	txtAddressCountryLK: 'Sri Lanka',
	txtAddressCountrySD: 'Sudan',
	txtAddressCountrySR: 'Suriname',
	txtAddressCountrySZ: 'Swaziland',
	txtAddressCountrySE: 'Sweden',
	txtAddressCountryCH: 'Switzerland',
	txtAddressCountrySY: 'Syria',
	txtAddressCountryTW: 'Taiwan',
	txtAddressCountryTJ: 'Tajikistan',
	txtAddressCountryTZ: 'Tanzania',
	txtAddressCountryTH: 'Thailand',
	txtAddressCountryTL: 'Timor-Leste',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga',
	txtAddressCountryTT: 'Trinidad and Tobago',
	txtAddressCountryTN: 'Tunisia',
	txtAddressCountryTR: 'Turkey',
	txtAddressCountryTM: 'Turkmenistan',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'U.S. Virgin Islands',
	txtAddressCountryUG: 'Uganda',
	txtAddressCountryUA: 'Ukraine',
	txtAddressCountryAE: 'United Arab Emirates',
	txtAddressCountryGB: 'United Kingdom',
	txtAddressCountryUS: 'United States',
	txtAddressCountryUY: 'Uruguay',
	txtAddressCountryUZ: 'Uzbekistan',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Vatican',
	txtAddressCountryVE: 'Venezuela',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Yemen',
	txtAddressCountryZM: 'Zambia',
	txtAddressCountryZW: 'Zimbabwe',

	/* data_process.js */
	addCategory: 'AddCategory',

	/* addressbook.js */
	contactConcurrentChange: 'The contact on the server was changed and reloaded!',
	contactRfcNotCompliant: 'Error: this contact (vCard) is not compliant with RFC 2426!',

	/* interface.js */
	loadingAddressbooks: 'Loading addressbooks (%act% of %total%) ...',

	/* webdav_protocol.js */
	succContactSaved: 'Contact successfully saved!',
	succContactDeleted: 'Contact successfully deleted!',
	succContactDeletedFromGroup: 'Contact successfully deleted from the active contact group!',
	errUnableLockBegin: 'Error: \'unable to lock resource\': %%!',
	errUnableUnlockBegin: 'Error: \'unable to unlock resource\': %%!',
	errUnableSaveBegin: 'Error: \'unable to save the contact\': %%!',
	errUnableSaveInvalidData: 'Error: \'unable to save\': correct the highlighted invalid values!',
	errUnableDeleteBegin: 'Error: \'unable to delete the contact\': %%!',
	errResourceLocked: 'resource already locked',
	errHttp410: 'contact is no longer available at the server'
}

localizationCardDAV['fr_FR']=	/* thanks John Fischer */
{
	/* index.html */
	altAddContact: 'Ajouter un contact',
	altPhoto: 'Photo',
	pholderPrefix: 'Préfixe',
	pholderSuffix: 'Suffixe',
	txtAddressbook: 'Annuaire',
	txtCompanies: 'Sociétés',
	txtContact: 'Contact',
	pholderGiven: 'Prénom',
	pholderFamily: 'Nom',
	pholderMiddle: 'Second prénom',
	pholderNickname: 'Surnom',
	pholderPhGiven: 'Prénom phonétique',
	pholderPhFamily: 'Nom phonétique',
	pholderBday: 'Date de naissance',
	pholderAnniversary: 'Anniversaire',
	pholderTitle: 'Profession',
	pholderOrg: 'Société',
	pholderDepartment: 'Service',
	txtCompanyContact: 'Contact de la Société',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» personnalisée',
	pholderCustomVal: 'personnalisée',

	txtPhone: 'Téléphone',
	txtPhoneWork: 'travail',
	txtPhoneHome: 'domicile',
	txtPhoneCell: 'mobile',
	txtPhoneCellWork: 'mobile travail',
	txtPhoneCellHome: 'mobile domicile',
	txtPhoneMain: 'principal',
	txtPhonePager: 'pager',
	txtPhoneFax: 'fax',
	txtPhoneFaxWork: 'fax de travail',
	txtPhoneFaxHome: 'fax de domicile',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'autres',
	pholderPhoneVal: 'Phone',

	txtEmail: 'Email',
	txtEmailWork: 'travail',
	txtEmailHome: 'domicile',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'autres',
	pholderEmailVal: 'Email',

	txtUrl: 'URL',
	txtUrlWork: 'travail',
	txtUrlHome: 'domicile',
	txtUrlHomepage: 'homePage',
	txtUrlOther: 'autre',
	pholderUrlVal: 'URL',

	txtRelated: 'Related',
	txtRelatedFather: 'père',
	txtRelatedMother: 'mère',
	txtRelatedParent: 'parent',
	txtRelatedBrother: 'frère',
	txtRelatedSister: 'soeur',
	txtRelatedChild: 'enfant',
	txtRelatedFriend: 'ami',
	txtRelatedSpouse: 'conjoint',
	txtRelatedPartner: 'partenaire',
	txtRelatedAssistant: 'assistant',
	txtRelatedManager: 'directeur',
	txtRelatedOther: 'autre',
	pholderRelatedVal: 'Name',

	txtIm: 'IM',
	txtImWork: 'travail',
	txtImHome: 'domicile',
	txtImMobileme: 'mobileMe',
	txtImOther: 'autre',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'UserID',

	txtProfile: 'Profil',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'Nom d\'utilisateur',

	txtAddress: 'Adresse',
	txtAddressWork: 'travail',
	txtAddressHome: 'domicile',
	txtAddressOther: 'autre',
	// address fields are handled specially

	txtCategories: 'Catégories',
	// categories' values are handled specially

	pholderNoteVal: 'NoteText',

	buttonCancel: 'Annuler',
	buttonDeleteFromGroup: 'Supprimer du groupe',

	/* common.js - address field names */
	pholderAddressCity: 'Ville',
	pholderAddressCityRegion: 'Ville/Quartier',
	pholderAddressCounty: 'County',
	pholderAddressCountyCity: 'Région/Ville',
	pholderAddressDepartment: 'Department',
	pholderAddressDistrict: 'District',
	pholderAddressDistrictSubdivision: 'District/Subdivision',
	pholderAddressFurtherDivisions: 'Further Divisions',
	pholderAddressGovernorate: 'Governorate',
	pholderAddressIslandName: 'Island Name',
	pholderAddressPinCode: 'PIN Code',
	pholderAddressPostCode: 'CP',
	pholderAddressPostal: 'Postal',
	pholderAddressPostalCode: 'Code Postal',
	pholderAddressPostalDistrict: 'Postal District',
	pholderAddressPrefecture: 'Prefecture',
	pholderAddressProvince: 'Province',
	pholderAddressRegion: 'CP',
	pholderAddressState: 'Région',
	pholderAddressStreet: 'Rue',
	pholderAddressSuburb: 'Suburb',
	pholderAddressTownshipDistrict: 'Township/District',
	pholderAddressZip: 'CP',

	txtAddressCountryAF: 'Afghanistan',
	txtAddressCountryAL: 'Albanie',
	txtAddressCountryDZ: 'Algérie',
	txtAddressCountryAD: 'Andorre',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua-et-Barbuda',
	txtAddressCountryAR: 'Argentine',
	txtAddressCountryAM: 'Arménie',
	txtAddressCountryAU: 'Australia',
	txtAddressCountryAT: 'Autriche',
	txtAddressCountryAZ: 'Azerbaïdjan',
	txtAddressCountryBS: 'Les Bahamas',
	txtAddressCountryBH: 'Bahreïn',
	txtAddressCountryBD: 'Bangladesh',
	txtAddressCountryBB: 'Barbade',
	txtAddressCountryBY: 'Biélorussie',
	txtAddressCountryBE: 'Belgique',
	txtAddressCountryBZ: 'Belize',
	txtAddressCountryBJ: 'Bénin',
	txtAddressCountryBM: 'Bermuda',
	txtAddressCountryBT: 'Bhoutan',
	txtAddressCountryBO: 'Bolivie',
	txtAddressCountryBA: 'Bosnie-Herzégovine',
	txtAddressCountryBW: 'Botswana',
	txtAddressCountryBR: 'Brésil',
	txtAddressCountryBN: 'Brunéi Darussalam',
	txtAddressCountryBG: 'Bulgarie',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Cambodge',
	txtAddressCountryCM: 'Cameroun',
	txtAddressCountryCA: 'Canada',
	txtAddressCountryCV: 'Le Cap-Vert',
	txtAddressCountryKY: 'Iles Caïmans',
	txtAddressCountryCF: 'République centrafricaine',
	txtAddressCountryTD: 'Tchad',
	txtAddressCountryCL: 'Chili',
	txtAddressCountryCN: 'Chine',
	txtAddressCountryCO: 'Colombie',
	txtAddressCountryKM: 'Comores',
	txtAddressCountryCD: 'République démocratique du Congo',
	txtAddressCountryCG: 'République du Congo',
	txtAddressCountryCR: 'Costa Rica',
	txtAddressCountryCI: 'Côte d`Ivoire',
	txtAddressCountryHR: 'Croatie',
	txtAddressCountryCU: 'Cuba',
	txtAddressCountryCY: 'Chypre',
	txtAddressCountryCZ: 'République tchèque',
	txtAddressCountryDK: 'Danemark',
	txtAddressCountryDJ: 'Djibouti',
	txtAddressCountryDM: 'Dominique',
	txtAddressCountryDO: 'La République dominicaine',
	txtAddressCountryEC: 'Équateur',
	txtAddressCountryEG: 'Égypte',
	txtAddressCountrySV: 'El Salvador',
	txtAddressCountryGQ: 'Guinée équatoriale',
	txtAddressCountryER: 'Erythrée',
	txtAddressCountryEE: 'Estonie',
	txtAddressCountryET: 'Ethiopie',
	txtAddressCountryFK: 'Îles Falkland',
	txtAddressCountryFO: 'Îles Féroé',
	txtAddressCountryFJ: 'Fidji',
	txtAddressCountryFI: 'Finlande',
	txtAddressCountryFR: 'France',
	txtAddressCountryPF: 'Polynésie française',
	txtAddressCountryGA: 'Gabon',
	txtAddressCountryGM: 'La Gambie',
	txtAddressCountryGE: 'Georgia',
	txtAddressCountryDE: 'Allemagne',
	txtAddressCountryGH: 'Ghana',
	txtAddressCountryGR: 'Grèce',
	txtAddressCountryGL: 'Groenland',
	txtAddressCountryGD: 'Grenade',
	txtAddressCountryGP: 'Guadeloupe',
	txtAddressCountryGT: "Guatemala",
	txtAddressCountryGN: 'Guinée',
	txtAddressCountryGW: 'Guinée-Bissau',
	txtAddressCountryGY: 'Guyane',
	txtAddressCountryHT: 'Haïti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hong Kong',
	txtAddressCountryHU: 'Hongrie',
	txtAddressCountryIS: 'Islande',
	txtAddressCountryIN: 'Inde',
	txtAddressCountryID: 'Indonésie',
	txtAddressCountryIR: 'Iran',
	txtAddressCountryIQ: 'Irak',
	txtAddressCountryIE: 'Irlande',
	txtAddressCountryIM: 'Île de Man ',
	txtAddressCountryIL: 'Israël',
	txtAddressCountryIT: 'Italie',
	txtAddressCountryJM: 'Jamaïque',
	txtAddressCountryJP: 'Japon',
	txtAddressCountryJO: 'Jordan',
	txtAddressCountryKZ: 'Kazakhstan',
	txtAddressCountryKE: 'Kenya',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'Corée du Nord',
	txtAddressCountryKR: 'La Corée du Sud',
	txtAddressCountryKW: 'Koweït',
	txtAddressCountryKG: 'Kirghizstan',
	txtAddressCountryLA: 'Laos',
	txtAddressCountryLV: 'Lettonie',
	txtAddressCountryLB: 'Liban',
	txtAddressCountryLS: 'Lesotho',
	txtAddressCountryLR: 'Liberia',
	txtAddressCountryLY: 'Libye',
	txtAddressCountryLI: 'Liechtenstein',
	txtAddressCountryLT: 'Lituanie',
	txtAddressCountryLU: 'Luxembourg',
	txtAddressCountryMO: 'Macao',
	txtAddressCountryMK: 'Macédoine',
	txtAddressCountryMG: 'Madagascar',
	txtAddressCountryMW: 'Malawi',
	txtAddressCountryMY: 'Malaisie',
	txtAddressCountryMV: 'Maldives',
	txtAddressCountryML: 'Le Mali',
	txtAddressCountryMT: 'Malte',
	txtAddressCountryMH: 'Iles Marshall',
	txtAddressCountryMQ: 'Martinique',
	txtAddressCountryMR: 'Mauritanie',
	txtAddressCountryMU: 'Maurice',
	txtAddressCountryMX: 'Mexique',
	txtAddressCountryFM: 'Micronésie',
	txtAddressCountryMD: 'Moldavie',
	txtAddressCountryMC: 'Monaco',
	txtAddressCountryMN: 'Mongolie',
	txtAddressCountryME: 'Monténégro',
	txtAddressCountryMA: 'Maroc',
	txtAddressCountryMZ: 'Mozambique',
	txtAddressCountryMM: 'Myanmar',
	txtAddressCountryNA: 'Namibie',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Népal',
	txtAddressCountryNL: 'Pays-Bas',
	txtAddressCountryNC: 'Nouvelle-Calédonie',
	txtAddressCountryNZ: 'Nouvelle-Zélande',
	txtAddressCountryNI: 'Nicaragua',
	txtAddressCountryNE: 'Niger',
	txtAddressCountryNG: 'Nigeria',
	txtAddressCountryNO: 'Norvège',
	txtAddressCountryOM: 'Oman',
	txtAddressCountryPK: 'Pakistan',
	txtAddressCountryPW: 'Palau',
	txtAddressCountryPS: 'Territoires palestiniens',
	txtAddressCountryPA: 'Panama',
	txtAddressCountryPG: 'Papouasie-Nouvelle-Guinée',
	txtAddressCountryPY: 'Paraguay',
	txtAddressCountryPE: 'Pérou',
	txtAddressCountryPH: 'Philippines',
	txtAddressCountryPL: 'Pologne',
	txtAddressCountryPT: 'Portugal',
	txtAddressCountryPR: 'Puerto Rico',
	txtAddressCountryQA: 'Qatar',
	txtAddressCountryRE: 'La Réunion',
	txtAddressCountryRO: 'Roumanie',
	txtAddressCountryRU: 'Russie',
	txtAddressCountryRW: 'Rwanda',
	txtAddressCountryBL: 'Saint-Barthélemy',
	txtAddressCountrySH: 'Sainte-Hélène',
	txtAddressCountryKN: 'Saint-Kitts-et-Nevis',
	txtAddressCountryLC: 'Sainte-Lucie',
	txtAddressCountryMF: 'Saint Martin',
	txtAddressCountryVC: 'Saint-Vincent-et-les Grenadines',
	txtAddressCountryWS: 'Samoa',
	txtAddressCountrySM: 'San Marino',
	txtAddressCountryST: 'Sao Tomé et Principe',
	txtAddressCountrySA: 'L`Arabie Saoudite',
	txtAddressCountrySN: 'Sénégal',
	txtAddressCountryRS: 'Serbie',
	txtAddressCountrySC: 'Seychelles',
	txtAddressCountrySL: 'Sierra Leone',
	txtAddressCountrySG: 'Singapour',
	txtAddressCountrySK: 'République slovaque',
	txtAddressCountrySI: 'Slovénie',
	txtAddressCountrySB: 'Îles Salomon',
	txtAddressCountrySO: 'Somalie',
	txtAddressCountryZA: 'Afrique du Sud',
	txtAddressCountryGS: 'Géorgie du Sud et îles Sandwich du Sud',
	txtAddressCountryES: 'Espagne',
	txtAddressCountryLK: 'Sri Lanka',
	txtAddressCountrySD: 'Soudan',
	txtAddressCountrySR: 'Suriname',
	txtAddressCountrySZ: 'Swaziland',
	txtAddressCountrySE: 'Suède',
	txtAddressCountryCH: 'Suisse',
	txtAddressCountrySY: 'Syrie',
	txtAddressCountryTW: 'Taiwan',
	txtAddressCountryTJ: 'Tadjikistan',
	txtAddressCountryTZ: 'Tanzanie',
	txtAddressCountryTH: 'Thaïlande',
	txtAddressCountryTL: 'Timor-Leste',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga',
	txtAddressCountryTT: 'Trinidad et Tobago',
	txtAddressCountryTN: 'Tunisie',
	txtAddressCountryTR: 'Turquie',
	txtAddressCountryTM: 'Turkménistan',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'Etats-Unis Îles Vierges ',
	txtAddressCountryUG: 'Ouganda',
	txtAddressCountryUA: 'Ukraine',
	txtAddressCountryAE: 'Emirats Arabes Unis',
	txtAddressCountryGB: 'Royaume-Uni ',
	txtAddressCountryUS: 'Les États-Unis',
	txtAddressCountryUY: 'Uruguay',
	txtAddressCountryUZ: 'Ouzbékistan',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Vatican II',
	txtAddressCountryVE: 'Venezuela',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Yémen',
	txtAddressCountryZM: 'Zambie',
	txtAddressCountryZW: 'Zimbabwe',

	/* data_process.js */
	addCategory: 'AjouterUneCatégorie',

	/* addressbook.js */
	contactConcurrentChange: 'Le contact sur le serveur a été modifié et a été rechargé!',
	contactRfcNotCompliant: 'Erreur: ce contact (vCard) ne respecte pas la norme RFC 2426!',

	/* interface.js */
	loadingAddressbooks: 'Chargement des contacts (%act% sur %total%) ...',

	/* webdav_protocol.js */
	succContactSaved: 'Le contact a été enregistré avec succès!',
	succContactDeleted: 'Le contact a été supprimé avec succès!',
	succContactDeletedFromGroup: 'Le contact a été supprimé avec succès du groupe de contact sélectionné!',
	errUnableLockBegin: 'Error: \'impossible de verrouiller la ressource\': %%!',
	errUnableUnlockBegin: 'Error: \'impossible de déverrouiller la ressource\': %%!',
	errUnableSaveBegin: 'Error: \'impossible de sauvegarder le contact\': %%!',
	errUnableSaveInvalidData: 'Error: \'impossible d\'enregistrer\': corriger les valeurs mises en évidence invalides!',
	errUnableDeleteBegin: 'Error: \'impossible de supprimer le contact\': %%!',
	errResourceLocked: 'la ressource est déjà verrouillé',
	errHttp410: 'le contact n\'est plus disponible sur le serveur'
}

localizationCardDAV['it_IT']=	/* thanks Luca Ferrario */
{
	/* index.html */
	altAddContact: 'Nuovo Contatto',
	altPhoto: 'Foto',
	txtAddressbook: 'Rubrica',
	txtCompanies: 'Aziende',
	txtContact: 'Contatto',
	pholderGiven: 'Nome',
	pholderFamily: 'Cognome',
	pholderMiddle: 'Altro Nome',
	pholderNickname: 'Nickname',
	pholderPhGiven: 'Nome fonetico',
	pholderPhFamily: 'Cognome fonetico',
	pholderPrefix: 'Prefisso',
	pholderSuffix: 'Suffisso',
	pholderBday: 'Compleanno',
	pholderAnniversary: 'Anniversario',
	pholderTitle: 'Ruolo',
	pholderOrg: 'Azienda',
	pholderDepartment: 'Dipartimento',
	txtCompanyContact: 'Contatto Aziendale',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» personalizzata',
	pholderCustomVal: 'personalizzata',

	txtPhone: 'Telefono',
	txtPhoneWork: 'ufficio',
	txtPhoneHome: 'casa',
	txtPhoneCell: 'cellulare',
	txtPhoneCellWork: 'cellulare lavoro',
	txtPhoneCellHome: 'cellulare personale',
	txtPhoneMain: 'principale',
	txtPhonePager: 'cercapersone',
	txtPhoneFax: 'fax',
	txtPhoneFaxWork: 'fax ufficio',
	txtPhoneFaxHome: 'fax casa',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'altro',
	pholderPhoneVal: 'Telefono',

	txtEmail: 'Email',
	txtEmailWork: 'lavoro',
	txtEmailHome: 'personale',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'alrra',
	pholderEmailVal: 'Email',

	txtUrl: 'Indirizzo web (URL)',
	txtUrlWork: 'lavoro',
	txtUrlHome: 'personale',
	txtUrlHomepage: 'Home Page',
	txtUrlOther: 'altro',
	pholderUrlVal: 'Indirizzo web',

	txtRelated: 'Relazione',
	txtRelatedFather: 'padre',
	txtRelatedMother: 'madre',
	txtRelatedParent: 'genitore',
	txtRelatedBrother: 'fratello',
	txtRelatedSister: 'sorella',
	txtRelatedChild: 'figlio',
	txtRelatedFriend: 'amico',
	txtRelatedSpouse: 'coniuge',
	txtRelatedPartner: 'partner',
	txtRelatedAssistant: 'assistente',
	txtRelatedManager: 'superiore',
	txtRelatedOther: 'altro',
	pholderRelatedVal: 'Name',

	txtIm: 'IM',
	txtImWork: 'lavoro',
	txtImHome: 'personale',
	txtImMobileme: 'mobileMe',
	txtImOther: 'altro',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'UserID',

	txtProfile: 'Profilo',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'Nome utente',

	txtAddress: 'Indirizzo',
	txtAddressWork: 'ufficio',
	txtAddressHome: 'casa',
	txtAddressOther: 'altro',
	// address fields are handled specially

	txtCategories: 'Categorie',
	// categories' values are handled specially

	pholderNoteVal: 'Note',

	buttonCancel: 'Annulla',
	buttonDeleteFromGroup: 'Elimina dal Gruppo',

	/* common.js - address field names */
	pholderAddressCity: 'Città',
	pholderAddressCityRegion: 'Regione/Città',
	pholderAddressCounty: 'Contea',
	pholderAddressCountyCity: 'Contea/Città',
	pholderAddressDepartment: 'Department',
	pholderAddressDistrict: 'Distretto',
	pholderAddressDistrictSubdivision: 'Distretto/Sottosezione',
	pholderAddressFurtherDivisions: 'Ulteriori Sottosezioni',
	pholderAddressGovernorate: 'Governatorato',
	pholderAddressIslandName: 'Nome dell\'Isola',
	pholderAddressPinCode: 'Codice PIN',
	pholderAddressPostCode: 'CAP',
	pholderAddressPostal: 'Postale',
	pholderAddressPostalCode: 'CAP',
	pholderAddressPostalDistrict: 'Distretto Postale',
	pholderAddressPrefecture: 'Prefettura',
	pholderAddressProvince: 'Provincia',
	pholderAddressRegion: 'Regione',
	pholderAddressState: 'Stato',
	pholderAddressStreet: 'Via',
	pholderAddressSuburb: 'Quartiere',
	pholderAddressTownshipDistrict: 'Distretto',
	pholderAddressZip: 'CAP',
	txtAddressCountryAF: 'Afghanistan',
	txtAddressCountryAL: 'Albania',
	txtAddressCountryDZ: 'Algeria',
	txtAddressCountryAD: 'Andorra',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua e Barbuda',
	txtAddressCountryAR: 'Argentina',
	txtAddressCountryAM: 'Armenia',
	txtAddressCountryAU: 'Australia',
	txtAddressCountryAT: 'Austria',
	txtAddressCountryAZ: 'Azerbaijan',
	txtAddressCountryBS: 'Bahamas',
	txtAddressCountryBH: 'Bahrain',
	txtAddressCountryBD: 'Bangladesh',
	txtAddressCountryBB: 'Barbados',
	txtAddressCountryBY: 'Belarus',
	txtAddressCountryBE: 'Belgio',
	txtAddressCountryBZ: 'Belize',
	txtAddressCountryBJ: 'Benin',
	txtAddressCountryBM: 'Bermuda',
	txtAddressCountryBT: 'Bhutan',
	txtAddressCountryBO: 'Bolivia',
	txtAddressCountryBA: 'Bosnia Herzegovina',
	txtAddressCountryBW: 'Botswana',
	txtAddressCountryBR: 'Brasile',
	txtAddressCountryBN: 'Brunei Darussalam',
	txtAddressCountryBG: 'Bulgaria',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Cambogia',
	txtAddressCountryCM: 'Camerun',
	txtAddressCountryCA: 'Canada',
	txtAddressCountryCV: 'Capo Verde',
	txtAddressCountryKY: 'Isole Cayman',
	txtAddressCountryCF: 'Repubblica Centrafricana',
	txtAddressCountryTD: 'Ciad',
	txtAddressCountryCL: 'Cile',
	txtAddressCountryCN: 'Cina',
	txtAddressCountryCO: 'Colombia',
	txtAddressCountryKM: 'Comore',
	txtAddressCountryCD: 'Repubblica Democratica del Congo',
	txtAddressCountryCG: 'Repubblica del Congo',
	txtAddressCountryCR: 'Costa Rica',
	txtAddressCountryCI: 'Costa d\'Avorio',
	txtAddressCountryHR: 'Croazia',
	txtAddressCountryCU: 'Cuba',
	txtAddressCountryCY: 'Cipro',
	txtAddressCountryCZ: 'Repubblica Ceca',
	txtAddressCountryDK: 'Danimarca',
	txtAddressCountryDJ: 'Djibouti',
	txtAddressCountryDM: 'Dominica',
	txtAddressCountryDO: 'Repubblica Dominicana',
	txtAddressCountryEC: 'Ecuador',
	txtAddressCountryEG: 'Egitto',
	txtAddressCountrySV: 'El Salvador',
	txtAddressCountryGQ: 'Guinea Equatoriale',
	txtAddressCountryER: 'Eritrea',
	txtAddressCountryEE: 'Estonia',
	txtAddressCountryET: 'Etiopia',
	txtAddressCountryFK: 'Isole Falkland',
	txtAddressCountryFO: 'Isole Faroe',
	txtAddressCountryFJ: 'Fiji',
	txtAddressCountryFI: 'Finlandia',
	txtAddressCountryFR: 'Francia',
	txtAddressCountryPF: 'Polinesia Francese',
	txtAddressCountryGA: 'Gabon',
	txtAddressCountryGM: 'Gambia',
	txtAddressCountryGE: 'Georgia',
	txtAddressCountryDE: 'Germania',
	txtAddressCountryGH: 'Ghana',
	txtAddressCountryGR: 'Grecia',
	txtAddressCountryGL: 'Groenlandia',
	txtAddressCountryGD: 'Grenada',
	txtAddressCountryGP: 'Guadeloupe',
	txtAddressCountryGT: 'Guatemala',
	txtAddressCountryGN: 'Guinea',
	txtAddressCountryGW: 'Guinea-Bissau',
	txtAddressCountryGY: 'Guyana',
	txtAddressCountryHT: 'Haiti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hong Kong',
	txtAddressCountryHU: 'Ungheria',
	txtAddressCountryIS: 'Islanda',
	txtAddressCountryIN: 'India',
	txtAddressCountryID: 'Indonesia',
	txtAddressCountryIR: 'Iran',
	txtAddressCountryIQ: 'Iraq',
	txtAddressCountryIE: 'Irlanda',
	txtAddressCountryIM: 'Isle of Man',
	txtAddressCountryIL: 'Israele',
	txtAddressCountryIT: 'Italia',
	txtAddressCountryJM: 'Jamaica',
	txtAddressCountryJP: 'Giappone',
	txtAddressCountryJO: 'Giordania',
	txtAddressCountryKZ: 'Kazakhstan',
	txtAddressCountryKE: 'Kenya',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'Korea del Nord',
	txtAddressCountryKR: 'Korea del Sud',
	txtAddressCountryKW: 'Kuwait',
	txtAddressCountryKG: 'Kyrgyzstan',
	txtAddressCountryLA: 'Laos',
	txtAddressCountryLV: 'Lettonia',
	txtAddressCountryLB: 'Libano',
	txtAddressCountryLS: 'Lesotho',
	txtAddressCountryLR: 'Liberia',
	txtAddressCountryLY: 'Libia',
	txtAddressCountryLI: 'Liechtenstein',
	txtAddressCountryLT: 'Lituania',
	txtAddressCountryLU: 'Lussemburgo',
	txtAddressCountryMO: 'Macau',
	txtAddressCountryMK: 'Macedonia',
	txtAddressCountryMG: 'Madagascar',
	txtAddressCountryMW: 'Malawi',
	txtAddressCountryMY: 'Malesia',
	txtAddressCountryMV: 'Maldive',
	txtAddressCountryML: 'Mali',
	txtAddressCountryMT: 'Malta',
	txtAddressCountryMH: 'Isole Marshall',
	txtAddressCountryMQ: 'Martinica',
	txtAddressCountryMR: 'Mauritania',
	txtAddressCountryMU: 'Mauritius',
	txtAddressCountryMX: 'Messico',
	txtAddressCountryFM: 'Micronesia',
	txtAddressCountryMD: 'Moldavia',
	txtAddressCountryMC: 'Monaco',
	txtAddressCountryMN: 'Mongolia',
	txtAddressCountryME: 'Montenegro',
	txtAddressCountryMA: 'Marocco',
	txtAddressCountryMZ: 'Mozambico',
	txtAddressCountryMM: 'Myanmar',
	txtAddressCountryNA: 'Namibia',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Nepal',
	txtAddressCountryNL: 'Olanda',
	txtAddressCountryNC: 'Nuova Caledonia',
	txtAddressCountryNZ: 'Nuova Zelanda',
	txtAddressCountryNI: 'Nicaragua',
	txtAddressCountryNE: 'Niger',
	txtAddressCountryNG: 'Nigeria',
	txtAddressCountryNO: 'Norvegia',
	txtAddressCountryOM: 'Oman',
	txtAddressCountryPK: 'Pakistan',
	txtAddressCountryPW: 'Palau',
	txtAddressCountryPS: 'Territori Palestinesi',
	txtAddressCountryPA: 'Panama',
	txtAddressCountryPG: 'Papua Nuova Guinea',
	txtAddressCountryPY: 'Paraguay',
	txtAddressCountryPE: 'Peru',
	txtAddressCountryPH: 'Flippine',
	txtAddressCountryPL: 'Polonia',
	txtAddressCountryPT: 'Portogallo',
	txtAddressCountryPR: 'Porto Rico',
	txtAddressCountryQA: 'Qatar',
	txtAddressCountryRE: 'Réunion',
	txtAddressCountryRO: 'Romania',
	txtAddressCountryRU: 'Russia',
	txtAddressCountryRW: 'Rwanda',
	txtAddressCountryBL: 'Saint Barthélemy',
	txtAddressCountrySH: 'Saint Helena',
	txtAddressCountryKN: 'Saint Kitts and Nevis',
	txtAddressCountryLC: 'Saint Lucia',
	txtAddressCountryMF: 'Saint Martin',
	txtAddressCountryVC: 'Saint Vincent and the Grenadines',
	txtAddressCountryWS: 'Samoa',
	txtAddressCountrySM: 'San Marino',
	txtAddressCountryST: 'Sao Tome e Principe',
	txtAddressCountrySA: 'Arabia Saudita',
	txtAddressCountrySN: 'Senegal',
	txtAddressCountryRS: 'Serbia',
	txtAddressCountrySC: 'Seychelles',
	txtAddressCountrySL: 'Sierra Leone',
	txtAddressCountrySG: 'Singapore',
	txtAddressCountrySK: 'Repubblica Slovacca',
	txtAddressCountrySI: 'Slovenia',
	txtAddressCountrySB: 'Isole Salomone',
	txtAddressCountrySO: 'Somalia',
	txtAddressCountryZA: 'Sudafrica',
	txtAddressCountryGS: 'South Georgia and South Sandwich Islands',
	txtAddressCountryES: 'Spagna',
	txtAddressCountryLK: 'Sri Lanka',
	txtAddressCountrySD: 'Sudan',
	txtAddressCountrySR: 'Suriname',
	txtAddressCountrySZ: 'Swaziland',
	txtAddressCountrySE: 'Svezia',
	txtAddressCountryCH: 'Svizzera',
	txtAddressCountrySY: 'Siria',
	txtAddressCountryTW: 'Taiwan',
	txtAddressCountryTJ: 'Tajikistan',
	txtAddressCountryTZ: 'Tanzania',
	txtAddressCountryTH: 'Tailandia',
	txtAddressCountryTL: 'Timor-Leste',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga',
	txtAddressCountryTT: 'Trinidad e Tobago',
	txtAddressCountryTN: 'Tunisia',
	txtAddressCountryTR: 'Turchia',
	txtAddressCountryTM: 'Turkmenistan',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'Isole Vergini degli USA',
	txtAddressCountryUG: 'Uganda',
	txtAddressCountryUA: 'Ucraina',
	txtAddressCountryAE: 'Emirati Arabi Uniti',
	txtAddressCountryGB: 'Regno Unito',
	txtAddressCountryUS: 'Stati uniti d\'America',
	txtAddressCountryUY: 'Uruguay',
	txtAddressCountryUZ: 'Uzbekistan',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Vaticano',
	txtAddressCountryVE: 'Venezuela',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Yemen',
	txtAddressCountryZM: 'Zambia',
	txtAddressCountryZW: 'Zimbabwe',

	/* data_process.js */
	addCategory: 'Aggiungi Categoria',

	/* addressbook.js */
	contactConcurrentChange: 'Il contatto è stato modificato sul server e non è stato ricaricato!',
	contactRfcNotCompliant: 'Attenzione: questo contatto (vCard) non è conforme allo standard RFC 2426!',

	/* interface.js */
	loadingAddressbooks: 'Caricamento rubriche in corso (%act% di %total%) ...',

	/* webdav_protocol.js */
	succContactSaved: 'Contatto salvato con successo!',
	succContactDeleted: 'Contatto eliminato con successo!',
	succContactDeletedFromGroup: 'Contatto eliminato con successo dal gruppo attivo!',
	errUnableLockBegin: 'Errore: \'impossibile eseguire il lock della risorsa\': %%!',
	errUnableUnlockBegin: 'Errore: \'impossibile eseguire l\'unlock della risorsa\': %%!',
	errUnableSaveBegin: 'Errore: \'impossibile salvare il contatto\': %%!',
	errUnableSaveInvalidData: 'Errore: \'impossibile salvare\': correggere i valori evidenziati non validi!',
	errUnableDeleteBegin: 'Errore: \'impossibile eliminare il contatto\': %%!',
	errResourceLocked: 'la risorsa risulta già bloccata (lock)',
	errHttp410: 'il contatto non è più disponibile sul server'
}

localizationCardDAV['hu_HU']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	/* index.html */
	altAddContact: 'Új kapcsolat',
	altPhoto: 'Fotó',
	txtAddressbook: 'Címjegyzék',
	txtCompanies: 'Vállalatok',
	txtContact: 'Kapcsolat',
	pholderGiven: 'Utó',
	pholderFamily: 'Családi',
	pholderMiddle: 'Középső',
	pholderNickname: 'Becenév',
	pholderPhGiven: 'Utó (fonetikus)',
	pholderPhFamily: 'Családi (fonetikus)',
	pholderPrefix: 'Előtag',
	pholderSuffix: 'Utótag',
	pholderBday: 'Születésnap',
	pholderAnniversary: 'Évforduló',
	pholderTitle: 'Foglalkozás',
	pholderOrg: 'Cég',
	pholderDepartment: 'Részleg',
	txtCompanyContact: 'Vállalati kapcsolat',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» egyéni',
	pholderCustomVal: 'egyéni',

	txtPhone: 'Telefon',
	txtPhoneWork: 'céges',
	txtPhoneHome: 'otthon',
	txtPhoneCell: 'mobil',
	txtPhoneCellWork: 'céges mobil',
	txtPhoneCellHome: 'otthoni mobil',
	txtPhoneMain: 'központi',
	txtPhonePager: 'csipogó',
	txtPhoneFax: 'fax',
	txtPhoneFaxWork: 'céges fax',
	txtPhoneFaxHome: 'hazai fax',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'egyéb',
	pholderPhoneVal: 'Telefon',

	txtEmail: 'Email',
	txtEmailWork: 'céges',
	txtEmailHome: 'otthon',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'egyéb',
	pholderEmailVal: 'Email',

	txtUrl: 'Web',
	txtUrlWork: 'céges',
	txtUrlHome: 'otthon',
	txtUrlHomepage: 'honlap',
	txtUrlOther: 'egyéb',
	pholderUrlVal: 'URL',

	txtRelated: 'Kapcsolódó személyek',
	txtRelatedFather: 'apa',
	txtRelatedMother: 'anya',
	txtRelatedParent: 'szülő',
	txtRelatedBrother: 'fiútestvér',
	txtRelatedSister: 'lánytestvér',
	txtRelatedChild: 'gyermek',
	txtRelatedFriend: 'barát',
	txtRelatedSpouse: 'házastárs',
	txtRelatedPartner: 'partner',
	txtRelatedAssistant: 'asszisztens',
	txtRelatedManager: 'főnök',
	txtRelatedOther: 'egyéb',
	pholderRelatedVal: 'Név',

	txtIm: 'Azonnali üzenetek',
	txtImWork: 'céges',
	txtImHome: 'otthon',
	txtImMobileme: 'mobileMe',
	txtImOther: 'egyéb',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'Felhasználói név',

	txtProfile: 'Profil',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'Felhasználói név',

	txtAddress: 'Cím',
	txtAddressWork: 'céges',
	txtAddressHome: 'otthon',
	txtAddressOther: 'egyéb',
	// address fields are handled specially

	txtCategories: 'Kategóriák',
	// categories' values are handled specially

	pholderNoteVal: 'Szöveg',

	buttonCancel: 'Mégse',
	buttonDeleteFromGroup: 'Törlés a csoportból',

	/* common.js - address field names */
	pholderAddressCity: 'Város',
	pholderAddressCityRegion: 'Város/Régió',
	pholderAddressCounty: 'Megye',
	pholderAddressCountyCity: 'Megye/Város',
	pholderAddressDepartment: 'Részleg',
	pholderAddressDistrict: 'Kerület',
	pholderAddressDistrictSubdivision: 'Kerület/Területegység',
	pholderAddressFurtherDivisions: 'További divíziók',
	pholderAddressGovernorate: 'Kormányzóság',
	pholderAddressIslandName: 'Szigetnév',
	pholderAddressPinCode: 'PIN-kód',
	pholderAddressPostCode: 'Ir. szám',
	pholderAddressPostal: 'Ir. szám',
	pholderAddressPostalCode: 'Ir. szám',
	pholderAddressPostalDistrict: 'Postai kerület',
	pholderAddressPrefecture: 'Prefektúra',
	pholderAddressProvince: 'Tartomány',
	pholderAddressRegion: 'Régió',
	pholderAddressState: 'Állam',
	pholderAddressStreet: 'Utca',
	pholderAddressSuburb: 'Külváros',
	pholderAddressTownshipDistrict: 'Község/Kerület',
	pholderAddressZip: 'Ir. szám',

	txtAddressCountryAF: 'Afganisztán',
	txtAddressCountryAL: 'Albánia',
	txtAddressCountryDZ: 'Algéria',
	txtAddressCountryAD: 'Andorra',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua és Barbuda',
	txtAddressCountryAR: 'Argentína',
	txtAddressCountryAM: 'Örményország',
	txtAddressCountryAU: 'Ausztrália',
	txtAddressCountryAT: 'Ausztria',
	txtAddressCountryAZ: 'Azerbajdzsán',
	txtAddressCountryBS: 'Bahamák',
	txtAddressCountryBH: 'Bahrein',
	txtAddressCountryBD: 'Banglades',
	txtAddressCountryBB: 'Barbados',
	txtAddressCountryBY: 'Fehéroroszország',
	txtAddressCountryBE: 'Belgium',
	txtAddressCountryBZ: 'Belize',
	txtAddressCountryBJ: 'Benin',
	txtAddressCountryBM: 'Bermuda',
	txtAddressCountryBT: 'Bhutan',
	txtAddressCountryBO: 'Bolívia',
	txtAddressCountryBA: 'Bosznia-Hercegovina',
	txtAddressCountryBW: 'Botswana',
	txtAddressCountryBR: 'Brazília',
	txtAddressCountryBN: 'Brunei Darussalam',
	txtAddressCountryBG: 'Bulgária',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Kambodzsa',
	txtAddressCountryCM: 'Kamerun',
	txtAddressCountryCA: 'Kanada',
	txtAddressCountryCV: 'Cape Verde',
	txtAddressCountryKY: 'Kajmán-szigetek',
	txtAddressCountryCF: 'Közép-afrikai Köztársaság',
	txtAddressCountryTD: 'Csád',
	txtAddressCountryCL: 'Chile',
	txtAddressCountryCN: 'Kína',
	txtAddressCountryCO: 'Kolumbia',
	txtAddressCountryKM: 'Comore-szigetek',
	txtAddressCountryCD: 'Kongói Demokratikus Köztársaság',
	txtAddressCountryCG: 'Kongói Köztársaság',
	txtAddressCountryCR: 'Costa Rica',
	txtAddressCountryCI: 'Elefántcsontpart',
	txtAddressCountryHR: 'Horvátország',
	txtAddressCountryCU: 'Kuba',
	txtAddressCountryCY: 'Ciprus',
	txtAddressCountryCZ: 'Csehország',
	txtAddressCountryDK: 'Dánia',
	txtAddressCountryDJ: 'Dzsibuti',
	txtAddressCountryDM: 'Dominika',
	txtAddressCountryDO: 'Dominikai Köztársaság',
	txtAddressCountryEC: 'Ecuador',
	txtAddressCountryEG: 'Egyiptom',
	txtAddressCountrySV: 'Salvador',
	txtAddressCountryGQ: 'Egyenlítiői Guinea',
	txtAddressCountryER: 'Eritrea',
	txtAddressCountryEE: 'Észtország',
	txtAddressCountryET: 'Etiópia',
	txtAddressCountryFK: 'Falkland-szigetek',
	txtAddressCountryFO: 'Feröer-szigetek',
	txtAddressCountryFJ: 'Fidzsi',
	txtAddressCountryFI: 'Finnország',
	txtAddressCountryFR: 'Franciaország',
	txtAddressCountryPF: 'Francia Polinézia',
	txtAddressCountryGA: 'Gabon',
	txtAddressCountryGM: 'Gambia',
	txtAddressCountryGE: 'Grúzia',
	txtAddressCountryDE: 'Németország',
	txtAddressCountryGH: 'Ghána',
	txtAddressCountryGR: 'Görögország',
	txtAddressCountryGL: 'Grönland',
	txtAddressCountryGD: 'Grenada',
	txtAddressCountryGP: 'Guadeloupe',
	txtAddressCountryGT: 'Guatemala',
	txtAddressCountryGN: 'Guinea',
	txtAddressCountryGW: 'Guinea-Bissau',
	txtAddressCountryGY: 'Guyana',
	txtAddressCountryHT: 'Haiti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hongkong',
	txtAddressCountryHU: 'Magyarország',
	txtAddressCountryIS: 'Izland',
	txtAddressCountryIN: 'India',
	txtAddressCountryID: 'Indonézia',
	txtAddressCountryIR: 'Irán',
	txtAddressCountryIQ: 'Irak',
	txtAddressCountryIE: 'Írország',
	txtAddressCountryIM: 'Man-sziget',
	txtAddressCountryIL: 'Izrael',
	txtAddressCountryIT: 'Olaszország',
	txtAddressCountryJM: 'Jamaica',
	txtAddressCountryJP: 'Japán',
	txtAddressCountryJO: 'Jordánia',
	txtAddressCountryKZ: 'Kazahsztán',
	txtAddressCountryKE: 'Kenya',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'Észak-Korea',
	txtAddressCountryKR: 'Dél-Korea',
	txtAddressCountryKW: 'Kuvait',
	txtAddressCountryKG: 'Kirgizisztán',
	txtAddressCountryLA: 'Laosz',
	txtAddressCountryLV: 'Lettország',
	txtAddressCountryLB: 'Libanon',
	txtAddressCountryLS: 'Lesotho',
	txtAddressCountryLR: 'Libéria',
	txtAddressCountryLY: 'Líbia',
	txtAddressCountryLI: 'Liechtenstein',
	txtAddressCountryLT: 'Litvánia',
	txtAddressCountryLU: 'Luxemburg',
	txtAddressCountryMO: 'Makaó',
	txtAddressCountryMK: 'Macedónia',
	txtAddressCountryMG: 'Madagaszkár',
	txtAddressCountryMW: 'Malawi',
	txtAddressCountryMY: 'Malajzia',
	txtAddressCountryMV: 'Maldív-szigetek',
	txtAddressCountryML: 'Mali',
	txtAddressCountryMT: 'Málta',
	txtAddressCountryMH: 'Marshall-szigetek',
	txtAddressCountryMQ: 'Martinique',
	txtAddressCountryMR: 'Mauritánia',
	txtAddressCountryMU: 'Mauritius',
	txtAddressCountryMX: 'Mexikó',
	txtAddressCountryFM: 'Mikronézia',
	txtAddressCountryMD: 'Moldova',
	txtAddressCountryMC: 'Monaco',
	txtAddressCountryMN: 'Mongólia',
	txtAddressCountryME: 'Montenegro',
	txtAddressCountryMA: 'Marokkó',
	txtAddressCountryMZ: 'Mozambik',
	txtAddressCountryMM: 'Myanmar',
	txtAddressCountryNA: 'Namíbia',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Nepál',
	txtAddressCountryNL: 'Hollandia',
	txtAddressCountryNC: 'Új-Kaledónia',
	txtAddressCountryNZ: 'Új-Zéland',
	txtAddressCountryNI: 'Nicaragua',
	txtAddressCountryNE: 'Niger',
	txtAddressCountryNG: 'Nigéria',
	txtAddressCountryNO: 'Norvégia',
	txtAddressCountryOM: 'Omán',
	txtAddressCountryPK: 'Pakisztán',
	txtAddressCountryPW: 'Palau',
	txtAddressCountryPS: 'Palesztin Területek',
	txtAddressCountryPA: 'Panama',
	txtAddressCountryPG: 'Pápua Új-Guinea',
	txtAddressCountryPY: 'Paraguay',
	txtAddressCountryPE: 'Peru',
	txtAddressCountryPH: 'Fülöp-szigetek',
	txtAddressCountryPL: 'Lengyelország',
	txtAddressCountryPT: 'Portugália',
	txtAddressCountryPR: 'Puerto Rico',
	txtAddressCountryQA: 'Katar',
	txtAddressCountryRE: 'Réunion',
	txtAddressCountryRO: 'Románia',
	txtAddressCountryRU: 'Oroszország',
	txtAddressCountryRW: 'Ruanda',
	txtAddressCountryBL: 'Saint-Barthélemy',
	txtAddressCountrySH: 'Saint Helena',
	txtAddressCountryKN: 'Saint Kitts és Nevis',
	txtAddressCountryLC: 'Saint Lucia',
	txtAddressCountryMF: 'Saint Martin',
	txtAddressCountryVC: 'Saint Vincent és Granadák',
	txtAddressCountryWS: 'Szamoa',
	txtAddressCountrySM: 'San Marino',
	txtAddressCountryST: 'Sao Tome és Principe',
	txtAddressCountrySA: 'Szaúd-Arábia',
	txtAddressCountrySN: 'Szenegál',
	txtAddressCountryRS: 'Szerbia',
	txtAddressCountrySC: 'Seychelle-szigetek',
	txtAddressCountrySL: 'Sierra Leone',
	txtAddressCountrySG: 'Szingapúr',
	txtAddressCountrySK: 'Szlovákia',
	txtAddressCountrySI: 'Szlovénia',
	txtAddressCountrySB: 'Salamon-szigetek',
	txtAddressCountrySO: 'Szomália',
	txtAddressCountryZA: 'Dél-Afrika',
	txtAddressCountryGS: 'Dél-Georgia és Déli Sandwich-szigetek',
	txtAddressCountryES: 'Spanyolország',
	txtAddressCountryLK: 'Sri Lanka',
	txtAddressCountrySD: 'Szudán',
	txtAddressCountrySR: 'Suriname',
	txtAddressCountrySZ: 'Szváziföld',
	txtAddressCountrySE: 'Švédország',
	txtAddressCountryCH: 'Švájc',
	txtAddressCountrySY: 'Szíria',
	txtAddressCountryTW: 'Tajvan',
	txtAddressCountryTJ: 'Tadzsikisztán',
	txtAddressCountryTZ: 'Tanzánia',
	txtAddressCountryTH: 'Thaiföld',
	txtAddressCountryTL: 'Timor-Leste',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga',
	txtAddressCountryTT: 'Trinidad és Tobago',
	txtAddressCountryTN: 'Tunézia',
	txtAddressCountryTR: 'Törökország',
	txtAddressCountryTM: 'Türkmenisztán',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'USA Virgin-szigetek',
	txtAddressCountryUG: 'Uganda',
	txtAddressCountryUA: 'Ukrajna',
	txtAddressCountryAE: 'Egyesült Arab Emírségek',
	txtAddressCountryGB: 'Egyesült Királyság',
	txtAddressCountryUS: 'Egyesült Államok',
	txtAddressCountryUY: 'Uruguay',
	txtAddressCountryUZ: 'Üzbegisztán',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Vatikán',
	txtAddressCountryVE: 'Venezuela',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Jemen',
	txtAddressCountryZM: 'Zambia',
	txtAddressCountryZW: 'Zimbabwe',

	/* data_process.js */
	addCategory: 'Új kategória',

	/* addressbook.js */
	contactConcurrentChange: 'A kapcsolat megváltozott a szerveren, és újra lett betöltve!',
	contactRfcNotCompliant: 'Hiba: a kapcsolat (vCard) nincs összhangban az RFC 2426 szabvánnyal!',

	/* interface.js */
	loadingAddressbooks: 'Források letöltése (%act%/%total%) ...',

	/* webdav_protocol.js */
	succContactSaved: 'A kapcsolat sikeresen elmentve!',
	succContactDeleted: 'A kapcsolat sikeresen törölve!',
	succContactDeletedFromGroup: 'A kapcsolat sikeresen törölve az aktív kapcsolatcsoportból!',
	errUnableLockBegin: 'Hiba: \'nem sikerült a forrás lezárása\': %%!',
	errUnableUnlockBegin: 'Hiba: \'nem sikerült a forrás kizárása\': %%!',
	errUnableSaveBegin: 'Hiba: \'nem sikerült a kapcsolat elmentése\': %%!',
	errUnableSaveInvalidData: 'Hiba: \'nem lehet menteni\': javítsa ki a kijelölt érvénytelen értékeket!',
	errUnableDeleteBegin: 'Hiba: \'nem sikerült a kapcsolat törlése\': %%!',
	errResourceLocked: 'a forrás jelenleg le van zárva',
	errHttp410: 'a kapcsolat már nem elérhető a szerveren'
}

localizationCardDAV['nl_NL']=	/* thanks Johan Vromans */
{
	/* index.html */
	altAddContact: 'Contact toevoegen',
	altPhoto: 'Foto',
	txtAddressbook: 'Adresboek',
	txtCompanies: 'Bedrijven',
	txtContact: 'Contact',
	pholderGiven: 'Voornaam',
	pholderFamily: 'Achternaam',
	pholderMiddle: 'Tussenvoegsel',
	pholderNickname: 'Roepnaam',
	pholderPhGiven: 'Voornaam (fonetisch)',
	pholderPhFamily: 'Achternaam (fonetisch)',
	pholderPrefix: 'Voorvoegsel',
	pholderSuffix: 'Achtervoegsel',
	pholderBday: 'Geboortedatum',
	pholderAnniversary: 'Verjaardag',
	pholderTitle: 'Beroep',
	pholderOrg: 'Bedrijf',
	pholderDepartment: 'Afdeling',
	txtCompanyContact: 'Contactpersoon bedrijf',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» specifiek',
	pholderCustomVal: 'specifiek',

	txtPhone: 'Telefoon',
	txtPhoneWork: 'werk',
	txtPhoneHome: 'privé',
	txtPhoneCell: 'mobiel',
	txtPhoneCellWork: 'mobiel werk',
	txtPhoneCellHome: 'mobiel privé',
	txtPhoneMain: 'primair',
	txtPhonePager: 'pager',
	txtPhoneFax: 'fax',
	txtPhoneFaxWork: 'fax werk',
	txtPhoneFaxHome: 'fax privé',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'anders',
	pholderPhoneVal: 'Telefoonnummer',

	txtEmail: 'E-mail',
	txtEmailWork: 'werk',
	txtEmailHome: 'privé',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'anders',
	pholderEmailVal: 'E-mail',

	txtUrl: 'Webstek',
	txtUrlWork: 'werk',
	txtUrlHome: 'privé',
	txtUrlHomepage: 'homepage',
	txtUrlOther: 'anders',
	pholderUrlVal: 'URL',

	txtRelated: 'Relaties',
	txtRelatedFather: 'vader',
	txtRelatedMother: 'moeder',
	txtRelatedParent: 'ouder',
	txtRelatedBrother: 'broer',
	txtRelatedSister: 'zus',
	txtRelatedChild: 'kind',
	txtRelatedFriend: 'vriend',
	txtRelatedSpouse: 'echtgeno(o)t(e)',
	txtRelatedPartner: 'partner',
	txtRelatedAssistant: 'assistent',
	txtRelatedManager: 'manager',
	txtRelatedOther: 'anders',
	pholderRelatedVal: 'Naam',

	txtIm: 'Instant Messaging',
	txtImWork: 'werk',
	txtImHome: 'privé',
	txtImMobileme: 'mobileMe',
	txtImOther: 'anders',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'UserID',

	txtProfile: 'Profiel',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'UserName',

	txtAddress: 'Adres',
	txtAddressWork: 'werk',
	txtAddressHome: 'privé',
	txtAddressOther: 'anders',
	// address fields are handled specially

	txtCategories: 'Categorieën',
	// categories' values are handled specially

	pholderNoteVal: 'Tekst',

	buttonCancel: 'Annuleren',
	buttonDeleteFromGroup: 'Uit de groep verwijderen',

	/* common.js - address field names */
	pholderAddressCity: 'Plaats',
	pholderAddressPostalCode: 'Postcode',
	pholderAddressStreet: 'Straat',

	/* These are not used in NL */
	pholderAddressCityRegion: 'Plaats/Regio',
	pholderAddressCounty: 'Landsdeel',
	pholderAddressCountyCity: 'Landsdeel/City',
	pholderAddressDepartment: 'Departement',
	pholderAddressDistrict: 'District',
	pholderAddressDistrictSubdivision: 'District/Onderdeel',
	pholderAddressFurtherDivisions: 'Andere onderdelen',
	pholderAddressGovernorate: 'Deelstaat',
	pholderAddressIslandName: 'Eiland',
	pholderAddressPinCode: 'PIN Code',
	pholderAddressPostCode: 'Postcode',
	pholderAddressPostal: 'Post',
	pholderAddressPostalDistrict: 'Postdistrict',
	pholderAddressPrefecture: 'Prefectuur',
	pholderAddressProvince: 'Provincie',
	pholderAddressRegion: 'Regio',
	pholderAddressState: 'Staat',
	pholderAddressSuburb: 'Stadsdeel',
	pholderAddressTownshipDistrict: 'Stad/District',
	pholderAddressZip: 'PC',
	/* End of unused texts */

	/* Translated entries */
	txtAddressCountryAF: 'Afghanistan',
	txtAddressCountryAL: 'Albanië',
	txtAddressCountryDZ: 'Algerije',
	txtAddressCountryAD: 'Andorra',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua en Barbuda',
	txtAddressCountryAR: 'Argentinië',
	txtAddressCountryAM: 'Armenië',
	txtAddressCountryAU: 'Australië',
	txtAddressCountryAT: 'Oostenrijk',
	txtAddressCountryAZ: 'Azerbeidzjan',
	txtAddressCountryBS: 'Bahama’s',
	txtAddressCountryBH: 'Bahrein',
	txtAddressCountryBD: 'Bangladesh',
	txtAddressCountryBB: 'Barbados',
	txtAddressCountryBY: 'Wit-Rusland',
	txtAddressCountryBE: 'België',
	txtAddressCountryBZ: 'Belize (land)',
	txtAddressCountryBJ: 'Benin',
	txtAddressCountryBM: 'Bermuda',
	txtAddressCountryBT: 'Bhutan',
	txtAddressCountryBO: 'Bolivia',
	txtAddressCountryBA: 'Bosnië-Herzegovina',
	txtAddressCountryBW: 'Botswana',
	txtAddressCountryBR: 'Brazilië',
	txtAddressCountryBN: 'Brunei',
	txtAddressCountryBG: 'Bulgarije',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Cambodja',
	txtAddressCountryCM: 'Kameroen',
	txtAddressCountryCA: 'Canada',
	txtAddressCountryCV: 'Kaapverdië',
	txtAddressCountryKY: 'Caymaneilanden',
	txtAddressCountryCF: 'Centraal-Afrikaanse Republiek',
	txtAddressCountryTD: 'Tsjaad',
	txtAddressCountryCL: 'Chili',
	txtAddressCountryCN: 'Volksrepubliek China',
	txtAddressCountryCO: 'Colombia',
	txtAddressCountryKM: 'Comoren',
	txtAddressCountryCD: 'Congo-Kinshasa',
	txtAddressCountryCG: 'Congo-Brazzaville',
	txtAddressCountryCR: 'Costa Rica',
	txtAddressCountryCI: 'Ivoorkust',
	txtAddressCountryHR: 'Kroatië',
	txtAddressCountryCU: 'Cuba',
	txtAddressCountryCY: 'Cyprus',
	txtAddressCountryCZ: 'Tsjechië',
	txtAddressCountryDK: 'Denemarken',
	txtAddressCountryDJ: 'Djibouti',
	txtAddressCountryDM: 'Dominica',
	txtAddressCountryDO: 'Dominicaanse Republiek',
	txtAddressCountryEC: 'Ecuador',
	txtAddressCountryEG: 'Egypte',
	txtAddressCountrySV: 'El Salvador',
	txtAddressCountryGQ: 'Equatoriaal-Guinea',
	txtAddressCountryER: 'Eritrea',
	txtAddressCountryEE: 'Estland',
	txtAddressCountryET: 'Ethiopië',
	txtAddressCountryFK: 'Falklandeilanden',
	txtAddressCountryFO: 'Faeröer',
	txtAddressCountryFJ: 'Fiji',
	txtAddressCountryFI: 'Finland',
	txtAddressCountryFR: 'Frankrijk',
	txtAddressCountryPF: 'Frans-Polynesië',
	txtAddressCountryGA: 'Gabon',
	txtAddressCountryGM: 'Gambia (land)',
	txtAddressCountryGE: 'Georgië',
	txtAddressCountryDE: 'Duitsland',
	txtAddressCountryGH: 'Ghana',
	txtAddressCountryGR: 'Griekenland',
	txtAddressCountryGL: 'Groenland',
	txtAddressCountryGD: 'Grenada',
	txtAddressCountryGP: 'Guadeloupe',
	txtAddressCountryGT: 'Guatemala',
	txtAddressCountryGN: 'Guinee',
	txtAddressCountryGW: 'Guinee-Bissau',
	txtAddressCountryGY: 'Guyana',
	txtAddressCountryHT: 'Haïti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hongkong',
	txtAddressCountryHU: 'Hongarije',
	txtAddressCountryIS: 'IJsland',
	txtAddressCountryIN: 'India',
	txtAddressCountryID: 'Indonesië',
	txtAddressCountryIR: 'Iran',
	txtAddressCountryIQ: 'Irak',
	txtAddressCountryIE: 'Ierse Republiek',
	txtAddressCountryIM: 'Isle of Man',
	txtAddressCountryIL: 'Israël',
	txtAddressCountryIT: 'Italië',
	txtAddressCountryJM: 'Jamaica',
	txtAddressCountryJP: 'Japan',
	txtAddressCountryJO: 'Jordanië',
	txtAddressCountryKZ: 'Kazachstan',
	txtAddressCountryKE: 'Kenia',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'Noord-Korea',
	txtAddressCountryKR: 'Zuid-Korea',
	txtAddressCountryKW: 'Koeweit',
	txtAddressCountryKG: 'Kirgizië',
	txtAddressCountryLA: 'Laos',
	txtAddressCountryLV: 'Letland',
	txtAddressCountryLB: 'Libanon',
	txtAddressCountryLS: 'Lesotho',
	txtAddressCountryLR: 'Liberia',
	txtAddressCountryLY: 'Libië',
	txtAddressCountryLI: 'Liechtenstein',
	txtAddressCountryLT: 'Litouwen',
	txtAddressCountryLU: 'Luxemburg',
	txtAddressCountryMO: 'Macao',
	txtAddressCountryMK: 'Macedonië',
	txtAddressCountryMG: 'Madagaskar',
	txtAddressCountryMW: 'Malawi',
	txtAddressCountryMY: 'Maleisië',
	txtAddressCountryMV: 'Maldiven',
	txtAddressCountryML: 'Mali',
	txtAddressCountryMT: 'Malta',
	txtAddressCountryMH: 'Marshalleilanden',
	txtAddressCountryMQ: 'Martinique',
	txtAddressCountryMR: 'Mauritanië',
	txtAddressCountryMU: 'Mauritius',
	txtAddressCountryMX: 'Mexico (land)',
	txtAddressCountryFM: 'Micronesia',
	txtAddressCountryMD: 'Moldavië',
	txtAddressCountryMC: 'Monaco',
	txtAddressCountryMN: 'Mongolië',
	txtAddressCountryMA: 'Marokko',
	txtAddressCountryMZ: 'Mozambique',
	txtAddressCountryMM: 'Myanmar',
	txtAddressCountryNA: 'Namibië',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Nepal',
	txtAddressCountryNL: 'Nederland',
	txtAddressCountryNC: 'Nieuw-Caledonië',
	txtAddressCountryNZ: 'Nieuw-Zeeland',
	txtAddressCountryNI: 'Nicaragua',
	txtAddressCountryNE: 'Niger (land)',
	txtAddressCountryNG: 'Nigeria',
	txtAddressCountryNO: 'Noorwegen',
	txtAddressCountryOM: 'Oman',
	txtAddressCountryPK: 'Pakistan',
	txtAddressCountryPW: 'Palau (land)',
	txtAddressCountryPS: 'Palestina',
	txtAddressCountryPA: 'Panama (land)',
	txtAddressCountryPG: 'Papoea-Nieuw-Guinea',
	txtAddressCountryPY: 'Paraguay',
	txtAddressCountryPE: 'Peru',
	txtAddressCountryPH: 'Filipijnen',
	txtAddressCountryPL: 'Polen',
	txtAddressCountryPT: 'Portugal',
	txtAddressCountryPR: 'Puerto Rico',
	txtAddressCountryQA: 'Qatar',
	txtAddressCountryRE: 'Réunion',
	txtAddressCountryRO: 'Roemenië',
	txtAddressCountryRU: 'Rusland',
	txtAddressCountryRW: 'Rwanda',
	txtAddressCountrySH: 'Sint Helena',
	txtAddressCountryKN: 'Saint Kitts en Nevis',
	txtAddressCountryLC: 'Saint Lucia',
	txtAddressCountryVC: 'Saint Vincent en de Grenadines',
	txtAddressCountryWS: 'Samoa',
	txtAddressCountrySM: 'San Marino',
	txtAddressCountryST: 'São Tomé en Principe',
	txtAddressCountrySA: 'Saoedi-Arabië',
	txtAddressCountrySN: 'Servië',
	txtAddressCountrySC: 'Seychellen',
	txtAddressCountrySL: 'Sierra Leone',
	txtAddressCountrySG: 'Singapore',
	txtAddressCountrySK: 'Slowakije',
	txtAddressCountrySI: 'Slovenië',
	txtAddressCountrySB: 'Solomon Eilanden',
	txtAddressCountrySO: 'Somalië',
	txtAddressCountryZA: 'Zuid-Afrika',
	txtAddressCountryGS: 'Sandwich Eilanden',
	txtAddressCountryES: 'Spanje',
	txtAddressCountryLK: 'Sri Lanka',
	txtAddressCountrySD: 'Soedan',
	txtAddressCountrySR: 'Suriname',
	txtAddressCountrySZ: 'Swaziland',
	txtAddressCountrySE: 'Zweden',
	txtAddressCountryCH: 'Zwitserland',
	txtAddressCountrySY: 'Syrië',
	txtAddressCountryTW: 'Taiwan',
	txtAddressCountryTJ: 'Tadzjikistan',
	txtAddressCountryTZ: 'Tanzania',
	txtAddressCountryTH: 'Thailand',
	txtAddressCountryTL: 'Oost-Timor',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga (land)',
	txtAddressCountryTT: 'Trinidad en Tobago',
	txtAddressCountryTN: 'Tunesië',
	txtAddressCountryTR: 'Turkije',
	txtAddressCountryTM: 'Turkmenistan',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'Amerikaanse Maagdeneilanden',
	txtAddressCountryUG: 'Oeganda',
	txtAddressCountryUA: 'Oekraïne',
	txtAddressCountryAE: 'Verenigde Arabische Emiraten',
	txtAddressCountryGB: 'Verenigd Koninkrijk',
	txtAddressCountryUS: 'Verenigde Staten van Amerika',
	txtAddressCountryUY: 'Uruguay',
	txtAddressCountryUZ: 'Oezbekistan',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Vaticaanstad',
	txtAddressCountryVE: 'Venezuela',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Jemen',
	txtAddressCountryZM: 'Zambia',
	txtAddressCountryZW: 'Zimbabwe',
	txtAddressCountryME: 'Montenegro',
	txtAddressCountryBL: 'Saint Barthélemy',
	txtAddressCountryMF: 'Saint Martin',
	txtAddressCountryRS: 'Serbia',

	/* Additional entries */
	ttxtAddressCountryAI: 'Anguilla',
	ttxtAddressCountryAN: 'Nederlandse Antillen',
	ttxtAddressCountryAQ: 'Antarctica',
	ttxtAddressCountryAS: 'Amerikaans-Samoa',
	ttxtAddressCountryAW: 'Aruba',
	ttxtAddressCountryBV: 'Bouvet',
	ttxtAddressCountryCC: 'Cocoseilanden',
	ttxtAddressCountryCK: 'Cookeilanden',
	ttxtAddressCountryCS: 'Servië en Montenegro',
	ttxtAddressCountryCX: 'Christmaseiland',
	ttxtAddressCountryEH: 'Westelijke Sahara',
	ttxtAddressCountryGF: 'Frans-Guyana',
	ttxtAddressCountryGI: 'Gibraltar',
	ttxtAddressCountryGU: 'Guam',
	ttxtAddressCountryHM: 'Heard- en McDonaldeilanden',
	ttxtAddressCountryIO: 'Brits IO Territorium',
	ttxtAddressCountryMP: 'Noordelijke Marianen',
	ttxtAddressCountryMS: 'Montserrat',
	ttxtAddressCountryNF: 'Norfolkeiland',
	ttxtAddressCountryNU: 'Niue',
	ttxtAddressCountryPM: 'Saint-Pierre en Miquelon',
	ttxtAddressCountryPN: 'Pitcairn',
	ttxtAddressCountrySJ: 'Jan Mayen',
	ttxtAddressCountryTC: 'Turks en Caicos eilanden',
	ttxtAddressCountryTF: 'Franse Zuidelijke Gebieden',
	ttxtAddressCountryTK: 'Tokelau',
	ttxtAddressCountryUM: 'Kleine Pacifische eilanden VS',
	ttxtAddressCountryVG: 'Britse Maagdeneilanden',
	ttxtAddressCountryWF: 'Wallis en Futuna',
	ttxtAddressCountryYT: 'Mayotte',

	/* data_process.js */
	addCategory: 'AddCategory',

	/* addressbook.js */
	contactConcurrentChange: 'Dit contact was op de server gewijzigd en is opnieuw opgehaald',
	contactRfcNotCompliant: 'Fout: Dit contact (vCard) is niet conform de RFC 2426 richtlijn',

	/* interface.js */
	loadingAddressbooks: 'Adresboeken worden geladen (%act% van %total%) ...',

	/* webdav_protocol.js */
	succContactSaved: 'Contact opgeslagen',
	succContactDeleted: 'Contact verwijderd',
	succContactDeletedFromGroup: 'Contact verwijderd uit de huidige contact groep',
	errUnableLockBegin: 'Fout: Exclusieve toegang kan niet worden gerealiseerd: %%',
	errUnableUnlockBegin: 'Fout: Exclusieve toegang kan niet worden opgeheven: %%',
	errUnableSaveBegin: 'Fout: Het contact kan niet worden opgeslagen: %%',
	errUnableSaveInvalidData: 'Fout: Corrigeer eerst de aangegeven waarden',
	errUnableDeleteBegin: 'Fout: Het contact kan niet worden verwijderd: %%',
	errResourceLocked: 'Dit contact is (tijdelijk) in gebruik',
	errHttp410: 'Dit contact is niet langer beschikbaar op de server'
}

localizationCardDAV['sk_SK']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	/* index.html */
	altAddContact: 'Pridať kontakt',
	altPhoto: 'Fotka',
	txtAddressbook: 'Adresár',
	txtCompanies: 'Firmy',
	txtContact: 'Kontakt',
	pholderGiven: 'Meno',
	pholderFamily: 'Priezvisko',
	pholderMiddle: 'Stredné meno',
	pholderNickname: 'Prezývka',
	pholderPhGiven: 'Meno foneticky',
	pholderPhFamily: 'Priezvisko foneticky',
	pholderPrefix: 'Titul pred',
	pholderSuffix: 'Titul za',
	pholderBday: 'Narodeniny',
	pholderAnniversary: 'Výročie',
	pholderTitle: 'Pozícia',
	pholderOrg: 'Spoločnosť',
	pholderDepartment: 'Oddelenie',
	txtCompanyContact: 'Kontakt na spoločnosť',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» vlastné',
	pholderCustomVal: 'vlastné',

	txtPhone: 'Telefón',
	txtPhoneWork: 'práca',
	txtPhoneHome: 'domov',
	txtPhoneCell: 'mobil',
	txtPhoneCellWork: 'mobil do práce',
	txtPhoneCellHome: 'mobil domov',
	txtPhoneMain: 'hlavný',
	txtPhonePager: 'pager',
	txtPhoneFax: 'fax',
	txtPhoneFaxWork: 'fax do práce',
	txtPhoneFaxHome: 'fax domov',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'iný',
	pholderPhoneVal: 'Telefón',

	txtEmail: 'Email',
	txtEmailWork: 'práca',
	txtEmailHome: 'domov',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'iný',
	pholderEmailVal: 'Email',

	txtUrl: 'Web',
	txtUrlWork: 'práca',
	txtUrlHome: 'domov',
	txtUrlHomepage: 'web',
	txtUrlOther: 'iný',
	pholderUrlVal: 'URL',

	txtRelated: 'Súvisiaci',
	txtRelatedFather: 'otec',
	txtRelatedMother: 'matka',
	txtRelatedParent: 'rodič',
	txtRelatedBrother: 'brat',
	txtRelatedSister: 'sestra',
	txtRelatedChild: 'dieťa',
	txtRelatedFriend: 'priateľ',
	txtRelatedSpouse: 'druh/družka',
	txtRelatedPartner: 'partner/ka',
	txtRelatedAssistant: 'asistent',
	txtRelatedManager: 'manažér',
	txtRelatedOther: 'iný',
	pholderRelatedVal: 'Meno',

	txtIm: 'IM účet',
	txtImWork: 'práca',
	txtImHome: 'domov',
	txtImMobileme: 'mobileMe',
	txtImOther: 'iný',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'Meno',

	txtProfile: 'Profil',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'Meno',

	txtAddress: 'Adresa',
	txtAddressWork: 'práca',
	txtAddressHome: 'domov',
	txtAddressOther: 'iný',
	// address fields are handled specially

	txtCategories: 'Kategórie',
	// categories' values are handled specially

	pholderNoteVal: 'Text',

	buttonCancel: 'Storno',
	buttonDeleteFromGroup: 'Vymazať zo skupiny',

	/* common.js - address field names */
	pholderAddressCity: 'Mesto',
	pholderAddressCityRegion: 'Mesto/Región',
	pholderAddressCounty: 'Kraj',
	pholderAddressCountyCity: 'Kraj/Mesto',
	pholderAddressDepartment: 'Oddelenie',
	pholderAddressDistrict: 'Okres',
	pholderAddressDistrictSubdivision: 'Okres',
	pholderAddressFurtherDivisions: 'Ďaľšie územné celky',
	pholderAddressGovernorate: 'Gubernia',
	pholderAddressIslandName: 'Názov ostrova',
	pholderAddressPinCode: 'PIN kód',
	pholderAddressPostCode: 'PSČ',
	pholderAddressPostal: 'PSČ',
	pholderAddressPostalCode: 'PSČ',
	pholderAddressPostalDistrict: 'Poštový okrsok',
	pholderAddressPrefecture: 'Prefektúra',
	pholderAddressProvince: 'Provincia',
	pholderAddressRegion: 'Región',
	pholderAddressState: 'Štát',
	pholderAddressStreet: 'Ulica',
	pholderAddressSuburb: 'Predmestie',
	pholderAddressTownshipDistrict: 'Obvod/Okres',
	pholderAddressZip: 'PSČ',

	txtAddressCountryAF: 'Afganistan',
	txtAddressCountryAL: 'Albánsko',
	txtAddressCountryDZ: 'Alžírsko',
	txtAddressCountryAD: 'Andora',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua a Barbuda',
	txtAddressCountryAR: 'Argentína',
	txtAddressCountryAM: 'Arménsko',
	txtAddressCountryAU: 'Austrália',
	txtAddressCountryAT: 'Rakúsko',
	txtAddressCountryAZ: 'Azerbajdžan',
	txtAddressCountryBS: 'Bahamy',
	txtAddressCountryBH: 'Bahrajn',
	txtAddressCountryBD: 'Bangladéš',
	txtAddressCountryBB: 'Barbados',
	txtAddressCountryBY: 'Bielorusko',
	txtAddressCountryBE: 'Belgicko',
	txtAddressCountryBZ: 'Belize',
	txtAddressCountryBJ: 'Benin',
	txtAddressCountryBM: 'Bermudy',
	txtAddressCountryBT: 'Bután',
	txtAddressCountryBO: 'Bolívia',
	txtAddressCountryBA: 'Bosna a Hercegovina',
	txtAddressCountryBW: 'Botswana',
	txtAddressCountryBR: 'Brazília',
	txtAddressCountryBN: 'Brunei Darussalam',
	txtAddressCountryBG: 'Bulharsko',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Kambodža',
	txtAddressCountryCM: 'Kamerun',
	txtAddressCountryCA: 'Kanada',
	txtAddressCountryCV: 'Kapverdy',
	txtAddressCountryKY: 'Kajmanské ostrovy',
	txtAddressCountryCF: 'Stredoafrická republika',
	txtAddressCountryTD: 'Čad',
	txtAddressCountryCL: 'Čile',
	txtAddressCountryCN: 'Čína',
	txtAddressCountryCO: 'Kolumbia',
	txtAddressCountryKM: 'Komory',
	txtAddressCountryCD: 'Demokratická republika Kongo',
	txtAddressCountryCG: 'Konžská republika',
	txtAddressCountryCR: 'Kostarika',
	txtAddressCountryCI: 'Pobrežie slonoviny',
	txtAddressCountryHR: 'Chorvátsko',
	txtAddressCountryCU: 'Kuba',
	txtAddressCountryCY: 'Cyprus',
	txtAddressCountryCZ: 'Česká republika',
	txtAddressCountryDK: 'Dánsko',
	txtAddressCountryDJ: 'Džibuti',
	txtAddressCountryDM: 'Dominika',
	txtAddressCountryDO: 'Dominikánska republika',
	txtAddressCountryEC: 'Ekvádor',
	txtAddressCountryEG: 'Egypt',
	txtAddressCountrySV: 'Salvador',
	txtAddressCountryGQ: 'Rovníková Guinea',
	txtAddressCountryER: 'Eritrea',
	txtAddressCountryEE: 'Estónsko',
	txtAddressCountryET: 'Etiópia',
	txtAddressCountryFK: 'Falklandy',
	txtAddressCountryFO: 'Faerské ostrovy',
	txtAddressCountryFJ: 'Fidži',
	txtAddressCountryFI: 'Fínsko',
	txtAddressCountryFR: 'Francúzsko',
	txtAddressCountryPF: 'Francúzska Polynézia',
	txtAddressCountryGA: 'Gabon',
	txtAddressCountryGM: 'Gambia',
	txtAddressCountryGE: 'Gruzínsko',
	txtAddressCountryDE: 'Nemecko',
	txtAddressCountryGH: 'Ghana',
	txtAddressCountryGR: 'Grécko',
	txtAddressCountryGL: 'Grónsko',
	txtAddressCountryGD: 'Grenada',
	txtAddressCountryGP: 'Guadeloupe',
	txtAddressCountryGT: 'Guatemala',
	txtAddressCountryGN: 'Guinea',
	txtAddressCountryGW: 'Guinea-Bissau',
	txtAddressCountryGY: 'Guyana',
	txtAddressCountryHT: 'Haiti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hong Kong',
	txtAddressCountryHU: 'Maďarsko',
	txtAddressCountryIS: 'Island',
	txtAddressCountryIN: 'India',
	txtAddressCountryID: 'Indonézia',
	txtAddressCountryIR: 'Irán',
	txtAddressCountryIQ: 'Irak',
	txtAddressCountryIE: 'Írsko',
	txtAddressCountryIM: 'Ostrov Man',
	txtAddressCountryIL: 'Izrael',
	txtAddressCountryIT: 'Taliansko',
	txtAddressCountryJM: 'Jamajka',
	txtAddressCountryJP: 'Japonsko',
	txtAddressCountryJO: 'Jordánsko',
	txtAddressCountryKZ: 'Kazachstan',
	txtAddressCountryKE: 'Keňa',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'Severná Kórea',
	txtAddressCountryKR: 'Južná Kórea',
	txtAddressCountryKW: 'Kuvajt',
	txtAddressCountryKG: 'Kyrgyzstan',
	txtAddressCountryLA: 'Laos',
	txtAddressCountryLV: 'Lotyšsko',
	txtAddressCountryLB: 'Libanon',
	txtAddressCountryLS: 'Lesoto',
	txtAddressCountryLR: 'Libéria',
	txtAddressCountryLY: 'Líbya',
	txtAddressCountryLI: 'Lichtenštajnsko',
	txtAddressCountryLT: 'Litva',
	txtAddressCountryLU: 'Luxembursko',
	txtAddressCountryMO: 'Macau',
	txtAddressCountryMK: 'Macedónsko',
	txtAddressCountryMG: 'Madagaskar',
	txtAddressCountryMW: 'Malawi',
	txtAddressCountryMY: 'Malajzia',
	txtAddressCountryMV: 'Maledivy',
	txtAddressCountryML: 'Mali',
	txtAddressCountryMT: 'Malta',
	txtAddressCountryMH: 'Marshallove ostrovy',
	txtAddressCountryMQ: 'Martinik',
	txtAddressCountryMR: 'Mauretánia',
	txtAddressCountryMU: 'Maurícius',
	txtAddressCountryMX: 'Mexiko',
	txtAddressCountryFM: 'Mikronézia',
	txtAddressCountryMD: 'Moldavsko',
	txtAddressCountryMC: 'Monako',
	txtAddressCountryMN: 'Mongolsko',
	txtAddressCountryME: 'Čierna hora',
	txtAddressCountryMA: 'Maroko',
	txtAddressCountryMZ: 'Mozambik',
	txtAddressCountryMM: 'Mjanmarsko',
	txtAddressCountryNA: 'Namíbia',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Nepál',
	txtAddressCountryNL: 'Holandsko',
	txtAddressCountryNC: 'Nová Kaledónia',
	txtAddressCountryNZ: 'Nový Zéland',
	txtAddressCountryNI: 'Nikaragua',
	txtAddressCountryNE: 'Niger',
	txtAddressCountryNG: 'Nigéria',
	txtAddressCountryNO: 'Nórsko',
	txtAddressCountryOM: 'Omán',
	txtAddressCountryPK: 'Pakistan',
	txtAddressCountryPW: 'Palau',
	txtAddressCountryPS: 'Palestínske územia',
	txtAddressCountryPA: 'Panama',
	txtAddressCountryPG: 'Papua-Nová Guinea',
	txtAddressCountryPY: 'Paraguaj',
	txtAddressCountryPE: 'Peru',
	txtAddressCountryPH: 'Filipíny',
	txtAddressCountryPL: 'Poľsko',
	txtAddressCountryPT: 'Portugalsko',
	txtAddressCountryPR: 'Portoriko',
	txtAddressCountryQA: 'Katar',
	txtAddressCountryRE: 'Réunion',
	txtAddressCountryRO: 'Rumunsko',
	txtAddressCountryRU: 'Rusko',
	txtAddressCountryRW: 'Rwanda',
	txtAddressCountryBL: 'Sv. Bartolomej',
	txtAddressCountrySH: 'Sv. Helena',
	txtAddressCountryKN: 'Svätý Krištof and Nevis',
	txtAddressCountryLC: 'Sv. Lucia',
	txtAddressCountryMF: 'Sv. Martin',
	txtAddressCountryVC: 'Sv. Vincent a Grenadíny',
	txtAddressCountryWS: 'Samoa',
	txtAddressCountrySM: 'San Maríno',
	txtAddressCountryST: 'Sao Tome a Principe',
	txtAddressCountrySA: 'Saudská Arábia',
	txtAddressCountrySN: 'Senegal',
	txtAddressCountryRS: 'Srbsko',
	txtAddressCountrySC: 'Seychely',
	txtAddressCountrySL: 'Siera Leone',
	txtAddressCountrySG: 'Singapur',
	txtAddressCountrySK: 'Slovensko',
	txtAddressCountrySI: 'Slovinsko',
	txtAddressCountrySB: 'Šalamúnove ostrovy',
	txtAddressCountrySO: 'Somálsko',
	txtAddressCountryZA: 'Južná Afrika',
	txtAddressCountryGS: 'Južná Georgia a južné Sandwichove ostrovy',
	txtAddressCountryES: 'Španielsko',
	txtAddressCountryLK: 'Srí Lanka',
	txtAddressCountrySD: 'Sudán',
	txtAddressCountrySR: 'Surinam',
	txtAddressCountrySZ: 'Swahilsko',
	txtAddressCountrySE: 'Švédsko',
	txtAddressCountryCH: 'Švajčiarsko',
	txtAddressCountrySY: 'Sýria',
	txtAddressCountryTW: 'Taiwan',
	txtAddressCountryTJ: 'Tadžikistan',
	txtAddressCountryTZ: 'Tanzánia',
	txtAddressCountryTH: 'Thajsko',
	txtAddressCountryTL: 'Timor-Leste',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga',
	txtAddressCountryTT: 'Trinidad a Tobago',
	txtAddressCountryTN: 'Tunisko',
	txtAddressCountryTR: 'Turecko',
	txtAddressCountryTM: 'Turkmenistan',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'Americké panenské ostrovy',
	txtAddressCountryUG: 'Uganda',
	txtAddressCountryUA: 'Ukrajina',
	txtAddressCountryAE: 'Spojené arabské emiráty',
	txtAddressCountryGB: 'Spojené kráľovstvo',
	txtAddressCountryUS: 'Spojené štáty americké',
	txtAddressCountryUY: 'Uruguaj',
	txtAddressCountryUZ: 'Uzbekistan',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Vatikán',
	txtAddressCountryVE: 'Venezuela',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Jemen',
	txtAddressCountryZM: 'Zambia',
	txtAddressCountryZW: 'Zimbabwe',

	/* data_process.js */
	addCategory: 'Pridať kategóriu',

	/* addressbook.js */
	contactConcurrentChange: 'Kontakt bol zmenený na serveri a opätovne načítaný!',
	contactRfcNotCompliant: 'Chyba: tento kontakt (vCard) nie je v súlade so štandardom RFC 2426!',

	/* interface.js */
	loadingAddressbooks: 'Načítavanie adresárov (%act% z %total%) ...',

	/* webdav_protocol.js */
	succContactSaved: 'Kontakt úspešne uložený!',
	succContactDeleted: 'Kontakt úspešne vymazaný!',
	succContactDeletedFromGroup: 'Kontakt úspešne vymazaný z aktívnej skupiny kontaktov!',
	errUnableLockBegin: 'Chyba: \'nepodarilo sa zamknúť prostriedok\': %%!',
	errUnableUnlockBegin: 'Chyba: \'nepodarilo sa odomknúť prostriedok\': %%!',
	errUnableSaveBegin: 'Chyba: \'nepodarilo sa uložiť kontakt\': %%!',
	errUnableSaveInvalidData: 'Chyba: \'nemožno uložiť\': opravte zvýraznené neplatné hodnoty!',
	errUnableDeleteBegin: 'Chyba: \'nepodarilo sa vymazať kontakt\': %%!',
	errResourceLocked: 'prostriedok je práve zamknutý',
	errHttp410: 'kontakt už nie je dostupný na serveri'
}

localizationCardDAV['tr_TR']=	/* thanks Selcuk Pultar */
{
	/* index.html */
	altAddContact: 'İrtibat Ekle',
	altPhoto: 'Resim',
	txtAddressbook: 'Adres Rehberi',
	txtCompanies: 'Şirketler',
	txtContact: 'İrtibat',
	pholderGiven: 'Adı',
	pholderFamily: 'Soyadı',
	pholderMiddle: 'Göbekadı',
	pholderNickname: 'Takma adı',
	pholderPhGiven: 'Fonetik Adı',
	pholderPhFamily: 'Fonetik Soyadı',
	pholderPrefix: 'Önek',
	pholderSuffix: 'Sonek',
	pholderBday: 'Doğum Günü',
	pholderAnniversary: 'Yıldönümü',
	pholderTitle: 'Ünvanı',
	pholderOrg: 'Şirketi',
	pholderDepartment: 'Bölümü',
	txtCompanyContact: 'Şirket İrtibatı',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» özel',
	pholderCustomVal: 'özel',

	txtPhone: 'Telefon',
	txtPhoneWork: 'iş',
	txtPhoneHome: 'ev',
	txtPhoneCell: 'cep',
	txtPhoneCellWork: 'iş cep',
	txtPhoneCellHome: 'ev cep',
	txtPhoneMain: 'merkez',
	txtPhonePager: 'çağrı cihazı',
	txtPhoneFax: 'faks',
	txtPhoneFaxWork: 'iş faks',
	txtPhoneFaxHome: 'ev faks',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'diğer',
	pholderPhoneVal: 'Telefon',

	txtEmail: 'Eposta',
	txtEmailWork: 'iş',
	txtEmailHome: 'ev',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'diğer',
	pholderEmailVal: 'Eposta',

	txtUrl: 'URL',
	txtUrlWork: 'is',
	txtUrlHome: 'ev',
	txtUrlHomepage: 'anasayfa',
	txtUrlOther: 'diğer',
	pholderUrlVal: 'URL',

	txtRelated: 'İlişkili',
	txtRelatedFather: 'baba',
	txtRelatedMother: 'anne',
	txtRelatedParent: 'ebeveyin',
	txtRelatedBrother: 'ağabey',
	txtRelatedSister: 'abla',
	txtRelatedChild: 'çocuk',
	txtRelatedFriend: 'arkadaş',
	txtRelatedSpouse: 'eş',
	txtRelatedPartner: 'ortağı',
	txtRelatedAssistant: 'asistanı',
	txtRelatedManager: 'yöneticisi',
	txtRelatedOther: 'diğer',
	pholderRelatedVal: 'Adı',

	txtIm: 'IM',
	txtImWork: 'iş',
	txtImHome: 'ev',
	txtImMobileme: 'mobileMe',
	txtImOther: 'diğer',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'Kullanıcı Adı',

	txtProfile: 'Profil',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'KulllanıcıAdı',

	txtAddress: 'Adres',
	txtAddressWork: 'iş',
	txtAddressHome: 'ev',
	txtAddressOther: 'diğer',
	// address fields are handled specially

	txtCategories: 'Kategoriler',
	// categories' values are handled specially

	pholderNoteVal: 'Not Metni',

	buttonCancel: 'Vazgeç',
	buttonDeleteFromGroup: 'Gruptan sil',

	/* common.js - address field names */
	pholderAddressCity: 'Şehir',
	pholderAddressCityRegion: 'Şehir/Bölge',
	pholderAddressCounty: 'Kaza',
	pholderAddressCountyCity: 'Kaza/Şehir',
	pholderAddressDepartment: 'Bölüm',
	pholderAddressDistrict: 'Bölge',
	pholderAddressDistrictSubdivision: 'Bölge/Altbölüm',
	pholderAddressFurtherDivisions: 'İlave Altbölüm',
	pholderAddressGovernorate: 'Vilayet',
	pholderAddressIslandName: 'Ada İsmi',
	pholderAddressPinCode: 'PIN Kodu',
	pholderAddressPostCode: 'Posta Kodu',
	pholderAddressPostal: 'Posta',
	pholderAddressPostalCode: 'Posta Kodu',
	pholderAddressPostalDistrict: 'Posta Bölgesi',
	pholderAddressPrefecture: 'Vilayet',
	pholderAddressProvince: 'Vilayet',
	pholderAddressRegion: 'Bölge',
	pholderAddressState: 'Eyalet',
	pholderAddressStreet: 'Sokak',
	pholderAddressSuburb: 'Banliyö',
	pholderAddressTownshipDistrict: 'İlçe/Bölge',
	pholderAddressZip: 'Posta Kodu',

	txtAddressCountryAF: 'Afganistan',
	txtAddressCountryAL: 'Arnavutluk',
	txtAddressCountryDZ: 'Cezayir',
	txtAddressCountryAD: 'Andorra',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua ve Barbuda',
	txtAddressCountryAR: 'Arjantin',
	txtAddressCountryAM: 'Ermenistan',
	txtAddressCountryAU: 'Avusturalya',
	txtAddressCountryAT: 'Avusturya',
	txtAddressCountryAZ: 'Azerbaycan',
	txtAddressCountryBS: 'Bahamalar',
	txtAddressCountryBH: 'Bahreyn',
	txtAddressCountryBD: 'Bangladeş',
	txtAddressCountryBB: 'Barbados',
	txtAddressCountryBY: 'Beyaz Rusya',
	txtAddressCountryBE: 'Belçika',
	txtAddressCountryBZ: 'Beliz',
	txtAddressCountryBJ: 'Benin',
	txtAddressCountryBM: 'Bermuda',
	txtAddressCountryBT: 'Bhutan',
	txtAddressCountryBO: 'Bolivya',
	txtAddressCountryBA: 'Bosna and Hersek',
	txtAddressCountryBW: 'Botsvana',
	txtAddressCountryBR: 'Brezilya',
	txtAddressCountryBN: 'Bruney Darüsselam',
	txtAddressCountryBG: 'Bulgaristan',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Kamboçya',
	txtAddressCountryCM: 'Kamerun',
	txtAddressCountryCA: 'Kanada',
	txtAddressCountryCV: 'Kap Verde',
	txtAddressCountryKY: 'Kayman Adaları',
	txtAddressCountryCF: 'Orta Afrika Cumhuriyeti',
	txtAddressCountryTD: 'Çad',
	txtAddressCountryCL: 'Şili',
	txtAddressCountryCN: 'Çin',
	txtAddressCountryCO: 'kolombiya',
	txtAddressCountryKM: 'Comoros',
	txtAddressCountryCD: 'Congo Demokratik Cumhuriyeti',
	txtAddressCountryCG: 'Congo Cumhuriyeti',
	txtAddressCountryCR: 'Kosta Rika',
	txtAddressCountryCI: 'Fildişi Sahili',
	txtAddressCountryHR: 'Hırvatistan',
	txtAddressCountryCU: 'Küba',
	txtAddressCountryCY: 'Kıbrıs',
	txtAddressCountryCZ: 'Çek Cumhuriyeti',
	txtAddressCountryDK: 'Danimarka',
	txtAddressCountryDJ: 'Djibouti',
	txtAddressCountryDM: 'Dominica',
	txtAddressCountryDO: 'Dominik Cumhuriyeti',
	txtAddressCountryEC: 'Ekvator',
	txtAddressCountryEG: 'Mısır',
	txtAddressCountrySV: 'El Salvador',
	txtAddressCountryGQ: 'Ekvatoryal Guinea',
	txtAddressCountryER: 'Eritrea',
	txtAddressCountryEE: 'Estonya',
	txtAddressCountryET: 'Etiyopya',
	txtAddressCountryFK: 'Falkland Adaları',
	txtAddressCountryFO: 'Faroe Adaları',
	txtAddressCountryFJ: 'Fiji',
	txtAddressCountryFI: 'Finlandiya',
	txtAddressCountryFR: 'Fransa',
	txtAddressCountryPF: 'Fransız Polinezyası',
	txtAddressCountryGA: 'Gabon',
	txtAddressCountryGM: 'Gambiya',
	txtAddressCountryGE: 'Gürcistan',
	txtAddressCountryDE: 'Almanya',
	txtAddressCountryGH: 'Ghana',
	txtAddressCountryGR: 'Yunanistan',
	txtAddressCountryGL: 'Grönland',
	txtAddressCountryGD: 'Grenada',
	txtAddressCountryGP: 'Guadeloupe',
	txtAddressCountryGT: 'Guatemala',
	txtAddressCountryGN: 'Gine',
	txtAddressCountryGW: 'Guinea-Bissau',
	txtAddressCountryGY: 'Guyana',
	txtAddressCountryHT: 'Haiti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hong Kong',
	txtAddressCountryHU: 'Macaristan',
	txtAddressCountryIS: 'İzlanda',
	txtAddressCountryIN: 'Hindistan',
	txtAddressCountryID: 'Endonezya',
	txtAddressCountryIR: 'İran',
	txtAddressCountryIQ: 'Irak',
	txtAddressCountryIE: 'Irlanda',
	txtAddressCountryIM: 'Man Adası',
	txtAddressCountryIL: 'Israil',
	txtAddressCountryIT: 'Italya',
	txtAddressCountryJM: 'Jamaica',
	txtAddressCountryJP: 'Japonya',
	txtAddressCountryJO: 'Ürdün',
	txtAddressCountryKZ: 'Kazakistan',
	txtAddressCountryKE: 'Kenya',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'Kuzey Kore',
	txtAddressCountryKR: 'Güney Kore',
	txtAddressCountryKW: 'Kuveyt',
	txtAddressCountryKG: 'Kırgızistan',
	txtAddressCountryLA: 'Laos',
	txtAddressCountryLV: 'Latviya',
	txtAddressCountryLB: 'Lübnan',
	txtAddressCountryLS: 'Lesotho',
	txtAddressCountryLR: 'Liberia',
	txtAddressCountryLY: 'Libya',
	txtAddressCountryLI: 'Liechtenstein',
	txtAddressCountryLT: 'Litvanya',
	txtAddressCountryLU: 'Lüksemburg',
	txtAddressCountryMO: 'Makau',
	txtAddressCountryMK: 'Makedonya',
	txtAddressCountryMG: 'Madagaskar',
	txtAddressCountryMW: 'Malavi',
	txtAddressCountryMY: 'Malezya',
	txtAddressCountryMV: 'Maldiveler',
	txtAddressCountryML: 'Mali',
	txtAddressCountryMT: 'Malta',
	txtAddressCountryMH: 'Marshall Adaları',
	txtAddressCountryMQ: 'Martinik',
	txtAddressCountryMR: 'Mauritanya',
	txtAddressCountryMU: 'Maurityus',
	txtAddressCountryMX: 'Meksika',
	txtAddressCountryFM: 'Micronesya',
	txtAddressCountryMD: 'Moldovya',
	txtAddressCountryMC: 'Monako',
	txtAddressCountryMN: 'Moğolistan',
	txtAddressCountryME: 'Karadağ',
	txtAddressCountryMA: 'Fas',
	txtAddressCountryMZ: 'Mozambik',
	txtAddressCountryMM: 'Myanmar',
	txtAddressCountryNA: 'Namibya',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Nepal',
	txtAddressCountryNL: 'Hollanda',
	txtAddressCountryNC: 'Yeni Kaledonya',
	txtAddressCountryNZ: 'Yeni Zellanda',
	txtAddressCountryNI: 'Nikaragua',
	txtAddressCountryNE: 'Niger',
	txtAddressCountryNG: 'Nijerya',
	txtAddressCountryNO: 'Norveç',
	txtAddressCountryOM: 'Oman',
	txtAddressCountryPK: 'Pakistan',
	txtAddressCountryPW: 'Palau',
	txtAddressCountryPS: 'Filistin',
	txtAddressCountryPA: 'Panama',
	txtAddressCountryPG: 'Papua Yeni Gine',
	txtAddressCountryPY: 'Paraguay',
	txtAddressCountryPE: 'Peru',
	txtAddressCountryPH: 'Filipinler',
	txtAddressCountryPL: 'Polonya',
	txtAddressCountryPT: 'Portekiz',
	txtAddressCountryPR: 'Porto Rico',
	txtAddressCountryQA: 'Katar',
	txtAddressCountryRE: 'Réunion',
	txtAddressCountryRO: 'Romanya',
	txtAddressCountryRU: 'Rusya',
	txtAddressCountryRW: 'Ruvanda',
	txtAddressCountryBL: 'Aziz Barthélemy',
	txtAddressCountrySH: 'Aziz Helena',
	txtAddressCountryKN: 'Aziz Kitts ve Nevis',
	txtAddressCountryLC: 'Aziz Lusya',
	txtAddressCountryMF: 'Aziz Martin',
	txtAddressCountryVC: 'Aziz Vincent ve Grenadinler',
	txtAddressCountryWS: 'Samoa',
	txtAddressCountrySM: 'San Marino',
	txtAddressCountryST: 'Sao Tome ve Principe',
	txtAddressCountrySA: 'Sudi Arabistan',
	txtAddressCountrySN: 'Senegal',
	txtAddressCountryRS: 'Sırbistan',
	txtAddressCountrySC: 'Seyşeller',
	txtAddressCountrySL: 'Sierra Leon',
	txtAddressCountrySG: 'Singapur',
	txtAddressCountrySK: 'Slovak Cumhuriyeti',
	txtAddressCountrySI: 'Slovenya',
	txtAddressCountrySB: 'Solomon Adaları',
	txtAddressCountrySO: 'Somalya',
	txtAddressCountryZA: 'Güney Africa',
	txtAddressCountryGS: 'Güney Georgia and Güney Sandwich Adaları',
	txtAddressCountryES: 'İspanya',
	txtAddressCountryLK: 'Sri Lanka',
	txtAddressCountrySD: 'Sudan',
	txtAddressCountrySR: 'Surinam',
	txtAddressCountrySZ: 'Swaziland',
	txtAddressCountrySE: 'İşveç',
	txtAddressCountryCH: 'İşviçre',
	txtAddressCountrySY: 'Suriye',
	txtAddressCountryTW: 'Tayvan',
	txtAddressCountryTJ: 'Tacikistan',
	txtAddressCountryTZ: 'Tanzanya',
	txtAddressCountryTH: 'Thayland',
	txtAddressCountryTL: 'Timor-Leste',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga',
	txtAddressCountryTT: 'Trinidad ve Tobago',
	txtAddressCountryTN: 'Tunus',
	txtAddressCountryTR: 'Türkiye',
	txtAddressCountryTM: 'Türkmenistan',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'ABD Virgin Adaları',
	txtAddressCountryUG: 'Uganda',
	txtAddressCountryUA: 'Ukrayna',
	txtAddressCountryAE: 'Birleşik Arap Emirlikleri',
	txtAddressCountryGB: 'Birleşik Krallık',
	txtAddressCountryUS: 'Amerika Birleşik Devletleri',
	txtAddressCountryUY: 'Uruguay',
	txtAddressCountryUZ: 'Özbekistan',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Vatikan',
	txtAddressCountryVE: 'Venezuella',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Yemen',
	txtAddressCountryZM: 'Zambiya',
	txtAddressCountryZW: 'Zimbabve',

	/* data_process.js */
	addCategory: 'Kategori Ekle',

	/* addressbook.js */
	contactConcurrentChange: 'Sunucudaki irtibat değiştirilmiş ve yeniden yüklenmiş!',
	contactRfcNotCompliant: 'Hata: bu irtibat (vCard) RFC 2426 ile uyumlu değil!',

	/* interface.js */
	loadingAddressbooks: 'Adres rehberleri yükleniyor (%total% taneden %act%) ...',

	/* webdav_protocol.js */
	succContactSaved: 'İrtibat başarıyla kaydedildi!',
	succContactDeleted: 'İrtibat başarıyla silindi!',
	succContactDeletedFromGroup: 'İrtibat aktif irtibat grubundan başarıyla silindi!',
	errUnableLockBegin: 'Hata: \'kaynak kilitlenemiyor\': %%!',
	errUnableUnlockBegin: 'Hata: \'kaynağın kilidi açılamıyor\': %%!',
	errUnableSaveBegin: 'Hata: \'irtibat kaydedilemiyor\': %%!',
	errUnableSaveInvalidData: 'Hata: \'kaydedilemiyor\': renklendirilmiş yanlış değerleri düzeltin!',
	errUnableDeleteBegin: 'Hata: \'irtibat silinemiyor\': %%!',
	errResourceLocked: 'kaynak zaten kilitli',
	errHttp410: 'irtibat artık sunucuda mevcut değil'
}

// Merge localization objects
$.extend(true, localization, localizationCardDAV);
