/*
CalDavZAP - the open source CalDAV Web Client
Copyright (C) 2011-2013
    Jan Mate <jan.mate@inf-it.com>
    Andrej Lezo <andrej.lezo@inf-it.com>
    Matej Mihalik <matej.mihalik@inf-it.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// NOTE: console.log(...) messages are not translated
var localization = new Object();

localization['cs_CZ']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_name_: 'Čeština',
	_default_datepicker_format_: 'dd.mm.yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Odhlásit',
	buttonLogin: 'Přihlásit',
	pholderUsername: 'Přihlašovací jméno',
	pholderPassword: 'Heslo',
	txtResources: 'Prostředky',
	txtSearch: 'Hledat',
	txtNote: 'Poznámky',

	buttonEdit: 'Editovat',
	buttonSave: 'Uložit',
	buttonDelete: 'Vymazat',

	unsupportedBrowser: 'Upozornění: Váš prohlížeč je nepodporovaný!',

	errUnableSync: 'Chyba: \'nepodařilo se synchronizovat prostředek\': zkuste to později!',
	errHttpCommon: 'chybový kód %%',
	errHttp401: 'neautorizovaný',
	errHttp403: 'přístup zamítnut',
	errHttp405: 'nepovolená metoda',
	errHttp408: 'vypršení doby požadavku',
	errHttp412: 'někdo jiný ho právě změnil na serveru',
	errHttp500: 'vnitřní chyba serveru',
	errHttp501: 'neimplementováno',

	loadingResources: 'Načítaní prostředků (%act% z %total%) ...',
	updateNotification: '%name% %new_ver% dostupný (používáte %curr_ver%) - %url%'
}

localization['da_DK']=	/* thanks Niels Bo Andersen */
{
	_name_: 'Dansk',
	_default_datepicker_format_: 'dd-mm-yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Log ud',
	buttonLogin: 'Log ind',
	pholderUsername: 'Brugernavn',
	pholderPassword: 'Kodeord',
	txtResources: 'Ressourcer',
	txtSearch: 'Søg',
	txtNote: 'Note',

	buttonEdit: 'Rediger',
	buttonSave: 'Gem',
	buttonDelete: 'Slet',

	unsupportedBrowser: 'Bemærk: Din browser er ikke understøttet!',

	errUnableSync: 'Fejl: \'kunne ikke synkronisere ressource\': prøv igen senere!',
	errHttpCommon: 'fejlkode %%',
	errHttp401: 'uautoriseret',
	errHttp403: 'forbudt',
	errHttp405: 'metode ikke tilladt',
	errHttp408: 'forespørgsels-timeout',
	errHttp412: 'emnet er ændret af en anden på serveren',
	errHttp500: 'intern serverfejl',
	errHttp501: 'ikke implementeret',

	loadingResources: 'Henter ressourcer (%act% af %total%) ...',
	updateNotification: '%name% %new_ver% er frigivet (du har %curr_ver%) - %url%'
}

localization['de_DE']=	/* thanks Marten Gajda and Thomas Scheel */
{
	_name_: 'Deutsch',
	_default_datepicker_format_: 'dd.mm.yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Abmelden',
	buttonLogin: 'Anmelden',
	pholderUsername: 'Benutzername',
	pholderPassword: 'Passwort',
	txtResources: 'Ressourcen',
	txtSearch: 'Suchen',
	txtNote: 'Notiz',

	buttonEdit: 'Bearbeiten',
	buttonSave: 'Speichern',
	buttonDelete: 'Löschen',

	unsupportedBrowser: 'Hinweis: Der verwendete Browser wird nicht unterstützt!',

	errUnableSync: 'Fehler: \'Ressource konnte nicht syncronisiert werden\': Versuchen Sie es später noch einmal!',
	errHttpCommon: 'Fehler Code %%',
	errHttp401: 'nicht berechtigt',
	errHttp403: 'verboten',
	errHttp405: 'Befehl nicht erlaubt',
	errHttp408: 'Anfrage-Timeout',
	errHttp412: 'Kontakt wurde zwischenzeitlich auf der Server geändert',
	errHttp500: 'Interner Server Fehler',
	errHttp501: 'Nicht unterstützt',

	loadingResources: 'Lade Ressourcen (%act% von %total%) ...',
	updateNotification: '%name% %new_ver% verfügbar (Sie haben %curr_ver%) - %url%'
}

localization['en_US']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_name_: 'English',
	_default_datepicker_format_: 'yy-mm-dd',
	_default_AMPM_format_: true,

	altLogo: 'Logo',
	altLogout: 'Logout',
	buttonLogin: 'Login',
	pholderUsername: 'Username',
	pholderPassword: 'Password',
	txtResources: 'Resources',
	txtSearch: 'Search',
	txtNote: 'Note',

	buttonEdit: 'Edit',
	buttonSave: 'Save',
	buttonDelete: 'Delete',

	unsupportedBrowser: 'Note: your browser is unsupported!',

	errUnableSync: 'Error: \'unable to sync resource\': try again later!',
	errHttpCommon: 'error code %%',
	errHttp401: 'unauthorized',
	errHttp403: 'forbidden',
	errHttp405: 'method not allowed',
	errHttp408: 'request timeout',
	errHttp412: 'somebody else has already changed it on the server',
	errHttp500: 'internal server error',
	errHttp501: 'not implemented',

	loadingResources: 'Loading resources (%act% of %total%) ...',
	updateNotification: '%name% %new_ver% available (you have %curr_ver%) - %url%'
}

localization['fr_FR']=	/* thanks John Fischer */
{
	_name_: 'Français',
	_default_datepicker_format_: 'dd-mm-yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Déconnexion',
	buttonLogin: 'Connexion',
	pholderUsername: 'Identifiant',
	pholderPassword: 'Mot de Passe',
	txtResources: 'Resources',
	txtSearch: 'Rechercher',
	txtNote: 'Note',

	buttonEdit: 'Editer',
	buttonSave: 'Sauvegarder',
	buttonDelete: 'Supprimer',

	unsupportedBrowser: 'Note: votre navigateur n`est pas supporté!',

	errUnableSync: 'Erreur: \'impossible de synchroniser la ressource\': essayer à nouveau plutard!',
	errHttpCommon: 'code d\'erreur %%',
	errHttp401: 'non autorisé',
	errHttp403: 'interdit',
	errHttp405: 'methode non autorisé',
	errHttp408: 'request timeout',
	errHttp412: 'quelqu\'un d\'autre a la déjà modifié sur le serveur',
	errHttp500: 'erreur interne du serveur',
	errHttp501: 'non implémenté',

	loadingResources: 'Chargement des ressources (%act% sur %total%)...',
	updateNotification: '%name% %new_ver% est disponible (vous ètes actuellement en version %curr_ver%) - %url%'
}

localization['hu_HU']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_name_: 'Magyar',
	_default_datepicker_format_: 'yy.mm.dd',
	_default_AMPM_format_: false,

	altLogo: 'Logó',
	altLogout: 'Kijelentkezés',
	buttonLogin: 'Bejelentkezés',
	pholderUsername: 'Felhasználónév',
	pholderPassword: 'Jelszó',
	txtResources: 'Források',
	txtSearch: 'Keresés',
	txtNote: 'Jegyzetek',

	buttonEdit: 'Szerkesztés',
	buttonSave: 'Mentés',
	buttonDelete: 'Törlés',

	unsupportedBrowser: 'Figyelmeztetés: A böngészője nem támogatott!',

	errUnableSync: 'Hiba: \'nem sikerült a forrás szinkronizálása\': próbálkozzon később!',
	errHttpCommon: 'hiba kód %%',
	errHttp401: 'nincs hitelesítve',
	errHttp403: 'tiltva',
	errHttp405: 'nem engedélyezett módszer',
	errHttp408: 'kérelem időtúllépése',
	errHttp412: 'valaki más már megváltoztatta a szerveren',
	errHttp500: 'belső szerverhiba',
	errHttp501: 'nincs megvalósítva',

	loadingResources: 'Források betöltése (%act%/%total%) ...',
	updateNotification: '%name% %new_ver% elérhető (jelenlegi verzió: %curr_ver%) - %url%'
}

localization['it_IT']=	/* thanks Luca Ferrario */
{
	_name_: 'Italiano',
	_default_datepicker_format_: 'dd/mm/yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Logout',
	buttonLogin: 'Login',
	pholderUsername: 'Nome Utente',
	pholderPassword: 'Password',
	txtResources: 'Risorse',
	txtSearch: 'Cerca',
	txtNote: 'Note',

	buttonEdit: 'Modifica',
	buttonSave: 'Salva',
	buttonDelete: 'Elimina',

	unsupportedBrowser: 'Attenzione: browser non supportato!',

	errUnableSync: 'Errore: \'impossibile sincronizzare la risorsa\': riprovare!',
	errHttpCommon: 'codice errore %%',
	errHttp401: 'non autorizzato',
	errHttp403: 'proibito',
	errHttp405: 'metodo non consentito',
	errHttp408: 'timeout della richiesta',
	errHttp412: 'qualcun altro l\'ha già modificato sul server',
	errHttp500: 'errore interno del server',
	errHttp501: 'non implementato',

	loadingResources: 'Caricamento risorse (%act% di %total%) ...',
	updateNotification: '%name% %new_ver% disponibile (versione attuale: %curr_ver%) - %url%'
}

localization['nl_NL']=	/* thanks Johan Vromans */
{
	_name_: 'Nederlands',
	_default_datepicker_format_: 'dd-mm-yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Uitloggen',
	buttonLogin: 'Inloggen',
	pholderUsername: 'Gebruikersnaam',
	pholderPassword: 'Wachtwoord',
	txtResources: 'Bronnen',
	txtSearch: 'Zoeken',
	txtNote: 'Opmerking',

	buttonEdit: 'Wijzigen',
	buttonSave: 'Opslaan',
	buttonDelete: 'Verwijderen',

	unsupportedBrowser: 'Attentie: uw browser wordt niet ondersteund!',

	errUnableSync: 'Fout: Synchronisatie mislukt, probeer later nog eens!',
	errHttpCommon: 'Foutcode %%',
	errHttp401: 'geen toegang',
	errHttp403: 'verboden',
	errHttp405: 'bewerking niet toegestaan',
	errHttp408: 'verwerking afgebroken wegens timeout',
	errHttp412: 'iemand anders heeft dit reeds gewijzigd op de server',
	errHttp500: 'interne serverfout',
	errHttp501: 'niet geïmplementeerd',

	loadingResources: 'Laden (%act% van %total%) ...',
	updateNotification: 'Er is een nieuwe versie van %name% beschikbaar: %new_ver% (u heeft nu %curr_ver%) - %url%'
}

localization['sk_SK']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_name_: 'Slovenčina',
	_default_datepicker_format_: 'dd.mm.yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Odhlásiť',
	buttonLogin: 'Prihlásiť',
	pholderUsername: 'Prihlasovacie meno',
	pholderPassword: 'Heslo',
	txtResources: 'Prostriedky',
	txtSearch: 'Vyhľadať',
	txtNote: 'Poznámky',

	buttonEdit: 'Editovať',
	buttonSave: 'Uložiť',
	buttonDelete: 'Vymazať',

	unsupportedBrowser: 'Upozornenie: Váš prehliadač je nepodporovaný!',

	errUnableSync: 'Chyba: \'nepodarilo sa synchronizovať prostriedok\': skúste to neskôr!',
	errHttpCommon: 'chybový kód %%',
	errHttp401: 'neautorizovaný',
	errHttp403: 'prístup zamietnutý',
	errHttp405: 'nepovolená metóda',
	errHttp408: 'časový limit vypršal',
	errHttp412: 'niekto iný ho práve zmenil na serveri',
	errHttp500: 'vnútorná chyba servera',
	errHttp501: 'neimplementované',

	loadingResources: 'Načítavanie prostriedkov (%act% z %total%) ...',
	updateNotification: '%name% %new_ver% dostupný (používate %curr_ver%) - %url%'
}

localization['tr_TR']=	/* thanks Selcuk Pultar */
{
	_name_: 'Türkçe',
	_default_datepicker_format_: 'dd-mm-yy',
	_default_AMPM_format_: true,

	altLogo: 'Logo',
	altLogout: 'Çıkış',
	buttonLogin: 'Giriş',
	pholderUsername: 'Kullanıcı Adı',
	pholderPassword: 'Parola',
	txtResources: 'Kaynaklar',
	txtSearch: 'Ara',
	txtNote: 'Not',

	buttonEdit: 'Düzenle',
	buttonSave: 'Kaydet',
	buttonDelete: 'Sil',

	unsupportedBrowser: 'Not: tarayıcınız desteklenmemektedir!',

	errUnableSync: 'Hata: \'kaynak eşlenememiştir\': sonra yeniden deneyin!',
	errHttpCommon: 'hata kodu %%',
	errHttp401: 'yetkisiz',
	errHttp403: 'yasak',
	errHttp405: 'metoda izin verilmemiştir',
	errHttp408: 'istek zaman aşımı',
	errHttp412: 'başkası sunucuda zaten değiştirmiş',
	errHttp500: 'dahili sunucu hatası',
	errHttp501: 'henüz uygulamaya geçirilmemiştir',

	loadingResources: 'Kaynaklar yükleniyor (%total% taneden %act%) ...',
	updateNotification: '%name% %new_ver% hazır (sizde %curr_ver% var) - %url%'
}

var localizationCalDAV=new Object();

localizationCalDAV['cs_CZ']=
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'&#8212;\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',
	_default_time_format_list_: 'd.M.yyyy',

	txtCalendar: 'Kalendář',
	txtCalendars: 'Kalendáře',
	txtTodo: 'Připomínky',
	txtTodoLists: 'Seznam připomínek',
	txtSubscribed: 'Odběry', 
	fullCalendarMonth: 'měsíc',
	fullCalendarMultiWeek: 'mtýden',
	fullCalendarAgendaWeek: 'týden',
	fullCalendarAgendaDay: 'den',
	fullCalendarTable: 'tabulka',
	fullCalendarTodayButton: 'dnes',
	fullCalendarAllDay: 'celej den',
	CalDAVsearch: 'Hledat',
	resourceEnable: 'Zobrazit všechnyy kalendáře v daném prostředku',
	resourceDisable: 'Schovat všechny kalendáře v daném prostředku',
	allEnable: 'Zobrazit všechny kalendáře',
	allDisable: 'Schovat všechny kalendáře',
	timezone: 'Časové pásmo',
	txtTimezonePicker: 'Pásmo:',
	loadingRList: 'Načítaní zoznamu prostředků ...',
	renderingE: 'Vykreslování kalendářů ...',
	timezoneChange: 'Aplikování změny časového pásma ...',
	localTime: 'Lokální čas',
	customTimezone: 'Vlastní (Lokální čas)',
	loadPrevMonth: 'Načíst předchádzející měsíc',
	loadNextMonth: 'Načíst následující měsíc',
	repeatBoxHead: 'Možnosti opakovací události',
	repeatBoxContent: 'je opakovací událost.',
	repeatBoxQuestion: 'Se kterými událostmi chcete pracovat?',
	allEvsButton: 'Všechny události',
	allFutureButton: 'Tahle a všechny budoucí události',
	eventOnlyButton: 'Pouze tahle událost',
	repeatBoxContentTODO: 'je opakovací připomínka.',
	repeatBoxQuestionTODO: 'Se kterými připomínkami chcete pracovat?',
	allEvsButtonTODO: 'Všechny připomínky',
	allFutureButtonTODO: 'Tahle a všechny budoucí připomínky',
	eventOnlyButtonTODO: 'Pouze tahle připomínka',
	txtStatus: 'Stav',
	eventAvailability : 'Dostupnost',
	eventAvailabilityBusy : 'Zaneprázdněnej',
	eventAvailabilityFree : 'Volnej',
	eventType: 'Soukromí',
	eventTypePublic: 'Veřejná',
	eventTypePrivate: 'Soukromá',
	eventTypeConfidential: 'Důvěrní',
	txtPriority: 'Priorita',
	txtPriorityNone: 'Žádná',
	txtPriorityLow: 'Nízká',
	txtPriorityMedium: 'Střední',
	txtPriorityHigh: 'Vysoká',
	eventURL : 'URL',
	repeatInterval: 'každých',
	repeatDays: 'dnů',
	repeatWeeks: 'týdnů',
	repeatMonths: 'měsíců',
	repeatYears: 'let',
	repeatChangeTxt: 'byl změnen na serveru!',
	repeatChangeTxtClose: 'Zavřete formulář a otevřte událost znovu',
	repeatTodoChangeTxtClose: 'Zavřete formulář a otevřte připomínku znovu.',
	calendarLoader: 'Znovunačítání ...',
	resizeLoader: 'Přepočítávání velikosti ...',

	monthNames: ['Leden','Únor','Březen','Duben','Květen','Červen',
	'Červenec','Srpen','Září','Říjen','Listopad','Prosinec'],
	monthNamesShort: ['Led','Úno','Bře','Dub','Kvě','Čer',
	'Čvc','Srp','Zář','Říj','Lis','Pro'],
	dayNames: ['Neděle', 'Pondělí', 'Úterý', 'Středa', 'Čtvrtek', 'Pátek', 'Sobota'],
	dayNamesShort: ['Ne', 'Po', 'Út', 'St', 'Čt', 'Pá', 'So'],
	dayNamesMin: ['Ne','Po','Út','St','Čt','Pá','So'],

	// TODOS
	pholderNameTODO: 'Název',
	pholderNewTODO: 'Nová připomínka',
	txtTypeTODO: 'Typ',
	txtTypeTODONone: 'Jednoduchá',
	txtTypeTODOStart: 'S časem začátku',
	txtTypeTODODue: 'S časem konce',
	txtTypeTODOBoth: 'S časmi začátku i konce',
	txtDateFromTODO: 'Od',
	txtDateToTODO: 'Do',
	txtCompletedOn: 'Dokončeno ke',

	pholderDateFromTODO: 'Den od',
	pholderTimeFromTODO: 'Čas od',
	pholderDateToTODO: 'Den do',
	pholderTimeToTODO: 'Čas do',
	pholderCompletedOnDate: 'Den',
	pholderCompletedOnTime: 'Čas',

	txtStatusNeedsActionTODO: 'Potřebuje akci',
	txtStatusCompletedTODO: 'Dokončena',
	txtStatusInProcessTODO: 'Řešená',
	txtStatusCancelledTODO: 'Zrušena',
	txtPercentCompletedTODO: 'Dokončeno',

	txtCalendarTODO: 'Kalendář',
	txtSelectCalendarTODO: 'Vyberte kalendář',
	txtAlertTODO: 'Alarm',
	txtAlertNoneTODO: 'Žádný',
	txtAlertMessageTODO: 'Správa',
	txtAlertOnDateTODO: 'Na datum',
	txtAlertWeeksBeforeTODO: 'Týdnů před',
	txtAlertDaysBeforeTODO: 'Dnů před',
	txtAlertHoursBeforeTODO: 'Hodin před',
	txtAlertMinutesBeforeTODO: 'Minut před',
	txtAlertSecondsBeforeTODO: 'Sekund před',
	txtAlertWeeksAfterTODO: 'Týdnů po',
	txtAlertDaysAfterTODO: 'Dnů po',
	txtAlertHoursAfterTODO: 'Sekund po',
	txtAlertMinutesAfterTODO: 'Minut po',
	txtAlertSecondsAfterTODO: 'Sekund po',

	pholderAfterBeforeValTODO: 'Hodnota',
	pholderAlarmDateTODO: 'Den alarmu',
	pholderAlarmTimeTODO: 'Čas alarmu',

	pholderNoteTODO: 'Poznámka',
	txtNoteTODO: 'Poznámka',

	todoPrevNav: 'Zobrazit předešlou instanci',
	todoNextNav: 'Zobrazit následující instanci',
	todoUncompletedPrevNav: 'Zobrazit předešlou nedokončenou instanci',
	todoUncompletedNextNav: 'Zobrazit následující nedokončenou instanci',

	buttonSaveTODO: 'Uložit',
	buttonEditTODO: 'Editovat',
	buttonResetTODO: 'Reset',
	buttonCloseTODO: 'Zavřít',
	buttonDeleteTODO: 'Vymazat',

	// EVENTS
	pholderName: 'Název',
	pholderNewEvent: 'Nová událost',
	txtLocation: 'Místo',
	pholderLocation: 'Místo',

	txtAllDay: 'Celý den',
	from: 'Od',
	to: 'Do',

	pholderDateFrom: 'Den od',
	pholderTimeFrom: 'Čas od',
	pholderDateTo: 'Den do',
	pholderTimeTo: 'Čas do',

	txtStatusNone: 'Nespecifikován',
	txtStatusTentative: 'Předběžná',
	txtStatusConfirmed: 'Potvrzena',
	txtStatusCancelled: 'Zrušena',

	txtRepeat: 'Opakovat',
	txtNoRepeat: 'Neopakovat',
	txtRepeatDay: 'Denně',
	txtRepeatWeek: 'Týdenně',
	txtRepeatWeekend: 'Každý víkend',
	txtRepeatMonth: 'Měsíčně',
	txtRepeatTwoWeek: 'Dvoutýdenně',
	txtRepeatYear: 'Ročně',
	txtRepeatCustomWeek: 'Týdenně vlastní',
	txtRepeatCustomMonth: 'Měsíčně vlastní',
	txtRepeatCustomYear: 'Ročně vlastní',
	txtRepeatWork: 'Každý pracovný den',
	txtRepeatOnDate: 'Do dátumu',
	txtRepeatAfter: 'Výskytů',
	txtRepeatNever: 'Nikdy',
	pholderUntilDate: 'Do dne',
	pholderRepeatCount: 'Počet opakování',
	txtRepeatCustomWeekLabel: 'den',
	txtRepeatCustomMonthLabel: 've dnech',
	txtRepeatCustomMonthEvery: 'Každý',
	txtRepeatCustomMonthFirst: 'První',
	txtRepeatCustomMonthSecond: 'Druhej',
	txtRepeatCustomMonthThird: 'Třetí',
	txtRepeatCustomMonthFourth: 'Čtvrtý',
	txtRepeatCustomMonthFifth: 'Pátý',
	txtRepeatCustomMonthLast: 'Poslední',
	txtRepeatCustomMonthCustom: 'Vlastní',
	txtRepeatCustomMonthMonth: 'Den v měsíci',
	txtRepeatCustomYearLabel1: 'každý',
	txtRepeatCustomYearLabel2: 'v měsíci',

	txtrepeatEnd: 'konec',
	txtEventCalendar: 'Kalendář',
	txtSelectCalendar: 'Vyberte kalendář',
	txtAlert: 'Alarm',
	txtAlertNone: 'Žádný',
	txtAlertMessage: 'Správa',
	txtAlertOnDate: 'Na datum',
	txtAlertWeeksBefore: 'Týdnů před',
	txtAlertDaysBefore: 'Dnů před',
	txtAlertHoursBefore: 'Hodin před',
	txtAlertMinutesBefore: 'Minut před',
	txtAlertSecondsBefore: 'Sekund před',
	txtAlertWeeksAfter: 'Týdnů po',
	txtAlertDaysAfter: 'Dnů po',
	txtAlertHoursAfter: 'Sekund po',
	txtAlertMinutesAfter: 'Minut po',
	txtAlertSecondsAfter: 'Sekund po',

	pholderAfterBeforeVal: 'Hodnota',
	pholderAlarmDate: 'Den alarmu',
	pholderAlarmTime: 'Čas alarmu',

	pholderNote: 'Poznámka',

	eventPrevNav: 'Zobrazit předešlou instanci',
	eventNextNav: 'Zobrazit následující instanci',

	buttonReset: 'Reset',
	buttonClose: 'Zavřít',

	txtAllSavedTodo: 'Připomínka úspěšně uložena!',
	txtAllSaved: 'Událost úspěšně uložena!',

	txtAllDeletedTodo: 'Připomínka úspěšně vymazána!',
	txtAllDeleted: 'Událost úspěšně vymazána!',

	txtNotChooseTodo: 'Chyba: Musíte zvolit kalendář!',
	txtNotChoose: 'Chyba: Musíte zvolit kalendář!',

	txtErorInputTodo: 'Chyba: opravte chybné hodnoty!',
	txtDateTimeErrorTodo: 'Chyba: Musíte zvolit den a čas!',

	txtErrorDates: 'Chyba: Čas začátku musí být před koncem!',
	txtErrorDatesTodo: 'Chyba: Čas začátku musí být před koncem!',

	txtErorInput: 'Chyba: opravte vyznačené chybné hodnoty!',

	txtAlertsH: 'Alarmy',
	buttonAlert: 'Smazat alarmy',

	altAddEvent: 'Přidat událost',
	altAddTodo: 'Přidat připomínku',

	loadingCalendars: 'Načítavání kalendářů (%act% z %total%) ...',

	errUnableSaveBeginCalDAV: 'Chyba: \'nepodařilo sa uložit událost\': %%!',
	errUnableDeleteBeginCalDAV: 'Chyba: \'nepodařilo sa vymazat událost\': %%!',
	CalDAVerrHttp410: 'Událost již není dostupná na serveru',
	errUnableSaveTodoBeginCalDAV: 'Chyba: \'nepodařilo sa uložit připomínku \': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Chyba: \'nepodařilo sa vymazat připomínku\': %%!',
	CalDAVerrTodoHttp410: 'Připomínka již není dostupná na serveru'
}

localizationCalDAV['da_DK']=
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'&#8212;\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',
	_default_time_format_list_: 'd-M-yyyy',

	txtCalendar: 'Kalender',
	txtCalendars: 'Kalendere',
	txtTodo: 'Opgave',
	txtTodoLists: 'Opgaveliste',
	txtSubscribed: 'Abonnementer',
	fullCalendarMonth: 'måned',
	fullCalendarMultiWeek: 'uger',
	fullCalendarAgendaWeek: 'uge',
	fullCalendarAgendaDay: 'dag',
	fullCalendarTable: 'tabel',
	fullCalendarTodayButton: 'i dag',
	fullCalendarAllDay: 'hele dagen',
	CalDAVsearch: 'Søg',
	resourceEnable: 'Aktiver alle kalendere i denne ressource',
	resourceDisable: 'Deaktiver alle kalendere i denne ressource',
	allEnable: 'Aktiver alle kalendere',
	allDisable: 'Deaktiver alle kalendere',
	timezone: 'Tidszone',
	txtTimezonePicker: 'Tidszone:',
	loadingRList: 'Henter ressourceliste ...',
	renderingE: 'Klargør kalendere ...',
	timezoneChange: 'Udfører tidszoneskift ...',
	localTime: 'Lokal tid',
	customTimezone: 'Brugerdefineret (Lokal tid)',
	loadPrevMonth: 'Hent forrige måned',
	loadNextMonth: 'Hent næste måned',
	repeatBoxHead: 'Indstillinger for gentaget begivenhed',
	repeatBoxContent: 'er en gentaget begivenhed.',
	repeatBoxQuestion: 'Hvilke forekomster vil du åbne?',
	allEvsButton: 'Alle forekomster',
	allFutureButton: 'Denne og alle fremtidige forekomster',
	eventOnlyButton: 'Kun denne forekomst',
	repeatBoxContentTODO: 'er en tilbagevendende todo.',	
	repeatBoxQuestionTODO: 'Hvilke todos vil du arbejde med',	
	allEvsButtonTODO: 'Alle todos',
	allFutureButtonTODO: 'Denne og alle fremtidige todos',
	eventOnlyButtonTODO: 'Kun denne todo',
	txtStatus: 'Status',	
	eventAvailability : 'Vis som',
	eventAvailabilityBusy : 'Optaget',
	eventAvailabilityFree : 'Ledig',
	eventType: 'Fortrolighed',
	eventTypePublic: 'Offentlig',
	eventTypePrivate: 'Privat',
	eventTypeConfidential: 'Fortrolig',
	txtPriority: 'Prioritet',
	txtPriorityNone: 'Ingen',
	txtPriorityLow: 'Lav',
	txtPriorityMedium: 'Mellem',
	txtPriorityHigh: 'Høj',
	eventURL : 'URL',
	repeatInterval: 'Hver',
	repeatDays: 'dag(e)',
	repeatWeeks: 'uge(r)',
	repeatMonths: 'måned(er)',
	repeatYears: 'år',
	repeatChangeTxt: 'blev ændret på serveren!',
	repeatChangeTxtClose: 'Luk formularen og åbn begivenheden igen',
	repeatTodoChangeTxtClose: 'Close the form and open the todo again',
	calendarLoader: 'Genindlæser ...',
	resizeLoader: 'Tilpasser størrelse ...',

	monthNames: ['Januar','Februar','Marts','April','Maj','Juni',
	'Juli','August','September','Oktober','November','December'],
	monthNamesShort: ['Jan', 'Feb', 'Mar', 'Apr', 'Maj', 'Jun',
	'Jul', 'Aug', 'Sep', 'Okt', 'Nov', 'Dec'],
	dayNames: ['Søndag', 'Mandag', 'Tirsdag', 'Onsdag', 'Torsdag', 'Fredag', 'Lørdag'],
	dayNamesShort: ['Søn', 'Man', 'Tir', 'Ons', 'Tor', 'Fre', 'Lør'],
	dayNamesMin: ['Sø','Ma','Ti','On','To','Fr','Lø'],

	// TODOS
	pholderNameTODO: 'Emne',
	pholderNewTODO: 'Ny opgave',
	txtTypeTODO: 'Type',
	txtTypeTODONone: 'Simpel',
	txtTypeTODOStart: 'Med startdato',
	txtTypeTODODue: 'Med forfaldsdato',
	txtTypeTODOBoth: 'Med både startdato og forfaldsdato',
	txtDateFromTODO: 'Fra',
	txtDateToTODO: 'Til',
	txtCompletedOn: 'Færdiggjort den',

	pholderDateFromTODO: 'Fra dato',
	pholderTimeFromTODO: 'Fra kl.',
	pholderDateToTODO: 'Til dato',
	pholderTimeToTODO: 'Til kl.',
	pholderCompletedOnDate: 'Dato',
	pholderCompletedOnTime: 'Time',

	txtStatusNeedsActionTODO: 'Kræver opfølgning',
	txtStatusCompletedTODO: 'Fuldført',
	txtStatusInProcessTODO: 'Under udførelse',
	txtStatusCancelledTODO: 'Annulleret',
	txtPercentCompletedTODO: 'Fuldført',

	txtCalendarTODO: 'Kalender',
	txtSelectCalendarTODO: 'Vælg kalender',
	txtAlertTODO: 'Påmindelse',
	txtAlertNoneTODO: 'None',
	txtAlertMessageTODO: 'Besked',
	txtAlertOnDateTODO: 'På dagen',
	txtAlertWeeksBeforeTODO: 'Uger før',
	txtAlertDaysBeforeTODO: 'Dage før',
	txtAlertHoursBeforeTODO: 'Timer før',
	txtAlertMinutesBeforeTODO: 'Minutter før',
	txtAlertSecondsBeforeTODO: 'Sekunder før',
	txtAlertWeeksAfterTODO: 'Uger efter',
	txtAlertDaysAfterTODO: 'Dage efter',
	txtAlertHoursAfterTODO: 'Timer efter',
	txtAlertMinutesAfterTODO: 'Minutter efter',
	txtAlertSecondsAfterTODO: 'Sekunder efter',

	pholderAfterBeforeValTODO: 'Værdi',
	pholderAlarmDateTODO: 'Alarmdato',
	pholderAlarmTimeTODO: 'Alarmtid',

	pholderNoteTODO: 'Note',
	txtNoteTODO: 'Note',

	todoPrevNav: 'Vis forrige',
	todoNextNav: 'VisShow næste',
	todoUncompletedPrevNav: 'Vis forrige uafsluttede',
	todoUncompletedNextNav: 'Vis næste uafsluttede',

	buttonSaveTODO: 'Gem',
	buttonEditTODO: 'Rediger',
	buttonResetTODO: 'Fortryd',
	buttonCloseTODO: 'Luk',
	buttonDeleteTODO: 'Slet',

	// EVENTS
	pholderName: 'Emne',
	pholderNewEvent: 'Ny begivenhed',
	txtLocation: 'Sted',
	pholderLocation: 'Sted',

	txtAllDay: 'Hele dagen',
	from: 'Fra',
	to: 'Til',

	pholderDateFrom: 'Fra dato',
	pholderTimeFrom: 'Fra kl.',
	pholderDateTo: 'Til dato',
	pholderTimeTo: 'Til kl.',

	txtStatusNone: 'Uspecifiseret',
	txtStatusTentative: 'Usikker',
	txtStatusConfirmed: 'Bekræftet',
	txtStatusCancelled: 'Annulleret',

	txtRepeat: 'Gentagelse',
	txtNoRepeat: 'Ingen gentagelse',
	txtRepeatDay: 'Dagligt',
	txtRepeatWeek: 'Ugentligt',
	txtRepeatWeekend: 'Hver weekend',
	txtRepeatMonth: 'Månedligt',
	txtRepeatTwoWeek: 'Hver anden uge',
	txtRepeatYear: 'Årligt',
	txtRepeatCustomWeek: 'Ugentligt (avanceret)',
	txtRepeatCustomMonth: 'Månedligt (avanceret)',
	txtRepeatCustomYear: 'Årligt (avanceret)',
	txtRepeatWork: 'På arbejdsdage',
	txtRepeatOnDate: 'På dato',
	txtRepeatAfter: 'Forekomster',
	txtRepeatNever: 'Aldrig',
	pholderUntilDate: 'Indtil dato',
	pholderRepeatCount: 'Antal gentagelser',
	txtRepeatCustomWeekLabel: 'På',
	txtRepeatCustomMonthLabel: 'På dage',
	txtRepeatCustomMonthEvery: 'Hver',
	txtRepeatCustomMonthFirst: 'Første',
	txtRepeatCustomMonthSecond: 'Anden',
	txtRepeatCustomMonthThird: 'Tredie',
	txtRepeatCustomMonthFourth: 'Fjerde',
	txtRepeatCustomMonthFifth: 'Femte',
	txtRepeatCustomMonthLast: 'Sidste',
	txtRepeatCustomMonthCustom: 'Valgfri',
	txtRepeatCustomMonthMonth: 'Dag i måneden',
	txtRepeatCustomYearLabel1: 'Hver',
	txtRepeatCustomYearLabel2: 'i',

	txtrepeatEnd: 'Slut',
	txtEventCalendar: 'Kalender',
	txtSelectCalendar: 'Vælg kalender',
	txtAlert: 'Påmindelse',
	txtAlertNone: 'Ingen',
	txtAlertMessage: 'Besked',
	txtAlertOnDate: 'På dato',
	txtAlertWeeksBefore: 'Uger før',
	txtAlertDaysBefore: 'Dage før',
	txtAlertHoursBefore: 'Timer før',
	txtAlertMinutesBefore: 'Minutter før',
	txtAlertSecondsBefore: 'Sekunder før',
	txtAlertWeeksAfter: 'Uger efter',
	txtAlertDaysAfter: 'Dage efter',
	txtAlertHoursAfter: 'Timer efter',
	txtAlertMinutesAfter: 'Minutter efter',
	txtAlertSecondsAfter: 'Sekunder efter',

	pholderAfterBeforeVal: 'Værdi',
	pholderAlarmDate: 'Alarmdato',
	pholderAlarmTime: 'Alarmtid',

	pholderNote: 'Note',

	eventPrevNav: 'Vis forrige',
	eventNextNav: 'Vis næste',

	buttonReset: 'Fortryd',
	buttonClose: 'Luk',

	txtAllSavedTodo: 'Opgave gemt!',
	txtAllSaved: 'Begivenhed gemt!',

	txtAllDeletedTodo: 'Opgave slettet!',
	txtAllDeleted: 'Begivenhed slettet!',

	txtNotChooseTodo: 'Fejl: Vælg en kalender!',
	txtNotChoose: 'Fejl: Vælg en kalender!',

	txtErrorDates: 'Fejl: Startdatoen skal komme før slutdatoen!',
	txtErrorDatesTodo: 'Fejl: Startdatoen skal komme før forfaldsdatoen!',

	txtErorInputTodo: 'Kunne ikke gemme: ret de ugyldige værdier!',
	txtDateTimeErrorTodo: 'Der skal vælges dato og tid!',

	txtErorInput: 'Fejl: \'kunne ikke gemme\': ret de markerede ugyldige værdier!',

	txtAlertsH: 'Påmindelser',
	buttonAlert: 'Fjern påmindelser',

	altAddEvent: 'Tilføj begivenhed',
	altAddTodo: 'Tilføj opgave',

	loadingCalendars: 'Loading calendars (%act% of %total%) ...',

	errUnableSaveBeginCalDAV: 'Fejl: \'kunne ikke gemme begivenheden\': %%!',
	errUnableDeleteBeginCalDAV: 'Fejl: \'kunne ikke slette begivenheden\': %%!',
	CalDAVerrHttp410: 'Begivenheden er ikke længere tilgængelig på serveren',
	errUnableSaveTodoBeginCalDAV: 'Fejl: \'Kunne ikke gemme todo\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Fejl: \'Kunne ikke slette todo\': %%!',
	CalDAVerrTodoHttp410: 'Todo findes ikke længere på serveren'
}

localizationCalDAV['de_DE']=
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'&#8212;\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',
	_default_time_format_list_: 'd.M.yyyy',

	txtCalendar: 'Kalender',
	txtCalendars: 'Kalender',
	txtTodo: 'Aufgabe',
	txtTodoLists: 'Aufgaben',
	txtSubscribed: 'Abonnements',
	fullCalendarMonth: 'Monat',
	fullCalendarMultiWeek: 'Wochen',
	fullCalendarAgendaWeek: 'Woche',
	fullCalendarAgendaDay: 'Tag',
	fullCalendarTable: 'Liste', /* is this an Agenda? */
	fullCalendarTodayButton: 'Heute',
	fullCalendarAllDay: 'ganztägig',
	CalDAVsearch: 'Suchen',
	resourceEnable: 'Aktiviere alle Kalender in dieser Ressource',
	resourceDisable: 'Deaktiviere alle Kalender in dieser Ressource',
	allEnable: 'Aktiviere alle Kalender',
	allDisable: 'Deaktiviere alle Kalender',
	timezone: 'Zeitzone',
	txtTimezonePicker: 'Zeitzone:',
	loadingRList: 'Lade Ressourcenliste ...',
	renderingE: 'Bereite Ansicht vor ...',
	timezoneChange: 'Anwenden der Zeitzonenänderung ...',
	localTime: 'Lokale Zeit',
	customTimezone: 'Unbekannt (lokale Zeit)',
	loadPrevMonth: 'Zeige vorherigen Monat',
	loadNextMonth: 'Zeige nächsten Monat',
	repeatBoxHead: 'Serienterminoptionen',
	repeatBoxContent: 'ist ein Serientermin.',
	repeatBoxQuestion: 'Welche Termine sollen bearbeitet werden?',
	allEvsButton: 'Alle Termine',
	allFutureButton: 'Dieser und alle zukünftigen Termine',
	eventOnlyButton: 'Nur diesen Termin',
	repeatBoxContentTODO: 'ist eine Serienaufgabe.',
	repeatBoxQuestionTODO: 'Welche Aufgaben möchten Sie bearbeiten?',
	allEvsButtonTODO: 'Alle Aufgaben',
	allFutureButtonTODO: 'Diese und alle zukünftigen Aufgaben',
	eventOnlyButtonTODO: 'Nur diese Aufgabe',
	txtStatus: 'Status',	// X
	eventAvailability : 'Verfügbarkeit',
	eventAvailabilityBusy : 'beschäftigt',
	eventAvailabilityFree : 'verfügbar',
	eventType: 'Privatsphäre',
	eventTypePublic: 'öffentlich',
	eventTypePrivate: 'privat',
	eventTypeConfidential: 'vertraulich',
	txtPriority: 'Priorität',
	txtPriorityNone: 'Ohne',
	txtPriorityLow: 'Niedrig',
	txtPriorityMedium: 'Mittel',
	txtPriorityHigh: 'Hoch',
	eventURL : 'URL',
	repeatInterval: 'Alle',
	repeatDays: 'Tage',
	repeatWeeks: 'Wochen',
	repeatMonths: 'Monate',
	repeatYears: 'Jahre',
	repeatChangeTxt: 'wurde auf dem Server geändert!',
	repeatChangeTxtClose: 'Fenster schließen und Termin erneut öffnen',
	repeatTodoChangeTxtClose: 'Fenster schließen und Aufgabe erneut öffnen',
	calendarLoader: 'Lade ...',
	resizeLoader: 'Größe anpassen ...',

	monthNames: ['Januar','Februar','März','April','Mai','Juni',
	'Juli','August','September','Oktober','November','Dezember'],
	monthNamesShort: ['Jan','Feb','Mär','Apr','Mai','Jun',
	'Jul','Aug','Sep','Okt','Nov','Dez'],
	dayNames: ['Sonntag','Montag','Dienstag','Mittwoch','Donnerstag','Freitag','Samstag'],
	dayNamesShort: ['So','Mo','Di','Mi','Do','Fr','Sa'],
	dayNamesMin: ['So','Mo','Di','Mi','Do','Fr','Sa'],

	// TODOS
	pholderNameTODO: 'Titel',
	pholderNewTODO: 'Neue Aufgabe',
	txtTypeTODO: 'Aufgabentyp',
	txtTypeTODONone: 'einfach',
	txtTypeTODOStart: 'mit Startzeit',
	txtTypeTODODue: 'mit Fälligkeit',
	txtTypeTODOBoth: 'mit Startzeit und Fälligkeit',
	txtDateFromTODO: 'Von',
	txtDateToTODO: 'Bis',
	txtCompletedOn: 'Fertiggestellt',

	pholderDateFromTODO: 'Startdatum',
	pholderTimeFromTODO: 'Startzeit',
	pholderDateToTODO: 'Enddatum',
	pholderTimeToTODO: 'Endzeit',
	pholderCompletedOnDate: 'Datum',
	pholderCompletedOnTime: 'Zeit',

	txtStatusNeedsActionTODO: 'offen', /* Lightning translates it to 'Benötigt Eingriff' */
	txtStatusCompletedTODO: 'erledigt',
	txtStatusInProcessTODO: 'in Bearbeitung',
	txtStatusCancelledTODO: 'abgebrochen',
	txtPercentCompletedTODO: 'erledigt',

	txtCalendarTODO: 'Kalender',
	txtSelectCalendarTODO: 'Kalender auswählen',
	txtAlertTODO: 'Alarm',
	txtAlertNoneTODO: 'ohne',
	txtAlertMessageTODO: 'Benachrichtigung',
	txtAlertOnDateTODO: 'am',
	txtAlertWeeksBeforeTODO: 'Wochen vorher',
	txtAlertDaysBeforeTODO: 'Tage vorher',
	txtAlertHoursBeforeTODO: 'Stunden vorher',
	txtAlertMinutesBeforeTODO: 'Minuten vorher',
	txtAlertSecondsBeforeTODO: 'Sekunden vorher',
	txtAlertWeeksAfterTODO: 'Wochen danach',
	txtAlertDaysAfterTODO: 'Tage danach',
	txtAlertHoursAfterTODO: 'Stunden danach',
	txtAlertMinutesAfterTODO: 'Minuten danach',
	txtAlertSecondsAfterTODO: 'Sekunden danach',

	pholderAfterBeforeValTODO: 'Wert', /* is this used anywhere */
	pholderAlarmDateTODO: 'Alarmdatum',
	pholderAlarmTimeTODO: 'Alarmzeit',

	pholderNoteTODO: 'Notiz',
	txtNoteTODO: 'Notiz',

	todoPrevNav: 'Zeige vorherige Instanz',
	todoNextNav: 'Zeige nächste Instanz',
	todoUncompletedPrevNav: 'Zeige vorherige unerledigte Instanz',
	todoUncompletedNextNav: 'Zeige nächste unerledigte Instanz',

	buttonSaveTODO: 'Speichern',
	buttonEditTODO: 'Bearbeiten',
	buttonResetTODO: 'Verwerfen',
	buttonCloseTODO: 'Schließen',
	buttonDeleteTODO: 'Löschen',

	// EVENTS
	pholderName: 'Titel',
	pholderNewEvent: 'Neuer Termin',
	txtLocation: 'Ort',
	pholderLocation: 'Ort',

	txtAllDay: 'ganztägig',
	from: 'von',
	to: 'bis',

	pholderDateFrom: 'Startdatum',
	pholderTimeFrom: 'Startzeit',
	pholderDateTo: 'Enddatum',
	pholderTimeTo: 'Endzeit',

	txtStatusNone: 'Unspecified',	// X
	txtStatusTentative: 'Tentative',	// X
	txtStatusConfirmed: 'Confirmed',	// X
	txtStatusCancelled: 'Cancelled',	// X

	txtRepeat: 'Wiederholung',
	txtNoRepeat: 'ohne',
	txtRepeatDay: 'täglich',
	txtRepeatWeek: 'wöchentlich',
	txtRepeatWeekend: 'jedes Wochenende',
	txtRepeatMonth: 'monatlich',
	txtRepeatTwoWeek: '14-tägig',
	txtRepeatYear: 'jährlich',
	txtRepeatCustomWeek: 'wöchentlich (benutzerdefiniert)',
	txtRepeatCustomMonth: 'monatlich (benutzerdefiniert)',
	txtRepeatCustomYear: 'jährlich (benutzerdefiniert)',
	txtRepeatWork: 'werktags',
	txtRepeatOnDate: 'am',
	txtRepeatAfter: 'Wiederholungen',
	txtRepeatNever: 'nie',
	pholderUntilDate: 'bis Datum',
	pholderRepeatCount: 'Wiederholungen',
	txtRepeatCustomWeekLabel: 'am',
	txtRepeatCustomMonthLabel: 'an Tagen',
	txtRepeatCustomMonthEvery: 'jeden',
	txtRepeatCustomMonthFirst: 'ersten',
	txtRepeatCustomMonthSecond: 'zweiten',
	txtRepeatCustomMonthThird: 'dritten',
	txtRepeatCustomMonthFourth: 'vierten',
	txtRepeatCustomMonthFifth: 'fünften',
	txtRepeatCustomMonthLast: 'letzten',
	txtRepeatCustomMonthCustom: 'benutzerdefiniert',
	txtRepeatCustomMonthMonth: 'Tag des Monats',
	txtRepeatCustomYearLabel1: 'jeden',
	txtRepeatCustomYearLabel2: 'von',

	txtrepeatEnd: 'Ende',
	txtEventCalendar: 'Kalender',
	txtSelectCalendar: 'Kalender auswählen',
	txtAlert: 'Alarm',
	txtAlertNone: 'ohne',
	txtAlertMessage: 'Benachrichtigung',
	txtAlertOnDate: 'am',
	txtAlertWeeksBefore: 'Wochen vorher',
	txtAlertDaysBefore: 'Tage vorher',
	txtAlertHoursBefore: 'Stunden vorher',
	txtAlertMinutesBefore: 'Minuten vorher',
	txtAlertSecondsBefore: 'Sekunden vorher',
	txtAlertWeeksAfter: 'Wochen danach',
	txtAlertDaysAfter: 'Tage danach',
	txtAlertHoursAfter: 'Stunden danach',
	txtAlertMinutesAfter: 'Minuten danach',
	txtAlertSecondsAfter: 'Sekunden danach',

	pholderAfterBeforeVal: 'Wert',
	pholderAlarmDate: 'Alarmdatum',
	pholderAlarmTime: 'Alarmzeit',

	pholderNote: 'Notiz',

	eventPrevNav: 'Zeige vorherige Instanz',
	eventNextNav: 'Zeige nächste Instanz',

	buttonReset: 'Verwerfen',
	buttonClose: 'Schließen',

	txtAllSavedTodo: 'Aufgabe erfolgreich gespeichert!',
	txtAllSaved: 'Termin erfolgreich gespeichert!',

	txtAllDeletedTodo: 'Aufgabe erfolgreich gelöscht!',
	txtAllDeleted: 'Termin erfolgreich gelöscht!',

	txtNotChooseTodo: 'Fehler: Kalender auswählen!',
	txtNotChoose: 'Fehler: Kalender auswählen!',

	txtErrorDates: 'Fehler: Startdatum muss vor dem Enddatum liegen!',
	txtErrorDatesTodo: 'Fehler: Startdatum muss vor dem Enddatum liegen!',

	txtErorInputTodo: 'Fehler beim Speichern: fehlerhafte Werte korrigieren!',
	txtDateTimeErrorTodo: 'Datum und Uhrzeit wählen!',

	txtErorInput: 'Fehler: \'Speichern nicht möglich\': Hervorgehobenen Werte korrigieren!',

	txtAlertsH: 'Alarme',
	buttonAlert: 'Lösche Alarme',

	altAddEvent: 'Termin hinzufügen',
	altAddTodo: 'Aufgabe hinzufügen',

	loadingCalendars: 'Lade Kalender (%act% von %total%) ...',

	errUnableSaveBeginCalDAV: 'Fehler: \'Termin konnte nicht gespeichert werden\': %%!',
	errUnableDeleteBeginCalDAV: 'Fehler: \'Termin konnte nicht gelöscht werden\': %%!',
	CalDAVerrHttp410: 'Der Termin existiert auf dem Server nicht mehr.',
	errUnableSaveTodoBeginCalDAV: 'Fehler: \'Aufgabe konnte nicht gespeichert werden\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Fehler: \'Aufgabe konnte nicht gelöscht werden\': %%!',
	CalDAVerrTodoHttp410: 'Die Aufgabe existiert auf dem Server nicht mehr.'
}

localizationCalDAV['en_US']=
{
	_default_title_format_month_: 'yyyy MMM',
	_default_title_format_week_: 'yyyy MMM d{ \'&#8212;\'[ yyyy][ MMM] d}',
	_default_title_format_day_: 'yyyy MMM d, ddd',
	_default_title_format_table_: 'yyyy MMM, ddd',
	_default_column_format_agenda_: 'ddd, MMM d',
	_default_time_format_list_: 'yyyy-M-d',

	txtCalendar: 'Calendar',
	txtCalendars: 'Calendars',
	txtTodo: 'Todo',
	txtTodoLists: 'TodoLists',
	txtSubscribed: 'Subscriptions',
	fullCalendarMonth: 'month',
	fullCalendarMultiWeek: 'mweek',
	fullCalendarAgendaWeek: 'week',
	fullCalendarAgendaDay: 'day',
	fullCalendarTable: 'table',
	fullCalendarTodayButton: 'today',
	fullCalendarAllDay: 'all day',
	CalDAVsearch: 'Search',
	resourceEnable: 'Enable all calendars in this resource',
	resourceDisable: 'Disable all calendars in this resource',
	allEnable: 'Enable all calendars',
	allDisable: 'Disable all calendars',
	timezone: 'Timezone',
	txtTimezonePicker: 'Timezone:',
	loadingRList: 'Loading resource list ...',
	renderingE: 'Rendering calendars ...',
	timezoneChange: 'Applying timezone change ...',
	localTime: 'Local Time',
	customTimezone: 'Custom (Local Time)',
	loadPrevMonth: 'Load previous month',
	loadNextMonth: 'Load next month',
	repeatBoxHead: 'Repeating event options',
	repeatBoxContent: 'is a repeating event.',
	repeatBoxQuestion: 'Which events would you like to work with?',
	allEvsButton: 'All events',
	allFutureButton: 'This and all future events',
	eventOnlyButton: 'This event only',
	repeatBoxContentTODO: 'is a repeating todo.',
	repeatBoxQuestionTODO: 'Which todos would you like to work with?',
	allEvsButtonTODO: 'All todos',
	allFutureButtonTODO: 'This and all future todos',
	eventOnlyButtonTODO: 'This todo only',
	txtStatus: 'Status',
	eventAvailability : 'Availability',
	eventAvailabilityBusy : 'Busy',
	eventAvailabilityFree : 'Free',
	eventType: 'Privacy',
	eventTypePublic: 'Public',
	eventTypePrivate: 'Private',
	eventTypeConfidential: 'Confidential',
	txtPriority: 'Priority',
	txtPriorityNone: 'None',
	txtPriorityLow: 'Low',
	txtPriorityMedium: 'Medium',
	txtPriorityHigh: 'High',
	eventURL : 'URL',
	repeatInterval: 'every',
	repeatDays: 'days',
	repeatWeeks: 'weeks',
	repeatMonths: 'months',
	repeatYears: 'years',
	repeatChangeTxt: 'was changed on the server!',
	repeatChangeTxtClose: 'Close the form and open the event again',
	repeatTodoChangeTxtClose: 'Close the form and open the todo again',
	calendarLoader: 'Reloading ...',
	resizeLoader: 'Resizing ...',

	monthNames: ['January','February','March','April','May','June',
	'July','August','September','October','November','December'],
	monthNamesShort: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
	'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
	dayNames: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
	dayNamesShort: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
	dayNamesMin: ['Su','Mo','Tu','We','Th','Fr','Sa'],

	// TODOS
	pholderNameTODO: 'Name',
	pholderNewTODO: 'New Todo',
	txtTypeTODO: 'Type',
	txtTypeTODONone: 'Simple',
	txtTypeTODOStart: 'With start time',
	txtTypeTODODue: 'With due time',
	txtTypeTODOBoth: 'With both start and due times',
	txtDateFromTODO: 'From',
	txtDateToTODO: 'To',
	txtCompletedOn: 'Completed on',

	pholderDateFromTODO: 'Date from',
	pholderTimeFromTODO: 'Time from',
	pholderDateToTODO: 'Date to',
	pholderTimeToTODO: 'Time to',
	pholderCompletedOnDate: 'Date',
	pholderCompletedOnTime: 'Time',

	txtStatusNeedsActionTODO: 'Needs action',
	txtStatusCompletedTODO: 'Completed',
	txtStatusInProcessTODO: 'In progress',
	txtStatusCancelledTODO: 'Canceled',
	txtPercentCompletedTODO: 'Completed',

	txtCalendarTODO: 'Calendar',
	txtSelectCalendarTODO: 'Select a calendar',
	txtAlertTODO: 'Alert',
	txtAlertNoneTODO: 'None',
	txtAlertMessageTODO: 'Message',
	txtAlertOnDateTODO: 'On date',
	txtAlertWeeksBeforeTODO: 'Weeks before',
	txtAlertDaysBeforeTODO: 'Days before',
	txtAlertHoursBeforeTODO: 'Hours before',
	txtAlertMinutesBeforeTODO: 'Minutes before',
	txtAlertSecondsBeforeTODO: 'Seconds before',
	txtAlertWeeksAfterTODO: 'Weeks after',
	txtAlertDaysAfterTODO: 'Days after',
	txtAlertHoursAfterTODO: 'Hours after',
	txtAlertMinutesAfterTODO: 'Minutes after',
	txtAlertSecondsAfterTODO: 'Seconds after',

	pholderAfterBeforeValTODO: 'Value',
	pholderAlarmDateTODO: 'Alarm date',
	pholderAlarmTimeTODO: 'Alarm time',

	pholderNoteTODO: 'Note',
	txtNoteTODO: 'Note',

	todoPrevNav: 'Show previous instance',
	todoNextNav: 'Show next instance',
	todoUncompletedPrevNav: 'Show previous uncompleted instance',
	todoUncompletedNextNav: 'Show next uncompleted instance',

	buttonSaveTODO: 'Save',
	buttonEditTODO: 'Edit',
	buttonResetTODO: 'Revert',
	buttonCloseTODO: 'Close',
	buttonDeleteTODO: 'Delete',

	// EVENTS
	pholderName: 'Name',
	pholderNewEvent: 'New Event',
	txtLocation: 'Location',
	pholderLocation: 'Location',

	txtAllDay: 'All day',
	from: 'From',
	to: 'To',

	pholderDateFrom: 'Date from',
	pholderTimeFrom: 'Time from',
	pholderDateTo: 'Date to',
	pholderTimeTo: 'Time to',

	txtStatusNone: 'Unspecified',
	txtStatusTentative: 'Tentative',
	txtStatusConfirmed: 'Confirmed',
	txtStatusCancelled: 'Cancelled',

	txtRepeat: 'Repeat',
	txtNoRepeat: 'No repeat',
	txtRepeatDay: 'Daily',
	txtRepeatWeek: 'Weekly',
	txtRepeatWeekend: 'Every weekend',
	txtRepeatMonth: 'Monthly',
	txtRepeatTwoWeek: 'Bi-weekly',
	txtRepeatYear: 'Yearly',
	txtRepeatCustomWeek: 'Custom weekly',
	txtRepeatCustomMonth: 'Custom monthly',
	txtRepeatCustomYear: 'Custom yearly',
	txtRepeatWork: 'Every business day',
	txtRepeatOnDate: 'On date',
	txtRepeatAfter: 'Occurrences',
	txtRepeatNever: 'Never',
	pholderUntilDate: 'Date until',
	pholderRepeatCount: 'Repeat count',
	txtRepeatCustomWeekLabel: 'on',
	txtRepeatCustomMonthLabel: 'on days',
	txtRepeatCustomMonthEvery: 'Every',
	txtRepeatCustomMonthFirst: 'First',
	txtRepeatCustomMonthSecond: 'Second',
	txtRepeatCustomMonthThird: 'Third',
	txtRepeatCustomMonthFourth: 'Fourth',
	txtRepeatCustomMonthFifth: 'Fifth',
	txtRepeatCustomMonthLast: 'Last',
	txtRepeatCustomMonthCustom: 'Custom',
	txtRepeatCustomMonthMonth: 'Day of the month',
	txtRepeatCustomYearLabel1: 'every',
	txtRepeatCustomYearLabel2: 'of',

	txtrepeatEnd: 'end',
	txtEventCalendar: 'Calendar',
	txtSelectCalendar: 'Select a calendar',
	txtAlert: 'Alert',
	txtAlertNone: 'None',
	txtAlertMessage: 'Message',
	txtAlertOnDate: 'On date',
	txtAlertWeeksBefore: 'Weeks before',
	txtAlertDaysBefore: 'Days before',
	txtAlertHoursBefore: 'Hours before',
	txtAlertMinutesBefore: 'Minutes before',
	txtAlertSecondsBefore: 'Seconds before',
	txtAlertWeeksAfter: 'Weeks after',
	txtAlertDaysAfter: 'Days after',
	txtAlertHoursAfter: 'Hours after',
	txtAlertMinutesAfter: 'Minutes after',
	txtAlertSecondsAfter: 'Seconds after',

	pholderAfterBeforeVal: 'Value',
	pholderAlarmDate: 'Alarm date',
	pholderAlarmTime: 'Alarm time',

	pholderNote: 'Note',

	eventPrevNav: 'Show previous instance',
	eventNextNav: 'Show next instance',

	buttonReset: 'Revert',
	buttonClose: 'Close',

	txtAllSavedTodo: 'Success: Todo Saved!',
	txtAllSaved: 'Success: Event Saved!',

	txtAllDeletedTodo: 'Success: Todo Deleted!',
	txtAllDeleted: 'Success: Event Deleted!',

	txtNotChooseTodo: 'Error: Have to choose calendar!',
	txtNotChoose: 'Error: Have to choose calendar!',

	txtErrorDates: 'Error: Start date must precede the end date!',
	txtErrorDatesTodo: 'Error: Start date must precede the end date!',

	txtErorInputTodo: 'Unable to save: correct invalid values!',
	txtDateTimeErrorTodo: 'Have to choose date and time!',

	txtErorInput: 'Error: \'unable to save\': correct the highlighted invalid values!',

	txtAlertsH: 'Alerts',
	buttonAlert: 'Clear Alerts',

	altAddEvent: 'Add Event',
	altAddTodo: 'Add Todo',

	loadingCalendars: 'Loading calendars (%act% of %total%) ...',

	errUnableSaveBeginCalDAV: 'Error: \'unable to save the event\': %%!',
	errUnableDeleteBeginCalDAV: 'Error: \'unable to delete the event\': %%!',
	CalDAVerrHttp410: 'Event is no longer available at the server',
	errUnableSaveTodoBeginCalDAV: 'Error: \'unable to save the todo\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Error: \'unable to delete todo\': %%!',
	CalDAVerrTodoHttp410: 'Todo is no longer available at the server'
}

localizationCalDAV['fr_FR']=
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'&#8212;\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',
	_default_time_format_list_: 'd-M-yyyy',

	txtCalendar: 'Calendrier',
	txtCalendars: 'Calendriers',
	txtTodo: 'À faire',
	txtTodoLists: 'A Faire',
	txtSubscribed: 'Abonnements',
	fullCalendarMonth: 'mois',
	fullCalendarMultiWeek: 'multisem.',
	fullCalendarAgendaWeek: 'semaine',
	fullCalendarAgendaDay: 'jour',
	fullCalendarTable: 'tableau',
	fullCalendarTodayButton: 'aujourd\'hui',
	fullCalendarAllDay: 'Toute la journée',
	CalDAVsearch: 'Recherche',
	resourceEnable: 'Activer tous les calendriers pour cette ressource',
	resourceDisable: 'Désactiver tous les calendriers pour cette ressource',
	allEnable: 'Activer tous les calendriers',
	allDisable: 'Désactiver tous les calendriers',
	timezone: 'Fuseau horaire',
	txtTimezonePicker: 'Fuseau horaire :',
	loadingRList: 'Chargement de la liste des ressources...',
	renderingE: 'Prévisualisation des calendriers ...',
	timezoneChange: 'Changement de fuseau horaire...',
	localTime: 'Heure locale',
	customTimezone: 'Custom (Local Time)',
	loadPrevMonth: 'Charger le mois précédent',
	loadNextMonth: 'Charger le mois suivant',
	repeatBoxHead: 'Options d\'évènement récurrent',
	repeatBoxContent: 'est un évènement récurrent.',
	repeatBoxQuestion: 'Avec quel évènements voulez-vous travailler?',
	allEvsButton: 'Tous les évènements',
	allFutureButton: 'Tous les évènements à venir',
	eventOnlyButton: 'Cet évènement seulement',
	repeatBoxContentTODO: 'est une tâche récurrente.',
	repeatBoxQuestionTODO: 'Quelles tâches désirez-vous associer?',
	allEvsButtonTODO: 'Tous les tâches',
	allFutureButtonTODO: 'Tous les tâches futures à faire',
	eventOnlyButtonTODO: 'Cette tâche seulement',
	txtStatus: 'État',
	eventAvailability : 'Disponibilité',
	eventAvailabilityBusy : 'Occupé',
	eventAvailabilityFree : 'Disponible',
	eventType: 'Confidentialité',
	eventTypePublic: 'Public',
	eventTypePrivate: 'Privé',
	eventTypeConfidential: 'Confidentiel',
	txtPriority: 'Priorité',
	txtPriorityNone: 'Aucune',
	txtPriorityLow: 'Basse',
	txtPriorityMedium: 'Moyenne',
	txtPriorityHigh: 'Haute',
	eventURL : 'URL',
	repeatInterval: 'Tous les',
	repeatDays: 'jours',
	repeatWeeks: 'semaines',
	repeatMonths: 'mois',
	repeatYears: 'ans',
	repeatChangeTxt: 'a été modifié sur le serveur!',
	repeatChangeTxtClose: 'Fermer ce formulaire et rouvrir cet évènement',
	repeatTodoChangeTxtClose: 'Fermer la boîte de dialogue et ouvrer à nouveau la tâche',
	calendarLoader: 'Rechargement...',
	resizeLoader: 'Retaille...',

	monthNames: ['janvier','février','mars','avril','mai','juin',
	'juillet','août','septembre','octobre','novembre','décembre'],
	monthNamesShort: ['jan', 'fév', 'mar', 'avr', 'mai', 'jun',
	'jul', 'aoû', 'sep', 'oct', 'nov', 'déc'],
	dayNames: ['dimanche', 'lundi', 'mardi', 'mercredi', 'jeudi', 'vendredi', 'samedi'],
	dayNamesShort: ['dim', 'lun', 'mar', 'mer', 'jeu', 'ven', 'sam'],
	dayNamesMin: ['di','lu','ma','me','je','ve','sa'],

	// TODOS
	pholderNameTODO: 'Nom',
	pholderNewTODO: 'Nouvelle tâche',
	txtTypeTODO: 'Type',
	txtTypeTODONone: 'Simple',
	txtTypeTODOStart: 'Avec date de début',
	txtTypeTODODue: 'Avec date butoir',
	txtTypeTODOBoth: 'Avec des dates de début et butoir',
	txtDateFromTODO: 'De',
	txtDateToTODO: 'À',
	txtCompletedOn: 'Se termine le',

	pholderDateFromTODO: 'Date de',
	pholderTimeFromTODO: 'Heure de',
	pholderDateToTODO: 'Date à',
	pholderTimeToTODO: 'Heure à',
	pholderCompletedOnDate: 'Date',
	pholderCompletedOnTime: 'Heure',

	txtStatusNeedsActionTODO: 'En attente d\'action',
	txtStatusCompletedTODO: 'Terminée',
	txtStatusInProcessTODO: 'En cours',
	txtStatusCancelledTODO: 'Annulée',
	txtPercentCompletedTODO: 'Achevée',

	txtCalendarTODO: 'Calendrier',
	txtSelectCalendarTODO: 'Selection d\'un calendrier',
	txtAlertTODO: 'Alerte',
	txtAlertNoneTODO: 'Vide',
	txtAlertMessageTODO: 'Message',
	txtAlertOnDateTODO: 'à la date',
	txtAlertWeeksBeforeTODO: 'Semaines avant',
	txtAlertDaysBeforeTODO: 'Jours avant',
	txtAlertHoursBeforeTODO: 'Heures avant',
	txtAlertMinutesBeforeTODO: 'Minutes avant',
	txtAlertSecondsBeforeTODO: 'Secondes avant',
	txtAlertWeeksAfterTODO: 'Semaines après',
	txtAlertDaysAfterTODO: 'Jours après',
	txtAlertHoursAfterTODO: 'Heures après',
	txtAlertMinutesAfterTODO: 'Minutes après',
	txtAlertSecondsAfterTODO: 'Secondes après',

	pholderAfterBeforeValTODO: 'Valeur',
	pholderAlarmDateTODO: 'Date de l\'alarme',
	pholderAlarmTimeTODO: 'Heure de l\'alarme',

	pholderNoteTODO: 'Note',
	txtNoteTODO: 'Note',

	todoPrevNav: 'Montrer l\'instance précédente',
	todoNextNav: 'Montrer l\'instance suivante',
	todoUncompletedPrevNav: 'Montrer la précédente instance incomplète',
	todoUncompletedNextNav: 'Montrer l\'instance suivante incomplète',

	buttonSaveTODO: 'Enregistrer',
	buttonEditTODO: 'Éditer',
	buttonResetTODO: 'Revenir',
	buttonCloseTODO: 'Fermer',
	buttonDeleteTODO: 'Effacer',

	// EVENTS
	pholderName: 'Nom',
	pholderNewEvent: 'Nouvel évènement',
	txtLocation: 'Lieu',
	pholderLocation: 'Lieu',

	txtAllDay: 'Toute la journée',
	from: 'De',
	to: 'À',

	pholderDateFrom: 'Date de',
	pholderTimeFrom: 'Heure de',
	pholderDateTo: 'Date à',
	pholderTimeTo: 'Heure à',

	txtStatusNone: 'Unspecified',	// X
	txtStatusTentative: 'Tentative',	// X
	txtStatusConfirmed: 'Confirmed',	// X
	txtStatusCancelled: 'Cancelled',	// X

	txtRepeat: 'Répéter',
	txtNoRepeat: 'Ne pas répéter',
	txtRepeatDay: 'Quotidien',
	txtRepeatWeek: 'Hebdomadaire',
	txtRepeatWeekend: 'Tous les weekends',
	txtRepeatMonth: 'Mensuel',
	txtRepeatTwoWeek: 'Bi-mensuel',
	txtRepeatYear: 'Annuel',
	txtRepeatCustomWeek: 'Hebdomadaire personnalisé',
	txtRepeatCustomMonth: 'Mensuel personnalisé',
	txtRepeatCustomYear: 'Annuel personnalisé',
	txtRepeatWork: 'Tous les jours ouvrables',
	txtRepeatOnDate: 'À la date',
	txtRepeatAfter: 'Occurrences',
	txtRepeatNever: 'Jamais',
	pholderUntilDate: 'Jusqu`à la date',
	pholderRepeatCount: 'nombre de répétitions',
	txtRepeatCustomWeekLabel: 'Le',
	txtRepeatCustomMonthLabel: 'Les jours',
	txtRepeatCustomMonthEvery: 'Tous',
	txtRepeatCustomMonthFirst: 'Premier',
	txtRepeatCustomMonthSecond: 'Deuxième',
	txtRepeatCustomMonthThird: 'Troisième',
	txtRepeatCustomMonthFourth: 'Quatrième',
	txtRepeatCustomMonthFifth: 'Cinquième',
	txtRepeatCustomMonthLast: 'Dernier',
	txtRepeatCustomMonthCustom: 'Personnalisé',
	txtRepeatCustomMonthMonth: 'Jour du mois',
	txtRepeatCustomYearLabel1: 'Tous',
	txtRepeatCustomYearLabel2: 'De',

	txtrepeatEnd: 'Fin',
	txtEventCalendar: 'Calendrier',
	txtSelectCalendar: 'Selectonner un calendrier',
	txtAlert: 'Alerte',
	txtAlertNone: 'Vide',
	txtAlertMessage: 'Message',
	txtAlertOnDate: 'À la date',
	txtAlertWeeksBefore: 'Semaines avant',
	txtAlertDaysBefore: 'Jours avant',
	txtAlertHoursBefore: 'Heures avant',
	txtAlertMinutesBefore: 'Minutes avant',
	txtAlertSecondsBefore: 'Secondes avant',
	txtAlertWeeksAfter: 'Semaines après',
	txtAlertDaysAfter: 'Jours après',
	txtAlertHoursAfter: 'Heures après',
	txtAlertMinutesAfter: 'Minutes après',
	txtAlertSecondsAfter: 'Secondes après',

	pholderAfterBeforeVal: 'Valeur',
	pholderAlarmDate: 'Date de l\'alarme',
	pholderAlarmTime: 'Heure de l\'alarme',

	pholderNote: 'Note',

	eventPrevNav: 'Montrer la précédente instance',
	eventNextNav: 'Montrer l\'instance suivante',

	buttonReset: 'Revenir',
	buttonClose: 'Fermer',

	txtAllSavedTodo: 'Succès: Tâche Enregistrée !',
	txtAllSaved: 'Succès: Évènement Enregistré !',

	txtAllDeletedTodo: 'Succès: Tâche Effacée !',
	txtAllDeleted: 'Succès: Évènement Effacé !',

	txtNotChooseTodo: 'Erreur: il faut choisir un calendrier !',
	txtNotChoose: 'Erreur: il faut choisir un calendrier !',

	txtErrorDates: 'Erreur:  La date de début doit précéder la date de fin !',
	txtErrorDatesTodo: 'Erreur: La date de début doit précéder la date de fin !',

	txtErorInputTodo: 'Impossible d\'enregistrer: corriger les valeurs non valides !',
	txtDateTimeErrorTodo: 'Il faut choisir une date et une heure !',

	txtErorInput: 'Erreur: \'Impossible d\'enregistrer\': corriger les valeurs surlignées !',

	txtAlertsH: 'Alertes',
	buttonAlert: 'Vider les Alertes',

	altAddEvent: 'Ajouter un évènement',
	altAddTodo: 'Ajouter une tâche',

	loadingCalendars: 'Chargement des contacts (%act% sur %total%) ...',

	errUnableSaveBeginCalDAV: 'Erreur: \'impossible d\'enregistrer l\'évènement\': %%!',
	errUnableDeleteBeginCalDAV: 'Erreur: \'impossible d\'effacer l\'evènement\': %%!',
	CalDAVerrHttp410: 'Évènement non présent sur le serveur',
	errUnableSaveTodoBeginCalDAV: 'Erreur: \'impossible de sauvegarder la tâche\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Error: \'impossible de supprimer la tâche\': %%!',
	CalDAVerrTodoHttp410: 'La tâche n\'est plus disponible sur le serveur'
}

localizationCalDAV['hu_HU']=
{
	_default_title_format_month_: 'yyyy MMM',
	_default_title_format_week_: 'yyyy MMM d{ \'&#8212;\'[ yyyy][ MMM] d}',
	_default_title_format_day_: 'yyyy MMM d, ddd',
	_default_title_format_table_: 'yyyy MMM, ddd',
	_default_column_format_agenda_: 'ddd, MMM d',
	_default_time_format_list_: 'yyyy.M.d',

	txtCalendar: 'Naptár',
	txtCalendars: 'Naptárak',
	txtTodo: 'Feladat',
	txtTodoLists: 'FeladatListák',
	txtSubscribed: 'Előfizetések',
	fullCalendarMonth: 'hónap',
	fullCalendarMultiWeek: 'több hét',
	fullCalendarAgendaWeek: 'hét',
	fullCalendarAgendaDay: 'nap',
	fullCalendarTable: 'táblázat',
	fullCalendarTodayButton: 'ma',
	fullCalendarAllDay: 'eg. napi',
	CalDAVsearch: 'Keresés',
	resourceEnable: 'A forrás minden naptára megjelenítése',
	resourceDisable: 'A forrás minden naptára elrejtése',
	allEnable: 'Minden naptár megjelenítése',	
	allDisable: 'Minden naptár elrejtése',
	timezone: 'Időzóna',
	txtTimezonePicker: 'Időzóna:',
	loadingRList: 'Forrás lista betöltése ...',
	renderingE: 'Naptárak megjelenítése ...',
	timezoneChange: 'Időzónaváltás alkalmazása ...',
	localTime: 'Helyi idő',
	customTimezone: 'Egyéni (Helyi idő)',
	loadPrevMonth: 'Előző hónap betöltése',
	loadNextMonth: 'Következő hónap betöltése',
	repeatBoxHead: 'Ismétlődő esemény lehetőségei',
	repeatBoxContent: 'ismétlődő esemény.',
	repeatBoxQuestion: 'Melyik eseménnyel szeretne dolgozni?',
	allEvsButton: 'Minden eseménnyel',
	allFutureButton: 'Ez és az összes jövőbeli eseménnyel',
	eventOnlyButton: 'Csak ezzel az eseménnyel',
	repeatBoxContentTODO: 'ismétlődő feladat.',
	repeatBoxQuestionTODO: 'Melyik feladattal szeretne dolgozni?',
	allEvsButtonTODO: 'Minden feladattal',
	allFutureButtonTODO: 'Ez és az összes jövőbeli feladattal',
	eventOnlyButtonTODO: 'Csak ezzel a feladattal',
	txtStatus: 'Állapot',
	eventAvailability : 'Elérhetőség',
	eventAvailabilityBusy : 'Elfoglalt',
	eventAvailabilityFree : 'Szabad',
	eventType: 'Adatvédelem',
	eventTypePublic: 'Nyilvános',
	eventTypePrivate: 'Magán',
	eventTypeConfidential: 'Bizalmas',
	txtPriority: 'Prioritás',
	txtPriorityNone: 'Semmilyen',
	txtPriorityLow: 'Alacsony',
	txtPriorityMedium: 'Közepes',
	txtPriorityHigh: 'Magas',
	eventURL : 'URL',
	repeatInterval: 'minden',
	repeatDays: 'nap',
	repeatWeeks: 'hét',
	repeatMonths: 'hónap',
	repeatYears: 'év',
	repeatChangeTxt: 'megváltozott a szerveren!',
	repeatChangeTxtClose: 'Zárja be az űrlapot, és nyissa meg az eseményt újra',
	repeatTodoChangeTxtClose: 'Zárja be az űrlapot, és nyissa meg a feladatot újra',
	calendarLoader: 'Újratöltés ...',
	resizeLoader: 'Átméretezés ...',

	monthNames: ['Január', 'Február', 'Március', 'Április', 'Május', 'Június',
	'Július', 'Augusztus', 'Szeptember', 'Október', 'November', 'December'],
	monthNamesShort: ['Jan', 'Feb', 'Már', 'Ápr', 'Máj', 'Jún',
	'Júl', 'Aug', 'Szep', 'Okt', 'Nov', 'Dec'],
	dayNames: ['Vasárnap', 'Hétfő', 'Kedd', 'Szerda', 'Csütörtök', 'Péntek', 'Szombat'],
	dayNamesShort: ['Vas', 'Hét', 'Ked', 'Sze', 'Csü', 'Pén', 'Szo'],
	dayNamesMin: ['V', 'H', 'K', 'Sze', 'Cs', 'P', 'Szo'],

	// TODOS
	pholderNameTODO: 'Cím',
	pholderNewTODO: 'Új feladat',
	txtTypeTODO: 'Típus',
	txtTypeTODONone: 'Egyszerű',
	txtTypeTODOStart: 'Kezdet időpontal',
	txtTypeTODODue: 'Határidő időpontal',
	txtTypeTODOBoth: 'Kezdet és határidő időpontal',
	txtDateFromTODO: 'Kezdet',
	txtDateToTODO: 'Határidő',
	txtCompletedOn: 'Befejeződött',

	pholderDateFromTODO: 'Kezdet dátum',
	pholderTimeFromTODO: 'Kezdet időpont',
	pholderDateToTODO: 'Határidő dátum',
	pholderTimeToTODO: 'Határidő időpont',
	pholderCompletedOnDate: 'Dátum',
	pholderCompletedOnTime: 'Időpont',

	txtStatusNeedsActionTODO: 'Foglalkozni kell vele',
	txtStatusCompletedTODO: 'Befejezve',
	txtStatusInProcessTODO: 'Folyamatban',
	txtStatusCancelledTODO: 'Megszakítva',
	txtPercentCompletedTODO: 'Befejezve',

	txtCalendarTODO: 'Naptár',
	txtSelectCalendarTODO: 'Válassz egy naptárat',
	txtAlertTODO: 'Emlékeztető',
	txtAlertNoneTODO: 'Nincs',
	txtAlertMessageTODO: 'Értesítés',
	txtAlertOnDateTODO: 'Egyéni',
	txtAlertWeeksBeforeTODO: 'Héttel előtte',
	txtAlertDaysBeforeTODO: 'Nappal előtte',
	txtAlertHoursBeforeTODO: 'Órával előtte',
	txtAlertMinutesBeforeTODO: 'Perccel előtte',
	txtAlertSecondsBeforeTODO: 'Másodperccel előtte',
	txtAlertWeeksAfterTODO: 'Héttel után',
	txtAlertDaysAfterTODO: 'Nappal után',
	txtAlertHoursAfterTODO: 'Órával után',
	txtAlertMinutesAfterTODO: 'Perccel után',
	txtAlertSecondsAfterTODO: 'Másodperccel után',

	pholderAfterBeforeValTODO: 'Érték',
	pholderAlarmDateTODO: 'Emlékeztető dátum',
	pholderAlarmTimeTODO: 'Emlékeztető időpont',

	pholderNoteTODO: 'Megjegyzés',
	txtNoteTODO: 'Megjegyzés',

	todoPrevNav: 'Mutasd az előző példányt',
	todoNextNav: 'Mutasd a következő példányt',
	todoUncompletedPrevNav: 'Mutasd az előző befejezetlen példányt',
	todoUncompletedNextNav: 'Mutasd a következő befejezetlen példányt',

	buttonSaveTODO: 'Mentés',
	buttonEditTODO: 'Szerkesztés',
	buttonResetTODO: 'Visszaállítás',
	buttonCloseTODO: 'Bezárás',
	buttonDeleteTODO: 'Törlés',

	// EVENTS
	pholderName: 'Cím',
	pholderNewEvent: 'Új esemény',
	txtLocation: 'Hely',
	pholderLocation: 'Hely',

	txtAllDay: 'Egész napos',
	from: 'Kezdet',
	to: 'Vége',

	pholderDateFrom: 'Kezdet dátum',
	pholderTimeFrom: 'Kezdet időpont',
	pholderDateTo: 'Határidő dátum',
	pholderTimeTo: 'Határidő időpont',

	txtStatusNone: 'Nem meghatározott',
	txtStatusTentative: 'Feltételes',
	txtStatusConfirmed: 'Megerősített',
	txtStatusCancelled: 'Törölt',

	txtRepeat: 'Ismétlés',
	txtNoRepeat: 'Nem ismétlődik',
	txtRepeatDay: 'Naponta',
	txtRepeatWeek: 'Hetente',
	txtRepeatWeekend: 'Minden hétköznap',
	txtRepeatMonth: 'Havonta',
	txtRepeatTwoWeek: 'Kéthetente',
	txtRepeatYear: 'Évente',
	txtRepeatCustomWeek: 'Egyéni hetente',
	txtRepeatCustomMonth: 'Egyéni havonta',
	txtRepeatCustomYear: 'Egyéni évente',
	txtRepeatWork: 'Minden munkanapon',
	txtRepeatOnDate: 'Egyéni',
	txtRepeatAfter: 'Ismétlődés után',
	txtRepeatNever: 'Soha',
	pholderUntilDate: 'Dátum-ig',
	pholderRepeatCount: 'Ismétlésszám',
	txtRepeatCustomWeekLabel: '/',
	txtRepeatCustomMonthLabel: '/',
	txtRepeatCustomMonthEvery: 'Minden',
	txtRepeatCustomMonthFirst: 'Első',
	txtRepeatCustomMonthSecond: 'Második',
	txtRepeatCustomMonthThird: 'Harmadik',
	txtRepeatCustomMonthFourth: 'Negyedik',
	txtRepeatCustomMonthFifth: 'Ötodik',
	txtRepeatCustomMonthLast: 'Utolsó',
	txtRepeatCustomMonthCustom: 'Egyéni',
	txtRepeatCustomMonthMonth: 'Nap a hónapban',
	txtRepeatCustomYearLabel1: 'minden',
	txtRepeatCustomYearLabel2: '/',
	txtrepeatEnd: 'vége',				// why the name is not txtRepeatEnd (case)?

	txtEventCalendar: 'Naptár',
	txtSelectCalendar: 'Válassz egy naptárat',
	txtAlert: 'Emlékeztető',
	txtAlertNone: 'Nincs',
	txtAlertMessage: 'Értesítés',
	txtAlertOnDate: 'Egyéni',
	txtAlertWeeksBefore: 'Héttel előtte',
	txtAlertDaysBefore: 'Nappal előtte',
	txtAlertHoursBefore: 'Órával előtte',
	txtAlertMinutesBefore: 'Perccel előtte',
	txtAlertSecondsBefore: 'Másodperccel előtte',
	txtAlertWeeksAfter: 'Héttel után',
	txtAlertDaysAfter: 'Nappal után',
	txtAlertHoursAfter: 'Órával után',
	txtAlertMinutesAfter: 'Perccel után',
	txtAlertSecondsAfter: 'Másodperccel után',

	pholderAfterBeforeVal: 'Érték',
	pholderAlarmDate: 'Emlékeztető dátum',
	pholderAlarmTime: 'Emlékeztető időpont',

	pholderNote: 'Megjegyzés',

	eventPrevNav: 'Mutasd az előző példányt',
	eventNextNav: 'Mutasd a következő befejezetlen példányt',

	buttonReset: 'Visszaállítás',
	buttonClose: 'Bezárás',

	txtAllSavedTodo: 'A feladat sikeresen elmentve!',
	txtAllSaved: 'Az esemény sikeresen elmentve!',

	txtAllDeletedTodo: 'A feladat sikeresen törölve!',
	txtAllDeleted: 'Az esemény sikeresen törölve!',

	txtNotChooseTodo: 'Hiba: naptárat kell választani!',
	txtNotChoose: 'Hiba: naptárat kell választani!',

	txtErrorDates: 'Hiba: a kezdési dátumnak korábbinak kell lennie a befejezési dátumnál!',
	txtErrorDatesTodo: 'Hiba: a kezdési dátumnak korábbinak kell lennie a befejezési dátumnál!',

	txtErorInputTodo: 'Hiba: javítsa ki a kijelölt érvénytelen értékeket!',
	txtDateTimeErrorTodo: 'Hiba: ki kell választani a dátumot és az időt!',

	txtErorInput: 'Hiba: javítsa ki a kijelölt érvénytelen értékeket!',

	txtAlertsH: 'Emlékeztetők',
	buttonAlert: 'Emlékeztetők eltávolítása',

	altAddEvent: 'Új esemény',
	altAddTodo: 'Új feladat',

	loadingCalendars: 'Naptárak betöltése (%act%/%total%) ...',

	errUnableSaveBeginCalDAV: 'Hiba: \'nem sikerült az esemény elmentése\': %%!',
	errUnableDeleteBeginCalDAV: 'Hiba: \'nem sikerült az esemény törlése\': %%!',
	CalDAVerrHttp410: 'az esemény már nem elérhető a szerveren',
	errUnableSaveTodoBeginCalDAV: 'Hiba: \'nem sikerült a feladat elmentése\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Hiba: \'nem sikerült a feladat törlése\': %%!',
	CalDAVerrTodoHttp410: 'a feladat már nem elérhető a szerveren'
}

localizationCalDAV['it_IT']=
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'&#8212;\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',
	_default_time_format_list_: 'd/M/yyyy',

	txtCalendar: 'Calendario',
	txtCalendars: 'Calendari',
	txtTodo: 'Attività',
	txtTodoLists: 'Lista Attività',
	txtSubscribed: 'Iscrizioni',
	fullCalendarMonth: 'mese',
	fullCalendarMultiWeek: 'msett.',
	fullCalendarAgendaWeek: 'sett.',
	fullCalendarAgendaDay: 'giorno',
	fullCalendarTable: 'tabella',
	fullCalendarTodayButton: 'oggi',
	fullCalendarAllDay: 'tutto il giorno',
	CalDAVsearch: 'Cerca',
	resourceEnable: 'Abilita tutti i calendari in questa risorsa',
	resourceDisable: 'Disabilita tutti i calendari in questa risorsa',
	allEnable: 'Abilita tutti i calendari',
	allDisable: 'Disabilita tutti i calendari',
	timezone: 'Fuso orario',
	txtTimezonePicker: 'Fuso orario:',
	loadingRList: 'Caricamento delle risorse in corso ...',
	renderingE: 'Elaborazione dei calendari in corso ...',
	timezoneChange: 'Applicazione nuovo fuso orario ...',
	localTime: 'Ora Locale',
	customTimezone: 'Personalizzato (Ora Locale)',
	loadPrevMonth: 'Carica mese precedente',
	loadNextMonth: 'Carica mese successivo',
	repeatBoxHead: 'Opzioni ripetizione evento',
	repeatBoxContent: 'è un evento con ripetizione.',
	repeatBoxQuestion: 'Su quali eventi desideri lavorare?',
	allEvsButton: 'Tutti gli eventi',
	allFutureButton: 'Questo e tutti gli eventi futuri',
	eventOnlyButton: 'Soltanto questo evento',
	repeatBoxContentTODO: 'è un\'attività ripetuta.',
	repeatBoxQuestionTODO: 'Su quali attività vorresti lavorare?',
	allEvsButtonTODO: 'Tutte le attività',
	allFutureButtonTODO: 'Questa e tutte le future attività',
	eventOnlyButtonTODO: 'Soltanto questa attività',
	txtStatus: 'Stato',
	eventAvailability : 'Disponibilità',
	eventAvailabilityBusy : 'Occupato',
	eventAvailabilityFree : 'Libero',
	eventType: 'Privacy',
	eventTypePublic: 'Pubblico',
	eventTypePrivate: 'Privato',
	eventTypeConfidential: 'Confidenziale',
	txtPriority: 'Priorità',
	txtPriorityNone: 'Nessuna',
	txtPriorityLow: 'Bassa',
	txtPriorityMedium: 'Media',
	txtPriorityHigh: 'Alta',
	eventURL : 'URL',
	repeatInterval: 'Tutti',
	repeatDays: 'giorni',
	repeatWeeks: 'settimane',
	repeatMonths: 'mesi',
	repeatYears: 'anni',
	repeatChangeTxt: 'è stato modificato sul server!',
	repeatChangeTxtClose: 'Chiudi il form e apri nuovamente l\'evento',
	repeatTodoChangeTxtClose: 'Chiudi e riapri l\'attività',
	calendarLoader: 'Aggiornamento ...',
	resizeLoader: 'Ridimensionamento ...',

	monthNames: ['Gennaio','Febbraio','Marzo','Aprile','Maggio','Giugno',
	'Luglio','Agosto','Settembre','Ottobre','Novembre','Dicembre'],
	monthNamesShort: ['Gen', 'Feb', 'Mar', 'Apr', 'Mag', 'Giu',
	'Lug', 'Ago', 'Set', 'Ott', 'Nov', 'Dic'],
	dayNames: ['Domenica', 'Lunedì', 'Martedì', 'Mercoledì', 'Giovedì', 'Venerdì', 'Sabato'],
	dayNamesShort: ['Dom', 'Lun', 'Mar', 'Mer', 'Gio', 'Ven', 'Sab'],
	dayNamesMin: ['Do','Lu','Ma','Me','Gi','Ve','Sa'],

	// TODOS
	pholderNameTODO: 'Nome',
	pholderNewTODO: 'Nuova Attività',
	txtTypeTODO: 'Tipo',
	txtTypeTODONone: 'Semplice',
	txtTypeTODOStart: 'Con orario d\'inizio',
	txtTypeTODODue: 'Con orario di termine',
	txtTypeTODOBoth: 'Con orari di inizio e termine',
	txtDateFromTODO: 'Da',
	txtDateToTODO: 'A',
	txtCompletedOn: 'Completato il',

	pholderDateFromTODO: 'Dal giorno',
	pholderTimeFromTODO: 'Dall ore',
	pholderDateToTODO: 'Al giorno',
	pholderTimeToTODO: 'Alle ore',
	pholderCompletedOnDate: 'Data',
	pholderCompletedOnTime: 'Ora',

	txtStatusNeedsActionTODO: 'Azione richiesta',
	txtStatusCompletedTODO: 'Completato',
	txtStatusInProcessTODO: 'In corso',
	txtStatusCancelledTODO: 'Annullato',
	txtPercentCompletedTODO: 'Completato',

	txtCalendarTODO: 'Calendario',
	txtSelectCalendarTODO: 'Seleziona un calendario',
	txtAlertTODO: 'Avviso',
	txtAlertNoneTODO: 'Nessuno',
	txtAlertMessageTODO: 'Messaggio',
	txtAlertOnDateTODO: 'Il giorno',
	txtAlertWeeksBeforeTODO: 'Settimane prima',
	txtAlertDaysBeforeTODO: 'Giorni prima',
	txtAlertHoursBeforeTODO: 'Ore prima',
	txtAlertMinutesBeforeTODO: 'Minuti prima',
	txtAlertSecondsBeforeTODO: 'Secondi prima',
	txtAlertWeeksAfterTODO: 'Settimane dopo',
	txtAlertDaysAfterTODO: 'Giorni dopo',
	txtAlertHoursAfterTODO: 'Ore dopo',
	txtAlertMinutesAfterTODO: 'Minuti dopo',
	txtAlertSecondsAfterTODO: 'Secondi dopo',

	pholderAfterBeforeValTODO: 'Valore',
	pholderAlarmDateTODO: 'Data sveglia',
	pholderAlarmTimeTODO: 'Orario sveglia',

	pholderNoteTODO: 'Nota',
	txtNoteTODO: 'Nota',

	todoPrevNav: 'Vai all\'attività precedente',
	todoNextNav: 'Vai all\'attività successiva',
	todoUncompletedPrevNav: 'Vai all\'attività non completata precedente',
	todoUncompletedNextNav: 'Vai all\'attività non completata successiva',

	buttonSaveTODO: 'Salva',
	buttonEditTODO: 'Modifica',
	buttonResetTODO: 'Annulla',
	buttonCloseTODO: 'Chiudi',
	buttonDeleteTODO: 'Elimina',

	// EVENTS
	pholderName: 'Nome',
	pholderNewEvent: 'Nuovo Evento',
	txtLocation: 'Luogo',
	pholderLocation: 'Luogo',

	txtAllDay: 'Tutto il giorno',
	from: 'Da',
	to: 'A',

	pholderDateFrom: 'Dal giorno',
	pholderTimeFrom: 'Dalle ore',
	pholderDateTo: 'Al giorno',
	pholderTimeTo: 'Alle ore',

	txtStatusNone: 'Unspecified',	// X
	txtStatusTentative: 'Tentative',	// X
	txtStatusConfirmed: 'Confirmed',	// X
	txtStatusCancelled: 'Cancelled',	// X

	txtRepeat: 'Ripeti',
	txtNoRepeat: 'Non ripetere',
	txtRepeatDay: 'Quotidianamente',
	txtRepeatWeek: 'Settimanalmente',
	txtRepeatWeekend: 'Ogni weekend',
	txtRepeatMonth: 'Mensilmente',
	txtRepeatTwoWeek: 'Bi-settimanalmente',
	txtRepeatYear: 'Annualmente',
	txtRepeatCustomWeek: 'Settimanalmente personalizzato',
	txtRepeatCustomMonth: 'Mensilmente personalizzato',
	txtRepeatCustomYear: 'Annualmente personalizzato',
	txtRepeatWork: 'Tutti i giorni lavorativi',
	txtRepeatOnDate: 'Il giorno',
	txtRepeatAfter: 'Ripetizioni',
	txtRepeatNever: 'Mai',
	pholderUntilDate: 'Fino alla data',
	pholderRepeatCount: 'Numero ripetizioni',
	txtRepeatCustomWeekLabel: 'Il',
	txtRepeatCustomMonthLabel: 'I giorni',
	txtRepeatCustomMonthEvery: 'Ogni',
	txtRepeatCustomMonthFirst: 'Primo',
	txtRepeatCustomMonthSecond: 'Secondo',
	txtRepeatCustomMonthThird: 'Terzo',
	txtRepeatCustomMonthFourth: 'Quarto',
	txtRepeatCustomMonthFifth: 'Quinto',
	txtRepeatCustomMonthLast: 'Ultimo',
	txtRepeatCustomMonthCustom: 'Personalizzato',
	txtRepeatCustomMonthMonth: 'Giorno del mese',
	txtRepeatCustomYearLabel1: 'Ogni',
	txtRepeatCustomYearLabel2: 'Di',

	txtrepeatEnd: 'Fine',
	txtEventCalendar: 'Calendario',
	txtSelectCalendar: 'Seleziona un calendario',
	txtAlert: 'Avviso',
	txtAlertNone: 'Nessuno',
	txtAlertMessage: 'Messaggio',
	txtAlertOnDate: 'Il giorno',
	txtAlertWeeksBefore: 'Settimane prima',
	txtAlertDaysBefore: 'Giorni prima',
	txtAlertHoursBefore: 'Ore prima',
	txtAlertMinutesBefore: 'Minuti prima',
	txtAlertSecondsBefore: 'Secondi prima',
	txtAlertWeeksAfter: 'Settimane dopo',
	txtAlertDaysAfter: 'Giorni dopo',
	txtAlertHoursAfter: 'Ore dopo',
	txtAlertMinutesAfter: 'Minuti dopo',
	txtAlertSecondsAfter: 'Secondi dopo',

	pholderAfterBeforeVal: 'Valore',
	pholderAlarmDate: 'Data sveglia',
	pholderAlarmTime: 'Orario sveglia',

	pholderNote: 'Nota',

	eventPrevNav: 'Vai all\'evento precedente',
	eventNextNav: 'Vai all\'evento successivo',

	buttonReset: 'Annulla',
	buttonClose: 'Chiudi',

	txtAllSavedTodo: 'Successo: Attività Salvata!',
	txtAllSaved: 'Successo: Evento Salvato!',

	txtAllDeletedTodo: 'Successo: Attività Eliminata!',
	txtAllDeleted: 'Successo: Evento Eliminato!',

	txtNotChooseTodo: 'Errore: è necessario selezionare un calendario!',
	txtNotChoose: 'Errore: è necessario selezionare un calendario!',

	txtErrorDates: 'Errore: la data di inizio deve essere antecedente alla data di fine!',
	txtErrorDatesTodo: 'Errore: la data di inizio deve essere antecedente alla data di fine!',

	txtErorInputTodo: 'Impossibile salvare: correggere i valori non validi!',
	txtDateTimeErrorTodo: 'E\' necessario selezionare data e ora',

	txtErorInput: 'Errore: \'impossibile salvare\': correggere i valori non validi evidenziati!',

	txtAlertsH: 'Avvisi',
	buttonAlert: 'Cancella avvisi',

	altAddEvent: 'Aggiungi Evento',
	altAddTodo: 'Aggiungi Attività',

	loadingCalendars: 'Caricamento calendari in corso (%act% di %total%) ...',

	errUnableSaveBeginCalDAV: 'Errore: \'impossibile salvare l\'evento\': %%!',
	errUnableDeleteBeginCalDAV: 'Error: \'impossibile eliminare l\'evento\': %%!',
	CalDAVerrHttp410: 'L\'evento non risulta più disponibile sul server',
	errUnableSaveTodoBeginCalDAV: 'Errore: \'impossibile salvare l\'attività\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Errore: \'impossibile eliminare l\'attività\': %%!',
	CalDAVerrTodoHttp410: 'L\'attività non risulta più disponibile sul server'
}

localizationCalDAV['nl_NL']=
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'&#8212;\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',
	_default_time_format_list_: 'd-M-yyyy',

	txtCalendar: 'Agenda',
	txtCalendars: 'Agenda’s',
	txtTodo: 'Taak',
	txtTodoLists: 'Takenlijsten',
	txtSubscribed: 'Andere bronnen',
	fullCalendarMonth: 'maand',
	fullCalendarMultiWeek: 'weken',
	fullCalendarAgendaWeek: 'week',
	fullCalendarAgendaDay: 'dag',
	fullCalendarTable: 'tabel',
	fullCalendarTodayButton: 'vandaag',
	fullCalendarAllDay: 'dag-omvattend',
	CalDAVsearch: 'Zoeken',
	resourceEnable: 'Alle agenda’s van deze bron aktiveren',
	resourceDisable: 'Alle agenda’s van deze bron deaktiveren',
	allEnable: 'Alle agenda’s aktiveren',
	allDisable: 'Alle agenda’s deaktiveren',
	timezone: 'Tijdzone',
	txtTimezonePicker: 'Tijdzone:',
	loadingRList: 'Bronnenlijst laden ...',
	renderingE: 'Kalenders opmaken ...',
	timezoneChange: 'Tijdzonewijziging uitvoeren ...',
	localTime: 'Plaatselijke tijd',
	customTimezone: 'Speciaal (Plaatselijke tijd)',
	loadPrevMonth: 'Vorige maand',
	loadNextMonth: 'Volgende maand',
	repeatBoxHead: 'Herhaalinstellingen',
	repeatBoxContent: 'is een herhalende afspraak.',
	repeatBoxQuestion: 'Welke afspraken wilt u bewerken?',
	allEvsButton: 'Alle afspraken',
	allFutureButton: 'Deze en alle volgende afspraken',
	eventOnlyButton: 'Alleen deze afspraak',
	repeatBoxContentTODO: 'is een herhalende taak.',
	repeatBoxQuestionTODO: 'Welke taken wilt u aanpassen?',
	allEvsButtonTODO: 'Alle taken',
	allFutureButtonTODO: 'Deze en toekomstige taken',
	eventOnlyButtonTODO: 'Alleen deze taak',
	txtStatus: 'Status',	// X
	eventAvailability : 'Beschikbaarheid',
	eventAvailabilityBusy : 'Bezet',
	eventAvailabilityFree : 'Vrij',
	eventType: 'Privacy',
	eventTypePublic: 'Openbaar',
	eventTypePrivate: 'Besloten',
	eventTypeConfidential: 'Vertrouwelijk',
	txtPriority: 'Prioriteit',
	txtPriorityNone: 'Geen',
	txtPriorityLow: 'Laag',
	txtPriorityMedium: 'Gemiddeld',
	txtPriorityHigh: 'Hoog',
	eventURL : 'URL',
	repeatInterval: 'Elke',
	repeatDays: 'dagen',
	repeatWeeks: 'weken',
	repeatMonths: 'maanden',
	repeatYears: 'jaar',
	repeatChangeTxt: 'is gewijzigd op de server!',
	repeatChangeTxtClose: 'Sluit dit formulier en open het opnieuw',
	repeatTodoChangeTxtClose: 'Sluit het formulier en heropen de taak',
	calendarLoader: 'Opnieuw laden ...',
	resizeLoader: 'Aanpassen ...',	// ???

	monthNames: ['Januari','Februari','Maart','April','Mei','Juni',
	'Juli','Augustus','September','Oktober','November','December'],
	monthNamesShort: ['Jan', 'Feb', 'Maa', 'Apr', 'Mei', 'Jun',
	'Jul', 'Aug', 'Sep', 'Okt', 'Nov', 'Dec'],
	dayNames: ['Zondag', 'Maandag', 'Dinsdag', 'Woensdag', 'Donderdag', 'Vrijdag', 'Zaterdag'],
	dayNamesShort: ['Zon', 'Maa', 'Din', 'Woe', 'Don', 'Vrij', 'Zat'],
	dayNamesMin: ['Zo', 'Ma', 'Di', 'Wo', 'Do', 'Vr', 'Za'],

	// TODOS
	pholderNameTODO: 'Naam',
	pholderNewTODO: 'Nieuwe taak',
	txtTypeTODO: 'Tijdstippen',
	txtTypeTODONone: 'Geen',
	txtTypeTODOStart: 'Met aanvangstijd',
	txtTypeTODODue: 'Met eindtijd',
	txtTypeTODOBoth: 'Met aanvangs- en eindtijd',
	txtDateFromTODO: 'Vanaf',
	txtDateToTODO: 'Tot',	// totaan? tot en met?
	txtCompletedOn: 'Afgehandeld op',

	pholderDateFromTODO: 'Datum vanaf',
	pholderTimeFromTODO: 'Tijd vanaf',
	pholderDateToTODO: 'Datum tot',	// totaan? tot en met?
	pholderTimeToTODO: 'Tijd tot',	// totaan? tot en met?
	pholderCompletedOnDate: 'Datum',
	pholderCompletedOnTime: 'Tijd',

	txtStatusNeedsActionTODO: 'Aktie nodig',
	txtStatusCompletedTODO: 'Afgewerkt',
	txtStatusInProcessTODO: 'In behandeling',
	txtStatusCancelledTODO: 'Vervallen',
	txtPercentCompletedTODO: 'Afgewerkt', // ???

	txtCalendarTODO: 'Agenda',
	txtSelectCalendarTODO: 'Kies een agenda',
	txtAlertTODO: 'Herinnering',
	txtAlertNoneTODO: 'Geen',
	txtAlertMessageTODO: 'Boodschap',
	txtAlertOnDateTODO: 'Op datum',
	txtAlertWeeksBeforeTODO: 'Weken tevoren',
	txtAlertDaysBeforeTODO: 'Dagen tevoren',
	txtAlertHoursBeforeTODO: 'Uren tevoren',
	txtAlertMinutesBeforeTODO: 'Minuten tevoren',
	txtAlertSecondsBeforeTODO: 'Seconden tevoren',
	txtAlertWeeksAfterTODO: 'Weken erna',
	txtAlertDaysAfterTODO: 'Dagen erna',
	txtAlertHoursAfterTODO: 'Uren erna',
	txtAlertMinutesAfterTODO: 'Minuten erna',
	txtAlertSecondsAfterTODO: 'Seconden erna',

	pholderAfterBeforeValTODO: 'Waarde',
	pholderAlarmDateTODO: 'Alarmdatum',
	pholderAlarmTimeTODO: 'Alarmtijn',

	pholderNoteTODO: 'Boodschap',
	txtNoteTODO: 'Boodschap',

	todoPrevNav: 'Toon vorige',
	todoNextNav: 'Toon volgende',
	todoUncompletedPrevNav: 'Toon eerstvorige onafgewerkte taak',
	todoUncompletedNextNav: 'Toon eerstvolgende onafgewerkte taak',

	buttonSaveTODO: 'Opslaan',
	buttonEditTODO: 'Wijzigen',
	buttonResetTODO: 'Herstellen',
	buttonCloseTODO: 'Sluiten',
	buttonDeleteTODO: 'Verwijderen',

	// EVENTS
	pholderName: 'Naam',
	pholderNewEvent: 'Nieuwe afspraak',
	txtLocation: 'Plaats',
	pholderLocation: 'Plaats',

	txtAllDay: 'Dag-omvattend',
	from: 'Vanaf',
	to: 'Tot',		// totaan??? tot en met???

	pholderDateFrom: 'Datum vanaf',
	pholderTimeFrom: 'Tijd vanaf',
	pholderDateTo: 'Datum tot',	// totaan??? tot en met???
	pholderTimeTo: 'Tijd tot',	// totaan??? tot en met???

	txtStatusNone: 'Unspecified',	// X
	txtStatusTentative: 'Tentative',	// X
	txtStatusConfirmed: 'Confirmed',	// X
	txtStatusCancelled: 'Cancelled',	// X

	txtRepeat: 'Herhalend',
	txtNoRepeat: 'Eenmalig',
	txtRepeatDay: 'Dagelijks',
	txtRepeatWeek: 'Wekelijks',
	txtRepeatWeekend: 'Elk weekend',
	txtRepeatMonth: 'Maandelijks',
	txtRepeatTwoWeek: 'Tweewekelijks',
	txtRepeatYear: 'Jaarlijks',
	txtRepeatCustomWeek: 'Aangepast wekelijks',
	txtRepeatCustomMonth: 'Aangepast maandelijks',
	txtRepeatCustomYear: 'Aangepast jaarlijks',
	txtRepeatWork: 'Elke werkdag',
	txtRepeatOnDate: 'Op datum',
	txtRepeatAfter: 'Herhalingen',
	txtRepeatNever: 'Nooit',
	pholderUntilDate: 'Datum tot',	// totaan??? tot en met???
	pholderRepeatCount: 'Aantal',
	txtRepeatCustomWeekLabel: 'Op',
	txtRepeatCustomMonthLabel: 'Op dag',
	txtRepeatCustomMonthEvery: 'Elke',
	txtRepeatCustomMonthFirst: 'Eerste',
	txtRepeatCustomMonthSecond: 'Tweede',
	txtRepeatCustomMonthThird: 'Derde',
	txtRepeatCustomMonthFourth: 'Vierde',
	txtRepeatCustomMonthFifth: 'Vijfde',
	txtRepeatCustomMonthLast: 'Laatste',
	txtRepeatCustomMonthCustom: 'Aangepast',
	txtRepeatCustomMonthMonth: 'Dag van de maand',
	txtRepeatCustomYearLabel1: 'Elke',
	txtRepeatCustomYearLabel2: 'Van',

	txtrepeatEnd: 'Einde',
	txtEventCalendar: 'Agenda',
	txtSelectCalendar: 'Kies een agenda',
	txtAlert: 'Boodschap',
	txtAlertNone: 'Geen',
	txtAlertMessage: 'Boodschap',
	txtAlertOnDate: 'Op datum',
	txtAlertWeeksBefore: 'Weken tevoren',
	txtAlertDaysBefore: 'Dagen tevoren',
	txtAlertHoursBefore: 'Uren tevoren',
	txtAlertMinutesBefore: 'Minuten tevoren',
	txtAlertSecondsBefore: 'Seconden tevoren',
	txtAlertWeeksAfter: 'Weken erna',
	txtAlertDaysAfter: 'Dagen erna',
	txtAlertHoursAfter: 'Uren erna',
	txtAlertMinutesAfter: 'Minuten erna',
	txtAlertSecondsAfter: 'Seconden erna',

	pholderAfterBeforeVal: 'Waarde',
	pholderAlarmDate: 'Alarmdatum',
	pholderAlarmTime: 'Alarmtijd',

	pholderNote: 'Boodschap',

	eventPrevNav: 'Toon vorige taak',
	eventNextNav: 'Toon volgende taak',

	buttonReset: 'Herstellen',
	buttonClose: 'Sluiten',

	txtAllSavedTodo: 'De taak is opgeslagen',
	txtAllSaved: 'De afspraak is opgeslagen',

	txtAllDeletedTodo: 'De taak is verwijderd',
	txtAllDeleted: 'De afspraak is verwijderd',

	txtNotChooseTodo: 'Fout: Kies eerst een agenda',
	txtNotChoose: 'Fout: Kies eerst een agenda',

	txtErrorDates: 'Fout: De begindatum mag niet na de einddatum vallen',
	txtErrorDatesTodo: 'Fout: De begindatum mag niet na de einddatum vallen',

	txtErorInputTodo: 'opslaan niet mogelijk, corrigeer eerst de foutieve gegevens',
	txtDateTimeErrorTodo: 'Kies eerst een datum en tijd',

	txtErorInput: 'Fout: opslaan niet mogelijk, corrigeer eerst de aangegeven gegevens',

	txtAlertsH: 'Alerts',
	buttonAlert: 'Alerts opheffen',

	altAddEvent: 'Afspraak aanmaken',
	altAddTodo: 'Taak aanmaken',

	loadingCalendars: 'Kalenders worden geladen (%act% van %total%) ...',

	errUnableSaveBeginCalDAV: 'Fout: de afspraak kon niet worden opgeslagen: %%',
	errUnableDeleteBeginCalDAV: 'Fout: de afspraak kon niet worden verwijderd: %%',
	CalDAVerrHttp410: 'Deze afspraak is niet langer beschikbaar op de server',
	errUnableSaveTodoBeginCalDAV: 'Fout: de taak kon niet worden opgeslagen: %%!',
	errUnableDeleteTodoBeginCalDAV: 'Fout: de taak kon niet worden verwijderd: %%!',
	CalDAVerrTodoHttp410: 'de taak is niet meer beschikbaar op de server'
}

localizationCalDAV['sk_SK']=
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'&#8212;\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',
	_default_time_format_list_: 'd.M.yyyy',

	txtCalendar: 'Kalendár',
	txtCalendars: 'Kalendáre',
	txtTodo: 'Pripomienky',
	txtTodoLists: 'Zoznam pripomienok',
	txtSubscribed: 'Odbery',
	fullCalendarMonth: 'mesiac',
	fullCalendarMultiWeek: 'mtýždeň',
	fullCalendarAgendaWeek: 'týždeň',
	fullCalendarAgendaDay: 'deň',
	fullCalendarTable: 'tabuľka',
	fullCalendarTodayButton: 'dnes',
	fullCalendarAllDay: 'celý deň',
	CalDAVsearch: 'Hľadať',
	resourceEnable: 'Zobraziť všetky kalendáre v danom prostriedku',
	resourceDisable: 'Schovať všetky kalendáre v danom prostriedku',
	allEnable: 'Zobraziť všetky kalendáre',
	allDisable: 'Schovať všetky kalendáre',
	timezone: 'Časové pásmo',
	txtTimezonePicker: 'Pásmo:',
	loadingRList: 'Načítavanie zoznamu prostriedkov ...',
	renderingE: 'Vykreslovanie kalendárov ...',
	timezoneChange: 'Aplikovanie zmeny časového pásma ...',
	localTime: 'Lokálny čas',
	customTimezone: 'Custom (Local Time)',
	loadPrevMonth: 'Načítať predchádzajúci mesiac',
	loadNextMonth: 'Načítať nasledujúci mesiac',
	repeatBoxHead: 'Možnosti opakovacej udalosti',
	repeatBoxContent: 'je opakovacia udalosť.',
	repeatBoxQuestion: 'S ktorými udalosťami chcete pracovať?',
	allEvsButton: 'Všetky udalosti',
	allFutureButton: 'Táto a všetky budúce udalosti',
	eventOnlyButton: 'Iba táto udalosť',
	repeatBoxContentTODO: 'je opakovacia pripomienka.',
	repeatBoxQuestionTODO: 'S ktorými pripomienkami chcete pracovať?',
	allEvsButtonTODO: 'Všetky pripomienky',
	allFutureButtonTODO: 'Táto a všetky budúce pripomienky',
	eventOnlyButtonTODO: 'Iba táto pripomienka',
	txtStatus: 'Stav',
	eventAvailability : 'Dostupnosť',
	eventAvailabilityBusy : 'Zaneprázdnený',
	eventAvailabilityFree : 'Voľný',
	eventType: 'Súkromie',
	eventTypePublic: 'Verejná',
	eventTypePrivate: 'Súkromná',
	eventTypeConfidential: 'Dôverná',
	txtPriority: 'Priority',
	txtPriorityNone: 'Žiadna',
	txtPriorityLow: 'Nízka',
	txtPriorityMedium: 'Stredná',
	txtPriorityHigh: 'Vysoká',
	eventURL : 'URL',
	repeatInterval: 'každých',
	repeatDays: 'dní',
	repeatWeeks: 'týždňov',
	repeatMonths: 'mesiacov',
	repeatYears: 'rokov',
	repeatChangeTxt: 'bol zmenený na serveri!',
	repeatChangeTxtClose: 'Zatvorte formulár a znova otvorte udalosť',
	repeatTodoChangeTxtClose: 'Zatvorte formulár a znova otvorte pripomienku.',
	calendarLoader: 'Znovunačítanie ...',
	resizeLoader: 'Prepočítavanie veľkosti ...',

	monthNames: ['Január','Február','Marec','Apríl','Máj','Jún',
	'Júl','August','September','Október','November','December'],
	monthNamesShort: ['Jan','Feb','Mar','Apr','Máj','Jún',
	'Júl','Aug','Sep','Okt','Nov','Dec'],
	dayNames: ['Nedeľa','Pondelok','Utorok','Streda','Štvrtok','Piatok','Sobota'],
	dayNamesShort: ['Ned','Pon','Uto','Str','Štv','Pia','Sob'],
	dayNamesMin: ['Ne','Po','Ut','St','Št','Pia','So'],

	// TODOS
	pholderNameTODO: 'Názov',
	pholderNewTODO: 'Nová pripomienka',
	txtTypeTODO: 'Typ',
	txtTypeTODONone: 'Jednoduchá',
	txtTypeTODOStart: 'S časom začiatku',
	txtTypeTODODue: 'S časom konca',
	txtTypeTODOBoth: 'S časmi začiatku aj konca',
	txtDateFromTODO: 'Od',
	txtDateToTODO: 'Do',
	txtCompletedOn: 'Dokončené ku',

	pholderDateFromTODO: 'Deň od',
	pholderTimeFromTODO: 'Čas od',
	pholderDateToTODO: 'Deň do',
	pholderTimeToTODO: 'Čas do',
	pholderCompletedOnDate: 'Deň',
	pholderCompletedOnTime: 'Čas',

	txtStatusNeedsActionTODO: 'Potrebuje akciu',
	txtStatusCompletedTODO: 'Dokončená',
	txtStatusInProcessTODO: 'Riešená',
	txtStatusCancelledTODO: 'Zrušená',
	txtPercentCompletedTODO: 'Dokončené',

	txtCalendarTODO: 'Kalendár',
	txtSelectCalendarTODO: 'Vyberte kalendár',
	txtAlertTODO: 'Alarm',
	txtAlertNoneTODO: 'Žiadny',
	txtAlertMessageTODO: 'Správa',
	txtAlertOnDateTODO: 'Na dátum',
	txtAlertWeeksBeforeTODO: 'Týždňov pred',
	txtAlertDaysBeforeTODO: 'Dní pred',
	txtAlertHoursBeforeTODO: 'Hodín pred',
	txtAlertMinutesBeforeTODO: 'Minút pred',
	txtAlertSecondsBeforeTODO: 'Sekúnd',
	txtAlertWeeksAfterTODO: 'Týždňov po',
	txtAlertDaysAfterTODO: 'Dní po',
	txtAlertHoursAfterTODO: 'Hodín po',
	txtAlertMinutesAfterTODO: 'Minút po',
	txtAlertSecondsAfterTODO: 'Sekúnd po',

	pholderAfterBeforeValTODO: 'Hodnota',
	pholderAlarmDateTODO: 'Deň alarmu',
	pholderAlarmTimeTODO: 'Čas alarmu',

	pholderNoteTODO: 'Poznámka',
	txtNoteTODO: 'Poznámka',

	todoPrevNav: 'Zobraziť prechádzajúcu inštanciu',
	todoNextNav: 'Zobraziť nasledujúcu inštanciu',
	todoUncompletedPrevNav: 'Zobraziť prechádzajúcu nedokončenú inštanciu',
	todoUncompletedNextNav: 'Zobraziť nasledujúcu nedokončenú inštanciu',

	buttonSaveTODO: 'Uložiť',
	buttonEditTODO: 'Editovať',
	buttonResetTODO: 'Reset',
	buttonCloseTODO: 'Zatvoriť',
	buttonDeleteTODO: 'Vymazať',

	// EVENTS
	pholderName: 'Názov',
	pholderNewEvent: 'Nová udalosť',
	txtLocation: 'Miesto',
	pholderLocation: 'Miesto',

	txtAllDay: 'Celý deň',
	from: 'Od',
	to: 'Do',

	pholderDateFrom: 'Deň od',
	pholderTimeFrom: 'Čas od',
	pholderDateTo: 'Deň do',
	pholderTimeTo: 'Čas do',

	txtStatusNone: 'Nešpecifikovaný',
	txtStatusTentative: 'Predbežná',
	txtStatusConfirmed: 'Potvrdená',
	txtStatusCancelled: 'Zrušená',

	txtRepeat: 'Opakovať',
	txtNoRepeat: 'Neopakovať',
	txtRepeatDay: 'Denne',
	txtRepeatWeek: 'Týždenne',
	txtRepeatWeekend: 'Každý víkend',
	txtRepeatMonth: 'Mesačne',
	txtRepeatTwoWeek: 'Dvojtýždenne',
	txtRepeatYear: 'Ročne',
	txtRepeatCustomWeek: 'Týždenne vlastné',
	txtRepeatCustomMonth: 'Mesačne vlastné',
	txtRepeatCustomYear: 'Ročne vlastné',
	txtRepeatWork: 'Každý pracovný deň',
	txtRepeatOnDate: 'Do dátumu',
	txtRepeatAfter: 'Výskytov',
	txtRepeatNever: 'Nikdy',
	pholderUntilDate: 'Do dňa',
	pholderRepeatCount: 'Počet opakovaní',
	txtRepeatCustomWeekLabel: 'deň',
	txtRepeatCustomMonthLabel: 'v dni',
	txtRepeatCustomMonthEvery: 'Každý',
	txtRepeatCustomMonthFirst: 'Prvý',
	txtRepeatCustomMonthSecond: 'Druhý',
	txtRepeatCustomMonthThird: 'Tretí',
	txtRepeatCustomMonthFourth: 'Štvrtý',
	txtRepeatCustomMonthFifth: 'Piaty',
	txtRepeatCustomMonthLast: 'Posledný',
	txtRepeatCustomMonthCustom: 'Vlastné',
	txtRepeatCustomMonthMonth: 'Deň v mesiaci',
	txtRepeatCustomYearLabel1: 'každý',
	txtRepeatCustomYearLabel2: 'v mesiaci',

	txtrepeatEnd: 'koniec',
	txtEventCalendar: 'Kalendár',
	txtSelectCalendar: 'Vyberte kalendár',
	txtAlert: 'Alarm',
	txtAlertNone: 'Žiadny',
	txtAlertMessage: 'Správa',
	txtAlertOnDate: 'Na dátum',
	txtAlertWeeksBefore: 'Týždňov pred',
	txtAlertDaysBefore: 'Dní pred',
	txtAlertHoursBefore: 'Hodín pred',
	txtAlertMinutesBefore: 'Minút pred',
	txtAlertSecondsBefore: 'Sekúnd',
	txtAlertWeeksAfter: 'Týždňov po',
	txtAlertDaysAfter: 'Dní po',
	txtAlertHoursAfter: 'Hodín po',
	txtAlertMinutesAfter: 'Minút po',
	txtAlertSecondsAfter: 'Sekúnd po',

	pholderAfterBeforeVal: 'Hodnota',
	pholderAlarmDate: 'Deň alarmu',
	pholderAlarmTime: 'Čas alarmu',

	pholderNote: 'Poznámka',

	eventPrevNav: 'Zobraziť prechádzajúcu inštanciu',
	eventNextNav: 'Zobraziť nasledujúcu inštanciu',

	buttonReset: 'Reset',
	buttonClose: 'Zatvoriť',

	txtAllSavedTodo: 'Pripomienka úspešne uložená!',
	txtAllSaved: 'Udalosť úspešne uložená!',

	txtAllDeletedTodo: 'Pripomienka úspešne vymazaná!',
	txtAllDeleted: 'Udalosť úspešne vymazaná!',

	txtNotChooseTodo: 'Chyba: Musíte zvoliť kalendár!',
	txtNotChoose: 'Chyba: Musíte zvoliť kalendár!',

	txtErorInputTodo: 'Chyba: opravte chybné hodnoty!',
	txtDateTimeErrorTodo: 'Chyba: Musíte zvoliť deň a čas!',

	txtErrorDates: 'Chyba: Čas začiatku musí byť pred koncom!',
	txtErrorDatesTodo: 'Chyba: Čas začiatku musí byť pred koncom!',

	txtErorInput: 'Chyba: opravte vyznačené chybné hodnoty!',

	txtAlertsH: 'Alarmy',
	buttonAlert: 'Zmazať alarmy',

	altAddEvent: 'Pridať udalosť',
	altAddTodo: 'Pridať pripomienku',

	loadingCalendars: 'Načítavanie kalendárov (%act% z %total%) ...',

	errUnableSaveBeginCalDAV: 'Chyba: \'nepodarilo sa uložiť udalosť\': %%!',
	errUnableDeleteBeginCalDAV: 'Chyba: \'nepodarilo sa vymazať udalosť\': %%!',
	CalDAVerrHttp410: 'Udalosť už nie je dostupná na serveri',
	errUnableSaveTodoBeginCalDAV: 'Chyba: \'nepodarilo sa uložiť pripomienku\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Chyba: \'nepodarilo sa vymazať pripomienku\': %%!',
	CalDAVerrTodoHttp410: 'Pripomienka už nie je dostupná na serveri'
}

localizationCalDAV['tr_TR']=	/* thanks Selcuk Pultar */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'&#8212;\'d MMM yyyy}',
	_default_title_format_day_: 'd MMM yyyy, ddd',
	_default_title_format_table_: 'MMM yyyy, ddd',
	_default_column_format_agenda_: 'd MMM, ddd',
	_default_time_format_list_: 'd-M-yyyy',

	txtCalendar: 'Takvimler',
	txtCalendars: 'Takvimler',
	txtTodo: 'Yapılacak',
	txtTodoLists: 'Yapılacak Listeleri',
	txtSubscribed: 'Abonelikler',
	fullCalendarMonth: 'ay',
	fullCalendarMultiWeek: 'çokluhafta',
	fullCalendarAgendaWeek: 'hafta',
	fullCalendarAgendaDay: 'gün',
	fullCalendarTable: 'tablo',
	fullCalendarTodayButton: 'bugün',
	fullCalendarAllDay: 'tüm gün',
	CalDAVsearch: 'Ara',
	resourceEnable: 'Bu kaynaktaki tüm takvimleri etkinleştir',
	resourceDisable: 'Bu kaynaktaki tüm takvimleri etkisizleştir',
	allEnable: 'Tüm takvimleri etkinleştir',
	allDisable: 'Tüm takvimleri etkisizleştir',
	timezone: 'Saat dilimi',
	txtTimezonePicker: 'Saat dilimi:',
	loadingRList: 'Kaynak listesi yükleniyor ...',
	renderingE: 'Takvimler oluşturuluyor ...',
	timezoneChange: 'Saat dilimi değişikliği uygulanıyor ...',
	localTime: 'Yerel Saat',
	customTimezone: 'Özel (Yerel Saat)',
	loadPrevMonth: 'Önceki ayı yükle',
	loadNextMonth: 'Sonraki ayı yükle',
	repeatBoxHead: 'Tekrar eden etkinlik seçenekleri',
	repeatBoxContent: 'tekrar eden bir etkinlik.',
	repeatBoxQuestion: 'Hangi etkinlikler üzerinde çalışmak istersiniz?',
	allEvsButton: 'Tüm etkinlikler',
	allFutureButton: 'Bu ve tüm gelecek etkinlikler',
	eventOnlyButton: 'Sadece bu etkinlik',
	repeatBoxContentTODO: 'tekrar eden bir yapılacak.',
	repeatBoxQuestionTODO: 'Hangi yapılacaklar üzerinde çalışmak istersiniz?',
	allEvsButtonTODO: 'Tüm yapılacaklar',
	allFutureButtonTODO: 'Bu ve tüm gelecek yapılacak',
	eventOnlyButtonTODO: 'Sadece bu yapılacak',
	txtStatus: 'Status',	// X
	eventAvailability : 'Müsaitlik',
	eventAvailabilityBusy : 'Meşgul',
	eventAvailabilityFree : 'Serbest',
	eventType: 'Mahremiyet',
	eventTypePublic: 'Halka açık',
	eventTypePrivate: 'Özel',
	eventTypeConfidential: 'Gizli',
	txtPriority: 'Öncelik',
	txtPriorityNone: 'Yok',
	txtPriorityLow: 'Düşük',
	txtPriorityMedium: 'Orta',
	txtPriorityHigh: 'Yüksek',
	eventURL : 'URL',
	repeatInterval: 'her',
	repeatDays: 'günler',
	repeatWeeks: 'haftalar',
	repeatMonths: 'aylar',
	repeatYears: 'yıllar',
	repeatChangeTxt: 'sunucuda değiştirilmiş!',
	repeatChangeTxtClose: 'Formu kapatıp etkinliği yeniden açın',
	repeatTodoChangeTxtClose: 'Formu kapatıp yapılacağı yeniden açın',
	calendarLoader: 'Yeniden yükleniyor ...',
	resizeLoader: 'Yeniden boyutlandırılıyor ...',

	monthNames: ['Ocak','Şubat','Mart','Nisan','Mayıs','Haziran',
	'Temmuz','Ağustos','Eylül','Ekim','Kasım','Aralık'],
	monthNamesShort: ['Oca', 'Şub', 'Mar', 'Nis', 'May', 'Haz',
	'Tem', 'Ağu', 'Eyl', 'Eki', 'Kas', 'Ara'],
	dayNames: ['Pazar', 'Pazartesi', 'Salı', 'Çarşamba', 'Perşembe', 'Cuma', 'Cumartesi'],
	dayNamesShort: ['Paz', 'Pts', 'Sal', 'Çar', 'Per', 'Cum', 'Cts'],
	dayNamesMin: ['Pz','Pt','Sa','Ça','Pe','Cu','Ct'],

	// TODOS
	pholderNameTODO: 'İsim',
	pholderNewTODO: 'Yeni Yapılacak',
	txtTypeTODO: 'Tür',
	txtTypeTODONone: 'Basit',
	txtTypeTODOStart: 'Başlangıç zamanı ile',
	txtTypeTODODue: 'Vadesi dolma zamanı ile',
	txtTypeTODOBoth: 'Hem başlangıç ve hemde vadesi dolma zamanı ile',
	txtDateFromTODO: 'Başlangıç',
	txtDateToTODO: 'Bitiş',
	txtCompletedOn: 'Tamamlandığı tarih',

	pholderDateFromTODO: 'Tarihten',
	pholderTimeFromTODO: 'Saatten',
	pholderDateToTODO: 'Tarihe',
	pholderTimeToTODO: 'Saate',
	pholderCompletedOnDate: 'Tarih',
	pholderCompletedOnTime: 'Saat',

	txtStatusNeedsActionTODO: 'Eylem gerektiriyor',
	txtStatusCompletedTODO: 'Tamamlandı',
	txtStatusInProcessTODO: 'İlerlemekte',
	txtStatusCancelledTODO: 'İptal edildi',
	txtPercentCompletedTODO: 'Tamamlandı',

	txtCalendarTODO: 'Takvim',
	txtSelectCalendarTODO: 'Bir takvim seçin',
	txtAlertTODO: 'Uyarı',
	txtAlertNoneTODO: 'Yok',
	txtAlertMessageTODO: 'Mesaj',
	txtAlertOnDateTODO: 'Tarihte',
	txtAlertWeeksBeforeTODO: 'Hafta önce',
	txtAlertDaysBeforeTODO: 'Gün önce',
	txtAlertHoursBeforeTODO: 'Saat önce',
	txtAlertMinutesBeforeTODO: 'Dakika önce',
	txtAlertSecondsBeforeTODO: 'Saniye önce',
	txtAlertWeeksAfterTODO: 'Hafta sonra',
	txtAlertDaysAfterTODO: 'Gün sonra',
	txtAlertHoursAfterTODO: 'Saat sonra',
	txtAlertMinutesAfterTODO: 'Dakika sonra',
	txtAlertSecondsAfterTODO: 'Saniye sonra',

	pholderAfterBeforeValTODO: 'Değer',
	pholderAlarmDateTODO: 'Alarm tarihi',
	pholderAlarmTimeTODO: 'Alarm saati',

	pholderNoteTODO: 'Not',
	txtNoteTODO: 'Not',

	todoPrevNav: 'Önceki gerçekleşmesini göster',
	todoNextNav: 'Sonraki gerçekleşmesini göster',
	todoUncompletedPrevNav: 'Önceki tamamlanmamış gerçekleşmesini göster',
	todoUncompletedNextNav: 'Sonraki tamamlanmamış gerçekleşmesini göster',

	buttonSaveTODO: 'Kaydet',
	buttonEditTODO: 'Düzenle',
	buttonResetTODO: 'Geri döndür',
	buttonCloseTODO: 'Kapat',
	buttonDeleteTODO: 'Sil',

	// EVENTS
	pholderName: 'İsim',
	pholderNewEvent: 'Yeni etkinlik',
	txtLocation: 'Yer',
	pholderLocation: 'Yer',

	txtAllDay: 'Tüm gün',
	from: 'Başlangıç',
	to: 'Bitiş',

	pholderDateFrom: 'Tarihten',
	pholderTimeFrom: 'Saatten',
	pholderDateTo: 'Tarihe',
	pholderTimeTo: 'Saate',

	txtStatusNone: 'Unspecified',		// X
	txtStatusTentative: 'Tentative',	// X
	txtStatusConfirmed: 'Confirmed',	// X
	txtStatusCancelled: 'Cancelled',	// X

	txtRepeat: 'Tekrar et',
	txtNoRepeat: 'Tekrar etme',
	txtRepeatDay: 'Günde bir',
	txtRepeatWeek: 'Haftada bir',
	txtRepeatWeekend: 'Her haftasonu',
	txtRepeatMonth: 'Ayda bir',
	txtRepeatTwoWeek: 'İki haftada bir',
	txtRepeatYear: 'Yılda bir',
	txtRepeatCustomWeek: 'Özel haftada bir',
	txtRepeatCustomMonth: 'Özel ayda bir',
	txtRepeatCustomYear: 'Özel yılda bir',
	txtRepeatWork: 'Her iş günü',
	txtRepeatOnDate: 'Tarihinde',
	txtRepeatAfter: 'Kereden sonra',
	txtRepeatNever: 'Hiç bir zaman',
	pholderUntilDate: 'Tarihine kadar',
	pholderRepeatCount: 'Tekrar sayısı',
	txtRepeatCustomWeekLabel: 'taihinde',
	txtRepeatCustomMonthLabel: 'günlerinde',
	txtRepeatCustomMonthEvery: 'Her',
	txtRepeatCustomMonthFirst: 'İlk',
	txtRepeatCustomMonthSecond: 'İkinci',
	txtRepeatCustomMonthThird: 'Üçüncü',
	txtRepeatCustomMonthFourth: 'Dördüncü',
	txtRepeatCustomMonthFifth: 'Beşinci',
	txtRepeatCustomMonthLast: 'Son',
	txtRepeatCustomMonthCustom: 'Özel',
	txtRepeatCustomMonthMonth: 'Ayın gününde',
	txtRepeatCustomYearLabel1: 'her',
	txtRepeatCustomYearLabel2: 'nin',

	txtrepeatEnd: 'son',
	txtEventCalendar: 'Takvim',
	txtSelectCalendar: 'Bir takvim seçin',
	txtAlert: 'Uyarı',
	txtAlertNone: 'Yok',
	txtAlertMessage: 'Mesaj',
	txtAlertOnDate: 'Tarihinde',
	txtAlertWeeksBefore: 'Hafta önce',
	txtAlertDaysBefore: 'Gün önce',
	txtAlertHoursBefore: 'Saat önce',
	txtAlertMinutesBefore: 'Dakika önce',
	txtAlertSecondsBefore: 'Saniye önce',
	txtAlertWeeksAfter: 'Hafta sonra',
	txtAlertDaysAfter: 'Gün sonra',
	txtAlertHoursAfter: 'Saat sonra',
	txtAlertMinutesAfter: 'Dakika sonra',
	txtAlertSecondsAfter: 'Saniye sonra',

	pholderAfterBeforeVal: 'Değer',
	pholderAlarmDate: 'Alarm tarihi',
	pholderAlarmTime: 'Alarm saati',

	pholderNote: 'Not',

	eventPrevNav: 'Önceki gerçekleşmesini göster',
	eventNextNav: 'Sonraki gerçekleşmesini göster',

	buttonReset: 'Geri döndür',
	buttonClose: 'Kapat',

	txtAllSavedTodo: 'Başarılı: Yapılacak kaydedildi!',
	txtAllSaved: 'Başarılı: Etkinlik kaydedildi!',

	txtAllDeletedTodo: 'Başarılı: Yapılacak silindi!',
	txtAllDeleted: 'Başarılı: Etkinlik silindi!',

	txtNotChooseTodo: 'Hata: Takvim seçmeniz gerek!',
	txtNotChoose: 'Hata: Takvim seçmeniz gerek!',

	txtErrorDates: 'Hata: Başlangıç tarihi bitiş tarihinden önce olmalıdır!',
	txtErrorDatesTodo: 'Hata: Başlangıç tarihi bitiş tarihinden önce olmalıdır!',

	txtErorInputTodo: 'Kaydedilemedi: hatalı değerleri düzeltin!',
	txtDateTimeErrorTodo: 'Taih ve saat seçmeniz gerekiyor!',

	txtErorInput: 'Hata: \'kaydedilemedi\': renklendirilmiş hatalı değerleri düzeltin!',

	txtAlertsH: 'Uyarılar',
	buttonAlert: 'Uyarıları temizle',

	altAddEvent: 'Etkinlik ekle',
	altAddTodo: 'Yapılacak ekle',

	loadingCalendars: 'Takvimler yükleniyor (%total% taneden %act%) ...',

	errUnableSaveBeginCalDAV: 'Hata: \'etkinlik kaydedilemedi\': %%!',
	errUnableDeleteBeginCalDAV: 'Hata: \'etkinlik silinemedi\': %%!',
	CalDAVerrHttp410: 'Etkinlik artık sunucuda mevcut değil',
	errUnableSaveTodoBeginCalDAV: 'Hata: \'yapılacak kaydedilemedi\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Hata: \'yapılacak silinemedi\': %%!',
	CalDAVerrTodoHttp410: 'Yapılacak artık sunucuda mevcut değil'
}

$.extend(true, localization, localizationCalDAV);
